<?php

namespace EnumType;

/**
 * This class stands for List_RecycledProducts_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel. | An open list of recycled products.
 * @subpackage Enumerations
 */
class List_RecycledProducts_Base
{
    /**
     * Constant for value 'Aluminum'
     * @return string 'Aluminum'
     */
    const VALUE_ALUMINUM = 'Aluminum';
    /**
     * Constant for value 'Batteries'
     * @return string 'Batteries'
     */
    const VALUE_BATTERIES = 'Batteries';
    /**
     * Constant for value 'ComputerParts'
     * @return string 'ComputerParts'
     */
    const VALUE_COMPUTER_PARTS = 'ComputerParts';
    /**
     * Constant for value 'Glass'
     * @return string 'Glass'
     */
    const VALUE_GLASS = 'Glass';
    /**
     * Constant for value 'Lightbulbs'
     * @return string 'Lightbulbs'
     */
    const VALUE_LIGHTBULBS = 'Lightbulbs';
    /**
     * Constant for value 'Paper'
     * @return string 'Paper'
     */
    const VALUE_PAPER = 'Paper';
    /**
     * Constant for value 'Plastic'
     * @return string 'Plastic'
     */
    const VALUE_PLASTIC = 'Plastic';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALUMINUM
     * @uses self::VALUE_BATTERIES
     * @uses self::VALUE_COMPUTER_PARTS
     * @uses self::VALUE_GLASS
     * @uses self::VALUE_LIGHTBULBS
     * @uses self::VALUE_PAPER
     * @uses self::VALUE_PLASTIC
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALUMINUM,
            self::VALUE_BATTERIES,
            self::VALUE_COMPUTER_PARTS,
            self::VALUE_GLASS,
            self::VALUE_LIGHTBULBS,
            self::VALUE_PAPER,
            self::VALUE_PLASTIC,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
