<?php

namespace EnumType;

/**
 * This class stands for List_RatePlanType_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Note: Typically used for rate plans that may be published, e.g. have no qualifying criteria, or may be restricted or negotiated, e.g. has qualifying criteria for eligibility and/or has been negotiated between parties. | Source: Rate
 * Plan Type (RPT) OpenTravel codelist. | An open list of published rate plan types and/or categories.
 * @subpackage Enumerations
 */
class List_RatePlanType_Base
{
    /**
     * Constant for value 'Association'
     * @return string 'Association'
     */
    const VALUE_ASSOCIATION = 'Association';
    /**
     * Constant for value 'ClubConcierge'
     * @return string 'ClubConcierge'
     */
    const VALUE_CLUB_CONCIERGE = 'ClubConcierge';
    /**
     * Constant for value 'Consortia '
     * @return string 'Consortia '
     */
    const VALUE_CONSORTIA = 'Consortia ';
    /**
     * Constant for value 'Contract'
     * @return string 'Contract'
     */
    const VALUE_CONTRACT = 'Contract';
    /**
     * Constant for value 'Convention'
     * @return string 'Convention'
     */
    const VALUE_CONVENTION = 'Convention';
    /**
     * Constant for value 'Corporate'
     * @return string 'Corporate'
     */
    const VALUE_CORPORATE = 'Corporate';
    /**
     * Constant for value 'DayRate'
     * @return string 'DayRate'
     */
    const VALUE_DAY_RATE = 'DayRate';
    /**
     * Constant for value 'DistressedInventory'
     * @return string 'DistressedInventory'
     */
    const VALUE_DISTRESSED_INVENTORY = 'DistressedInventory';
    /**
     * Constant for value 'FamilyPlan'
     * @return string 'FamilyPlan'
     */
    const VALUE_FAMILY_PLAN = 'FamilyPlan';
    /**
     * Constant for value 'Government'
     * @return string 'Government'
     */
    const VALUE_GOVERNMENT = 'Government';
    /**
     * Constant for value 'Group'
     * @return string 'Group'
     */
    const VALUE_GROUP = 'Group';
    /**
     * Constant for value 'LastRoomAvailable'
     * @return string 'LastRoomAvailable'
     */
    const VALUE_LAST_ROOM_AVAILABLE = 'LastRoomAvailable';
    /**
     * Constant for value 'Military'
     * @return string 'Military'
     */
    const VALUE_MILITARY = 'Military';
    /**
     * Constant for value 'Monthly'
     * @return string 'Monthly'
     */
    const VALUE_MONTHLY = 'Monthly';
    /**
     * Constant for value 'Multi-DayPackage'
     * @return string 'Multi-DayPackage'
     */
    const VALUE_MULTI_DAY_PACKAGE = 'Multi-DayPackage';
    /**
     * Constant for value 'Negotiated'
     * @return string 'Negotiated'
     */
    const VALUE_NEGOTIATED = 'Negotiated';
    /**
     * Constant for value 'Net'
     * @return string 'Net'
     */
    const VALUE_NET = 'Net';
    /**
     * Constant for value 'NonLastRoomAvailable'
     * @return string 'NonLastRoomAvailable'
     */
    const VALUE_NON_LAST_ROOM_AVAILABLE = 'NonLastRoomAvailable';
    /**
     * Constant for value 'Package'
     * @return string 'Package'
     */
    const VALUE_PACKAGE = 'Package';
    /**
     * Constant for value 'Promotional'
     * @return string 'Promotional'
     */
    const VALUE_PROMOTIONAL = 'Promotional';
    /**
     * Constant for value 'PromotionalPackageTour'
     * @return string 'PromotionalPackageTour'
     */
    const VALUE_PROMOTIONAL_PACKAGE_TOUR = 'PromotionalPackageTour';
    /**
     * Constant for value 'Published'
     * @return string 'Published'
     */
    const VALUE_PUBLISHED = 'Published';
    /**
     * Constant for value 'RegularRack'
     * @return string 'RegularRack'
     */
    const VALUE_REGULAR_RACK = 'RegularRack';
    /**
     * Constant for value 'SeniorCitizen'
     * @return string 'SeniorCitizen'
     */
    const VALUE_SENIOR_CITIZEN = 'SeniorCitizen';
    /**
     * Constant for value 'TourWholesale'
     * @return string 'TourWholesale'
     */
    const VALUE_TOUR_WHOLESALE = 'TourWholesale';
    /**
     * Constant for value 'TravelIndustry'
     * @return string 'TravelIndustry'
     */
    const VALUE_TRAVEL_INDUSTRY = 'TravelIndustry';
    /**
     * Constant for value 'Weekend '
     * @return string 'Weekend '
     */
    const VALUE_WEEKEND = 'Weekend ';
    /**
     * Constant for value 'Weekly'
     * @return string 'Weekly'
     */
    const VALUE_WEEKLY = 'Weekly';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ASSOCIATION
     * @uses self::VALUE_CLUB_CONCIERGE
     * @uses self::VALUE_CONSORTIA
     * @uses self::VALUE_CONTRACT
     * @uses self::VALUE_CONVENTION
     * @uses self::VALUE_CORPORATE
     * @uses self::VALUE_DAY_RATE
     * @uses self::VALUE_DISTRESSED_INVENTORY
     * @uses self::VALUE_FAMILY_PLAN
     * @uses self::VALUE_GOVERNMENT
     * @uses self::VALUE_GROUP
     * @uses self::VALUE_LAST_ROOM_AVAILABLE
     * @uses self::VALUE_MILITARY
     * @uses self::VALUE_MONTHLY
     * @uses self::VALUE_MULTI_DAY_PACKAGE
     * @uses self::VALUE_NEGOTIATED
     * @uses self::VALUE_NET
     * @uses self::VALUE_NON_LAST_ROOM_AVAILABLE
     * @uses self::VALUE_PACKAGE
     * @uses self::VALUE_PROMOTIONAL
     * @uses self::VALUE_PROMOTIONAL_PACKAGE_TOUR
     * @uses self::VALUE_PUBLISHED
     * @uses self::VALUE_REGULAR_RACK
     * @uses self::VALUE_SENIOR_CITIZEN
     * @uses self::VALUE_TOUR_WHOLESALE
     * @uses self::VALUE_TRAVEL_INDUSTRY
     * @uses self::VALUE_WEEKEND
     * @uses self::VALUE_WEEKLY
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ASSOCIATION,
            self::VALUE_CLUB_CONCIERGE,
            self::VALUE_CONSORTIA,
            self::VALUE_CONTRACT,
            self::VALUE_CONVENTION,
            self::VALUE_CORPORATE,
            self::VALUE_DAY_RATE,
            self::VALUE_DISTRESSED_INVENTORY,
            self::VALUE_FAMILY_PLAN,
            self::VALUE_GOVERNMENT,
            self::VALUE_GROUP,
            self::VALUE_LAST_ROOM_AVAILABLE,
            self::VALUE_MILITARY,
            self::VALUE_MONTHLY,
            self::VALUE_MULTI_DAY_PACKAGE,
            self::VALUE_NEGOTIATED,
            self::VALUE_NET,
            self::VALUE_NON_LAST_ROOM_AVAILABLE,
            self::VALUE_PACKAGE,
            self::VALUE_PROMOTIONAL,
            self::VALUE_PROMOTIONAL_PACKAGE_TOUR,
            self::VALUE_PUBLISHED,
            self::VALUE_REGULAR_RACK,
            self::VALUE_SENIOR_CITIZEN,
            self::VALUE_TOUR_WHOLESALE,
            self::VALUE_TRAVEL_INDUSTRY,
            self::VALUE_WEEKEND,
            self::VALUE_WEEKLY,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
