<?php

namespace EnumType;

/**
 * This class stands for List_Proximity_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel. | A closed list of proximities.
 * @subpackage Enumerations
 */
class List_Proximity_Base
{
    /**
     * Constant for value 'Nearby'
     * @return string 'Nearby'
     */
    const VALUE_NEARBY = 'Nearby';
    /**
     * Constant for value 'NotSpecified'
     * @return string 'NotSpecified'
     */
    const VALUE_NOT_SPECIFIED = 'NotSpecified';
    /**
     * Constant for value 'Offsite'
     * @return string 'Offsite'
     */
    const VALUE_OFFSITE = 'Offsite';
    /**
     * Constant for value 'Onsite'
     * @return string 'Onsite'
     */
    const VALUE_ONSITE = 'Onsite';
    /**
     * Constant for value 'OnsiteAndOffsite'
     * @return string 'OnsiteAndOffsite'
     */
    const VALUE_ONSITE_AND_OFFSITE = 'OnsiteAndOffsite';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEARBY
     * @uses self::VALUE_NOT_SPECIFIED
     * @uses self::VALUE_OFFSITE
     * @uses self::VALUE_ONSITE
     * @uses self::VALUE_ONSITE_AND_OFFSITE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEARBY,
            self::VALUE_NOT_SPECIFIED,
            self::VALUE_OFFSITE,
            self::VALUE_ONSITE,
            self::VALUE_ONSITE_AND_OFFSITE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
