<?php

namespace EnumType;

/**
 * This class stands for List_PowerType_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel. | An open list of power types.
 * @subpackage Enumerations
 */
class List_PowerType_Base
{
    /**
     * Constant for value 'Diesel'
     * @return string 'Diesel'
     */
    const VALUE_DIESEL = 'Diesel';
    /**
     * Constant for value 'Electric'
     * @return string 'Electric'
     */
    const VALUE_ELECTRIC = 'Electric';
    /**
     * Constant for value 'Gas'
     * @return string 'Gas'
     */
    const VALUE_GAS = 'Gas';
    /**
     * Constant for value 'Oil'
     * @return string 'Oil'
     */
    const VALUE_OIL = 'Oil';
    /**
     * Constant for value 'Solar'
     * @return string 'Solar'
     */
    const VALUE_SOLAR = 'Solar';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DIESEL
     * @uses self::VALUE_ELECTRIC
     * @uses self::VALUE_GAS
     * @uses self::VALUE_OIL
     * @uses self::VALUE_SOLAR
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DIESEL,
            self::VALUE_ELECTRIC,
            self::VALUE_GAS,
            self::VALUE_OIL,
            self::VALUE_SOLAR,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
