<?php

namespace EnumType;

/**
 * This class stands for List_OfferVehicleClass EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Vehicle Size (VEH) OpenTravel codelist. | Rental vehicle classes for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferVehicleClass
{
    /**
     * Constant for value 'Compact/Economy'
     * @return string 'Compact/Economy'
     */
    const VALUE_COMPACT_ECONOMY = 'Compact/Economy';
    /**
     * Constant for value 'Exotic'
     * @return string 'Exotic'
     */
    const VALUE_EXOTIC = 'Exotic';
    /**
     * Constant for value 'Fullsize'
     * @return string 'Fullsize'
     */
    const VALUE_FULLSIZE = 'Fullsize';
    /**
     * Constant for value 'FuelEfficient'
     * @return string 'FuelEfficient'
     */
    const VALUE_FUEL_EFFICIENT = 'FuelEfficient';
    /**
     * Constant for value 'Intermediate/Midsize'
     * @return string 'Intermediate/Midsize'
     */
    const VALUE_INTERMEDIATE_MIDSIZE = 'Intermediate/Midsize';
    /**
     * Constant for value 'LargeSUV'
     * @return string 'LargeSUV'
     */
    const VALUE_LARGE_SUV = 'LargeSUV';
    /**
     * Constant for value 'Luxury/Premium'
     * @return string 'Luxury/Premium'
     */
    const VALUE_LUXURY_PREMIUM = 'Luxury/Premium';
    /**
     * Constant for value 'Minivan'
     * @return string 'Minivan'
     */
    const VALUE_MINIVAN = 'Minivan';
    /**
     * Constant for value 'Standard'
     * @return string 'Standard'
     */
    const VALUE_STANDARD = 'Standard';
    /**
     * Constant for value 'Stretch'
     * @return string 'Stretch'
     */
    const VALUE_STRETCH = 'Stretch';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COMPACT_ECONOMY
     * @uses self::VALUE_EXOTIC
     * @uses self::VALUE_FULLSIZE
     * @uses self::VALUE_FUEL_EFFICIENT
     * @uses self::VALUE_INTERMEDIATE_MIDSIZE
     * @uses self::VALUE_LARGE_SUV
     * @uses self::VALUE_LUXURY_PREMIUM
     * @uses self::VALUE_MINIVAN
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_STRETCH
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMPACT_ECONOMY,
            self::VALUE_EXOTIC,
            self::VALUE_FULLSIZE,
            self::VALUE_FUEL_EFFICIENT,
            self::VALUE_INTERMEDIATE_MIDSIZE,
            self::VALUE_LARGE_SUV,
            self::VALUE_LUXURY_PREMIUM,
            self::VALUE_MINIVAN,
            self::VALUE_STANDARD,
            self::VALUE_STRETCH,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
