<?php

namespace EnumType;

/**
 * This class stands for List_OfferRateCategory EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Rate Category (RTC) OpenTravel codelist. | Rate categories for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferRateCategory
{
    /**
     * Constant for value 'Association'
     * @return string 'Association'
     */
    const VALUE_ASSOCIATION = 'Association';
    /**
     * Constant for value 'Business'
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Constant for value 'Convention'
     * @return string 'Convention'
     */
    const VALUE_CONVENTION = 'Convention';
    /**
     * Constant for value 'Corporate'
     * @return string 'Corporate'
     */
    const VALUE_CORPORATE = 'Corporate';
    /**
     * Constant for value 'Employee'
     * @return string 'Employee'
     */
    const VALUE_EMPLOYEE = 'Employee';
    /**
     * Constant for value 'Government'
     * @return string 'Government'
     */
    const VALUE_GOVERNMENT = 'Government';
    /**
     * Constant for value 'Leisure'
     * @return string 'Leisure'
     */
    const VALUE_LEISURE = 'Leisure';
    /**
     * Constant for value 'Negotiated'
     * @return string 'Negotiated'
     */
    const VALUE_NEGOTIATED = 'Negotiated';
    /**
     * Constant for value 'Promotional'
     * @return string 'Promotional'
     */
    const VALUE_PROMOTIONAL = 'Promotional';
    /**
     * Constant for value 'Standard'
     * @return string 'Standard'
     */
    const VALUE_STANDARD = 'Standard';
    /**
     * Constant for value 'VIP'
     * @return string 'VIP'
     */
    const VALUE_VIP = 'VIP';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ASSOCIATION
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_CONVENTION
     * @uses self::VALUE_CORPORATE
     * @uses self::VALUE_EMPLOYEE
     * @uses self::VALUE_GOVERNMENT
     * @uses self::VALUE_LEISURE
     * @uses self::VALUE_NEGOTIATED
     * @uses self::VALUE_PROMOTIONAL
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_VIP
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ASSOCIATION,
            self::VALUE_BUSINESS,
            self::VALUE_CONVENTION,
            self::VALUE_CORPORATE,
            self::VALUE_EMPLOYEE,
            self::VALUE_GOVERNMENT,
            self::VALUE_LEISURE,
            self::VALUE_NEGOTIATED,
            self::VALUE_PROMOTIONAL,
            self::VALUE_STANDARD,
            self::VALUE_VIP,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
