<?php

namespace EnumType;

/**
 * This class stands for List_OfferPropertyClassType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Property Class Type (PCT) OpenTravel codelist. | Property classification types for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferPropertyClassType
{
    /**
     * Constant for value 'ConferenceMeeting'
     * Meta information extracted from the WSDL
     * - documentation: A property with a combination of conference facilities and guest rooms.
     * @return string 'ConferenceMeeting'
     */
    const VALUE_CONFERENCE_MEETING = 'ConferenceMeeting';
    /**
     * Constant for value 'Corporate'
     * Meta information extracted from the WSDL
     * - documentation: A property that accommodates corporate negotiated rates and/or is company policy mandated for traveling employees.
     * @return string 'Corporate'
     */
    const VALUE_CORPORATE = 'Corporate';
    /**
     * Constant for value 'Budget/Economy/Hostel'
     * Meta information extracted from the WSDL
     * - documentation: A property with room rates that are lower than the area average.
     * @return string 'Budget/Economy/Hostel'
     */
    const VALUE_BUDGET_ECONOMY_HOSTEL = 'Budget/Economy/Hostel';
    /**
     * Constant for value 'ExtendedStay'
     * Meta information extracted from the WSDL
     * - documentation: A property that offers extended stay accommodations with typical reservations two weeks or greater in length.
     * @return string 'ExtendedStay'
     */
    const VALUE_EXTENDED_STAY = 'ExtendedStay';
    /**
     * Constant for value 'Golf'
     * Meta information extracted from the WSDL
     * - documentation: A property that has a golf facility onsite or nearby.
     * @return string 'Golf'
     */
    const VALUE_GOLF = 'Golf';
    /**
     * Constant for value 'Luxury/Upscale/Resort'
     * Meta information extracted from the WSDL
     * - documentation: A property with higher than average features, amenities, services and room rates.
     * @return string 'Luxury/Upscale/Resort'
     */
    const VALUE_LUXURY_UPSCALE_RESORT = 'Luxury/Upscale/Resort';
    /**
     * Constant for value 'Midscale'
     * Meta information extracted from the WSDL
     * - documentation: A property with room rates that are average for the area.
     * @return string 'Midscale'
     */
    const VALUE_MIDSCALE = 'Midscale';
    /**
     * Constant for value 'Ski'
     * Meta information extracted from the WSDL
     * - documentation: A property that has a ski facility onsite or nearby.
     * @return string 'Ski'
     */
    const VALUE_SKI = 'Ski';
    /**
     * Constant for value 'Spa'
     * Meta information extracted from the WSDL
     * - documentation: A property that has a spa onsite or nearby.
     * @return string 'Spa'
     */
    const VALUE_SPA = 'Spa';
    /**
     * Constant for value 'VacationRental'
     * Meta information extracted from the WSDL
     * - documentation: A private house or timeshare property that typically accommodates vacationing travelers.
     * @return string 'VacationRental'
     */
    const VALUE_VACATION_RENTAL = 'VacationRental';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONFERENCE_MEETING
     * @uses self::VALUE_CORPORATE
     * @uses self::VALUE_BUDGET_ECONOMY_HOSTEL
     * @uses self::VALUE_EXTENDED_STAY
     * @uses self::VALUE_GOLF
     * @uses self::VALUE_LUXURY_UPSCALE_RESORT
     * @uses self::VALUE_MIDSCALE
     * @uses self::VALUE_SKI
     * @uses self::VALUE_SPA
     * @uses self::VALUE_VACATION_RENTAL
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONFERENCE_MEETING,
            self::VALUE_CORPORATE,
            self::VALUE_BUDGET_ECONOMY_HOSTEL,
            self::VALUE_EXTENDED_STAY,
            self::VALUE_GOLF,
            self::VALUE_LUXURY_UPSCALE_RESORT,
            self::VALUE_MIDSCALE,
            self::VALUE_SKI,
            self::VALUE_SPA,
            self::VALUE_VACATION_RENTAL,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
