<?php

namespace EnumType;

/**
 * This class stands for List_OfferPricingType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Coverage Type (COV) OpenTravel codelist. | Pricing types for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferPricingType
{
    /**
     * Constant for value 'PerEvent'
     * Meta information extracted from the WSDL
     * - documentation: Offer pricing includes one price for all travelers in the party.
     * @return string 'PerEvent'
     */
    const VALUE_PER_EVENT = 'PerEvent';
    /**
     * Constant for value 'PerGroup'
     * Meta information extracted from the WSDL
     * - documentation: Offer pricing is for a group and additional eligibility requirements (such as group size) may apply.
     * @return string 'PerGroup'
     */
    const VALUE_PER_GROUP = 'PerGroup';
    /**
     * Constant for value 'PerPerson'
     * Meta information extracted from the WSDL
     * - documentation: Offer pricing is per person.
     * @return string 'PerPerson'
     */
    const VALUE_PER_PERSON = 'PerPerson';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PER_EVENT
     * @uses self::VALUE_PER_GROUP
     * @uses self::VALUE_PER_PERSON
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PER_EVENT,
            self::VALUE_PER_GROUP,
            self::VALUE_PER_PERSON,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
