<?php

namespace EnumType;

/**
 * This class stands for List_OfferPetType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Pets Policy Code (PET) OpenTravel codelist. | Pet types for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferPetType
{
    /**
     * Constant for value 'Cat'
     * @return string 'Cat'
     */
    const VALUE_CAT = 'Cat';
    /**
     * Constant for value 'Dog'
     * @return string 'Dog'
     */
    const VALUE_DOG = 'Dog';
    /**
     * Constant for value 'ServiceAnimal'
     * @return string 'ServiceAnimal'
     */
    const VALUE_SERVICE_ANIMAL = 'ServiceAnimal';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CAT
     * @uses self::VALUE_DOG
     * @uses self::VALUE_SERVICE_ANIMAL
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CAT,
            self::VALUE_DOG,
            self::VALUE_SERVICE_ANIMAL,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
