<?php

namespace EnumType;

/**
 * This class stands for List_OfferPaymentStatus EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Coverage Type (COV) OpenTravel codelist. | Payment status for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferPaymentStatus
{
    /**
     * Constant for value 'Guaranteed'
     * Meta information extracted from the WSDL
     * - documentation: Reservation has been guaranteed.
     * @return string 'Guaranteed'
     */
    const VALUE_GUARANTEED = 'Guaranteed';
    /**
     * Constant for value 'Prepaid'
     * @return string 'Prepaid'
     */
    const VALUE_PREPAID = 'Prepaid';
    /**
     * Constant for value 'Unpaid'
     * @return string 'Unpaid'
     */
    const VALUE_UNPAID = 'Unpaid';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GUARANTEED
     * @uses self::VALUE_PREPAID
     * @uses self::VALUE_UNPAID
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GUARANTEED,
            self::VALUE_PREPAID,
            self::VALUE_UNPAID,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
