<?php

namespace EnumType;

/**
 * This class stands for List_OfferPaymentCardType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel | Payment card types for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferPaymentCardType
{
    /**
     * Constant for value 'AmericanExpress'
     * @return string 'AmericanExpress'
     */
    const VALUE_AMERICAN_EXPRESS = 'AmericanExpress';
    /**
     * Constant for value 'DiscoverCard'
     * @return string 'DiscoverCard'
     */
    const VALUE_DISCOVER_CARD = 'DiscoverCard';
    /**
     * Constant for value 'Eurocard'
     * @return string 'Eurocard'
     */
    const VALUE_EUROCARD = 'Eurocard';
    /**
     * Constant for value 'Mastercard'
     * @return string 'Mastercard'
     */
    const VALUE_MASTERCARD = 'Mastercard';
    /**
     * Constant for value 'VISA'
     * @return string 'VISA'
     */
    const VALUE_VISA = 'VISA';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AMERICAN_EXPRESS
     * @uses self::VALUE_DISCOVER_CARD
     * @uses self::VALUE_EUROCARD
     * @uses self::VALUE_MASTERCARD
     * @uses self::VALUE_VISA
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AMERICAN_EXPRESS,
            self::VALUE_DISCOVER_CARD,
            self::VALUE_EUROCARD,
            self::VALUE_MASTERCARD,
            self::VALUE_VISA,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
