<?php

namespace EnumType;

/**
 * This class stands for List_OfferMeasurementSystem EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel | Measurement system for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferMeasurementSystem
{
    /**
     * Constant for value 'Imperial'
     * @return string 'Imperial'
     */
    const VALUE_IMPERIAL = 'Imperial';
    /**
     * Constant for value 'Metric'
     * @return string 'Metric'
     */
    const VALUE_METRIC = 'Metric';
    /**
     * Constant for value 'US_Customary'
     * @return string 'US_Customary'
     */
    const VALUE_US_CUSTOMARY = 'US_Customary';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IMPERIAL
     * @uses self::VALUE_METRIC
     * @uses self::VALUE_US_CUSTOMARY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IMPERIAL,
            self::VALUE_METRIC,
            self::VALUE_US_CUSTOMARY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
