<?php

namespace EnumType;

/**
 * This class stands for List_OfferLoyaltySector EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel | Loyalty program travel sector for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferLoyaltySector
{
    /**
     * Constant for value 'Leisure'
     * Meta information extracted from the WSDL
     * - documentation: Leisure and activity suppliers, including cruise, day tour, actvity, package tour and golf.
     * @return string 'Leisure'
     */
    const VALUE_LEISURE = 'Leisure';
    /**
     * Constant for value 'Lodging'
     * Meta information extracted from the WSDL
     * - documentation: Accommodation suppliers, including hotel, hostel and vacation rental.
     * @return string 'Lodging'
     */
    const VALUE_LODGING = 'Lodging';
    /**
     * Constant for value 'Transportation'
     * Meta information extracted from the WSDL
     * - documentation: Transportation suppliers, including air, car, ground and rail.
     * @return string 'Transportation'
     */
    const VALUE_TRANSPORTATION = 'Transportation';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LEISURE
     * @uses self::VALUE_LODGING
     * @uses self::VALUE_TRANSPORTATION
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LEISURE,
            self::VALUE_LODGING,
            self::VALUE_TRANSPORTATION,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
