<?php

namespace EnumType;

/**
 * This class stands for List_OfferFareClass EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Unit of Measure (UOM) OpenTravel codelist. | Fare classes for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferFareClass
{
    /**
     * Constant for value 'Business'
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Constant for value 'Economy'
     * @return string 'Economy'
     */
    const VALUE_ECONOMY = 'Economy';
    /**
     * Constant for value 'First'
     * @return string 'First'
     */
    const VALUE_FIRST = 'First';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_ECONOMY
     * @uses self::VALUE_FIRST
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BUSINESS,
            self::VALUE_ECONOMY,
            self::VALUE_FIRST,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
