<?php

namespace EnumType;

/**
 * This class stands for List_OfferDistanceUOM EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Unit of Measure (UOM) OpenTravel codelist. | Distance units of measure for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferDistanceUOM
{
    /**
     * Constant for value 'Block'
     * @return string 'Block'
     */
    const VALUE_BLOCK = 'Block';
    /**
     * Constant for value 'Mile'
     * @return string 'Mile'
     */
    const VALUE_MILE = 'Mile';
    /**
     * Constant for value 'Kilometer'
     * @return string 'Kilometer'
     */
    const VALUE_KILOMETER = 'Kilometer';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BLOCK
     * @uses self::VALUE_MILE
     * @uses self::VALUE_KILOMETER
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BLOCK,
            self::VALUE_MILE,
            self::VALUE_KILOMETER,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
