<?php

namespace EnumType;

/**
 * This class stands for List_OfferAvailabilityStartFormula EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel | Offer availability start time period calculation methods for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferAvailabilityStartFormula
{
    /**
     * Constant for value 'CustomerSpecified'
     * Meta information extracted from the WSDL
     * - documentation: The customer has specified the earliest start date or date and time.
     * @return string 'CustomerSpecified'
     */
    const VALUE_CUSTOMER_SPECIFIED = 'CustomerSpecified';
    /**
     * Constant for value 'FlightArrival'
     * @return string 'FlightArrival'
     */
    const VALUE_FLIGHT_ARRIVAL = 'FlightArrival';
    /**
     * Constant for value 'RentalCarDropOff'
     * @return string 'RentalCarDropOff'
     */
    const VALUE_RENTAL_CAR_DROP_OFF = 'RentalCarDropOff';
    /**
     * Constant for value 'TravelGracePeriod_Distance'
     * Meta information extracted from the WSDL
     * - documentation: The travel grace period (travel time between two locations) has been estimated based on the calculated distance between the known start and end locations.
     * @return string 'TravelGracePeriod_Distance'
     */
    const VALUE_TRAVEL_GRACE_PERIOD_DISTANCE = 'TravelGracePeriod_Distance';
    /**
     * Constant for value 'TravelGracePeriod_PrivateSchedule'
     * Meta information extracted from the WSDL
     * - documentation: The travel grace period (travel time between two locations) has been estimated based on a known operating schedule for a supplier or prearranged mode of transportation between the start and end locations.
     * @return string 'TravelGracePeriod_PrivateSchedule'
     */
    const VALUE_TRAVEL_GRACE_PERIOD_PRIVATE_SCHEDULE = 'TravelGracePeriod_PrivateSchedule';
    /**
     * Constant for value 'TravelGracePeriod_PublicSchedule'
     * Meta information extracted from the WSDL
     * - documentation: The travel grace period (travel time between two locations) has been estimated based on a known operating schedule for a public mode of transportation between the start and end locations.
     * @return string 'TravelGracePeriod_PublicSchedule'
     */
    const VALUE_TRAVEL_GRACE_PERIOD_PUBLIC_SCHEDULE = 'TravelGracePeriod_PublicSchedule';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CUSTOMER_SPECIFIED
     * @uses self::VALUE_FLIGHT_ARRIVAL
     * @uses self::VALUE_RENTAL_CAR_DROP_OFF
     * @uses self::VALUE_TRAVEL_GRACE_PERIOD_DISTANCE
     * @uses self::VALUE_TRAVEL_GRACE_PERIOD_PRIVATE_SCHEDULE
     * @uses self::VALUE_TRAVEL_GRACE_PERIOD_PUBLIC_SCHEDULE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CUSTOMER_SPECIFIED,
            self::VALUE_FLIGHT_ARRIVAL,
            self::VALUE_RENTAL_CAR_DROP_OFF,
            self::VALUE_TRAVEL_GRACE_PERIOD_DISTANCE,
            self::VALUE_TRAVEL_GRACE_PERIOD_PRIVATE_SCHEDULE,
            self::VALUE_TRAVEL_GRACE_PERIOD_PUBLIC_SCHEDULE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
