<?php

namespace EnumType;

/**
 * This class stands for List_OfferAgeCategory EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Age Qualifying Code (AQC) OpenTravel codelist filtered. | Person age categories for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferAgeCategory
{
    /**
     * Constant for value 'Adult'
     * @return string 'Adult'
     */
    const VALUE_ADULT = 'Adult';
    /**
     * Constant for value 'Child'
     * @return string 'Child'
     */
    const VALUE_CHILD = 'Child';
    /**
     * Constant for value 'Infant'
     * @return string 'Infant'
     */
    const VALUE_INFANT = 'Infant';
    /**
     * Constant for value 'Over10'
     * @return string 'Over10'
     */
    const VALUE_OVER_10 = 'Over10';
    /**
     * Constant for value 'Over12'
     * @return string 'Over12'
     */
    const VALUE_OVER_12 = 'Over12';
    /**
     * Constant for value 'Over21'
     * @return string 'Over21'
     */
    const VALUE_OVER_21 = 'Over21';
    /**
     * Constant for value 'Over65'
     * @return string 'Over65'
     */
    const VALUE_OVER_65 = 'Over65';
    /**
     * Constant for value 'Senior'
     * @return string 'Senior'
     */
    const VALUE_SENIOR = 'Senior';
    /**
     * Constant for value 'Under2'
     * @return string 'Under2'
     */
    const VALUE_UNDER_2 = 'Under2';
    /**
     * Constant for value 'Under10'
     * @return string 'Under10'
     */
    const VALUE_UNDER_10 = 'Under10';
    /**
     * Constant for value 'Under12'
     * @return string 'Under12'
     */
    const VALUE_UNDER_12 = 'Under12';
    /**
     * Constant for value 'Under17'
     * @return string 'Under17'
     */
    const VALUE_UNDER_17 = 'Under17';
    /**
     * Constant for value 'Under18'
     * @return string 'Under18'
     */
    const VALUE_UNDER_18 = 'Under18';
    /**
     * Constant for value 'Under21'
     * @return string 'Under21'
     */
    const VALUE_UNDER_21 = 'Under21';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADULT
     * @uses self::VALUE_CHILD
     * @uses self::VALUE_INFANT
     * @uses self::VALUE_OVER_10
     * @uses self::VALUE_OVER_12
     * @uses self::VALUE_OVER_21
     * @uses self::VALUE_OVER_65
     * @uses self::VALUE_SENIOR
     * @uses self::VALUE_UNDER_2
     * @uses self::VALUE_UNDER_10
     * @uses self::VALUE_UNDER_12
     * @uses self::VALUE_UNDER_17
     * @uses self::VALUE_UNDER_18
     * @uses self::VALUE_UNDER_21
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADULT,
            self::VALUE_CHILD,
            self::VALUE_INFANT,
            self::VALUE_OVER_10,
            self::VALUE_OVER_12,
            self::VALUE_OVER_21,
            self::VALUE_OVER_65,
            self::VALUE_SENIOR,
            self::VALUE_UNDER_2,
            self::VALUE_UNDER_10,
            self::VALUE_UNDER_12,
            self::VALUE_UNDER_17,
            self::VALUE_UNDER_18,
            self::VALUE_UNDER_21,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
