<?php

namespace EnumType;

/**
 * This class stands for List_LoyaltyPrgCurrency_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel. | An open list of loyalty program currencies.
 * @subpackage Enumerations
 */
class List_LoyaltyPrgCurrency_Base
{
    /**
     * Constant for value 'Miles'
     * @return string 'Miles'
     */
    const VALUE_MILES = 'Miles';
    /**
     * Constant for value 'Points'
     * @return string 'Points'
     */
    const VALUE_POINTS = 'Points';
    /**
     * Constant for value 'Stays'
     * @return string 'Stays'
     */
    const VALUE_STAYS = 'Stays';
    /**
     * Constant for value 'Voucher'
     * @return string 'Voucher'
     */
    const VALUE_VOUCHER = 'Voucher';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MILES
     * @uses self::VALUE_POINTS
     * @uses self::VALUE_STAYS
     * @uses self::VALUE_VOUCHER
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MILES,
            self::VALUE_POINTS,
            self::VALUE_STAYS,
            self::VALUE_VOUCHER,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
