<?php

namespace EnumType;

/**
 * This class stands for List_LevelOfService_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Level of Service (LOS) OpenTravel codelist. | An open list of service level types.
 * @subpackage Enumerations
 */
class List_LevelOfService_Base
{
    /**
     * Constant for value 'Deluxe'
     * @return string 'Deluxe'
     */
    const VALUE_DELUXE = 'Deluxe';
    /**
     * Constant for value 'Economy'
     * @return string 'Economy'
     */
    const VALUE_ECONOMY = 'Economy';
    /**
     * Constant for value 'Exclusive'
     * @return string 'Exclusive'
     */
    const VALUE_EXCLUSIVE = 'Exclusive';
    /**
     * Constant for value 'Executive'
     * @return string 'Executive'
     */
    const VALUE_EXECUTIVE = 'Executive';
    /**
     * Constant for value 'Luxury'
     * @return string 'Luxury'
     */
    const VALUE_LUXURY = 'Luxury';
    /**
     * Constant for value 'Regular'
     * @return string 'Regular'
     */
    const VALUE_REGULAR = 'Regular';
    /**
     * Constant for value 'Shuttle'
     * @return string 'Shuttle'
     */
    const VALUE_SHUTTLE = 'Shuttle';
    /**
     * Constant for value 'VIP'
     * @return string 'VIP'
     */
    const VALUE_VIP = 'VIP';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DELUXE
     * @uses self::VALUE_ECONOMY
     * @uses self::VALUE_EXCLUSIVE
     * @uses self::VALUE_EXECUTIVE
     * @uses self::VALUE_LUXURY
     * @uses self::VALUE_REGULAR
     * @uses self::VALUE_SHUTTLE
     * @uses self::VALUE_VIP
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DELUXE,
            self::VALUE_ECONOMY,
            self::VALUE_EXCLUSIVE,
            self::VALUE_EXECUTIVE,
            self::VALUE_LUXURY,
            self::VALUE_REGULAR,
            self::VALUE_SHUTTLE,
            self::VALUE_VIP,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
