<?php

namespace EnumType;

/**
 * This class stands for List_GolferType_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel. | An open list of golfer types.
 * @subpackage Enumerations
 */
class List_GolferType_Base
{
    /**
     * Constant for value 'ClubMember'
     * Meta information extracted from the WSDL
     * - documentation: Member of a golf course.
     * @return string 'ClubMember'
     */
    const VALUE_CLUB_MEMBER = 'ClubMember';
    /**
     * Constant for value 'GuestOfMember'
     * Meta information extracted from the WSDL
     * - documentation: Guest of a golf course member.
     * @return string 'GuestOfMember'
     */
    const VALUE_GUEST_OF_MEMBER = 'GuestOfMember';
    /**
     * Constant for value 'GuestOfResort'
     * Meta information extracted from the WSDL
     * - documentation: Guest at a resort.
     * @return string 'GuestOfResort'
     */
    const VALUE_GUEST_OF_RESORT = 'GuestOfResort';
    /**
     * Constant for value 'LocalResident'
     * Meta information extracted from the WSDL
     * - documentation: Local area resident.
     * @return string 'LocalResident'
     */
    const VALUE_LOCAL_RESIDENT = 'LocalResident';
    /**
     * Constant for value 'LoyaltyProgramMember'
     * Meta information extracted from the WSDL
     * - documentation: Member of a golf course loyalty program.
     * @return string 'LoyaltyProgramMember'
     */
    const VALUE_LOYALTY_PROGRAM_MEMBER = 'LoyaltyProgramMember';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CLUB_MEMBER
     * @uses self::VALUE_GUEST_OF_MEMBER
     * @uses self::VALUE_GUEST_OF_RESORT
     * @uses self::VALUE_LOCAL_RESIDENT
     * @uses self::VALUE_LOYALTY_PROGRAM_MEMBER
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLUB_MEMBER,
            self::VALUE_GUEST_OF_MEMBER,
            self::VALUE_GUEST_OF_RESORT,
            self::VALUE_LOCAL_RESIDENT,
            self::VALUE_LOYALTY_PROGRAM_MEMBER,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
