<?php

namespace EnumType;

/**
 * This class stands for List_FareStatus_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel. | An open list of fare construction, creation and publishing methods.
 * @subpackage Enumerations
 */
class List_FareStatus_Base
{
    /**
     * Constant for value 'Constructed'
     * @return string 'Constructed'
     */
    const VALUE_CONSTRUCTED = 'Constructed';
    /**
     * Constant for value 'Created'
     * @return string 'Created'
     */
    const VALUE_CREATED = 'Created';
    /**
     * Constant for value 'FareByRule'
     * Meta information extracted from the WSDL
     * - documentation: Specifies that the fare was built based on rules.
     * @return string 'FareByRule'
     */
    const VALUE_FARE_BY_RULE = 'FareByRule';
    /**
     * Constant for value 'FareByRulePrivate'
     * Meta information extracted from the WSDL
     * - documentation: The private fare was built by rules.
     * @return string 'FareByRulePrivate'
     */
    const VALUE_FARE_BY_RULE_PRIVATE = 'FareByRulePrivate';
    /**
     * Constant for value 'Published'
     * @return string 'Published'
     */
    const VALUE_PUBLISHED = 'Published';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONSTRUCTED
     * @uses self::VALUE_CREATED
     * @uses self::VALUE_FARE_BY_RULE
     * @uses self::VALUE_FARE_BY_RULE_PRIVATE
     * @uses self::VALUE_PUBLISHED
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONSTRUCTED,
            self::VALUE_CREATED,
            self::VALUE_FARE_BY_RULE,
            self::VALUE_FARE_BY_RULE_PRIVATE,
            self::VALUE_PUBLISHED,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
