<?php

namespace EnumType;

/**
 * This class stands for List_DataActionType_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel. | An open list of actions to apply to specified data.
 * @subpackage Enumerations
 */
class List_DataActionType_Base
{
    /**
     * Constant for value 'Create/Add'
     * Meta information extracted from the WSDL
     * - documentation: Add specified data whether the data already exists or not.
     * @return string 'Create/Add'
     */
    const VALUE_CREATE_ADD = 'Create/Add';
    /**
     * Constant for value 'Read/Query'
     * @return string 'Read/Query'
     */
    const VALUE_READ_QUERY = 'Read/Query';
    /**
     * Constant for value 'Update/Modify'
     * Meta information extracted from the WSDL
     * - documentation: Add specified data if it does not exist or update data where it does exist.
     * @return string 'Update/Modify'
     */
    const VALUE_UPDATE_MODIFY = 'Update/Modify';
    /**
     * Constant for value 'Cancel'
     * Meta information extracted from the WSDL
     * - documentation: Cancel an existing item.
     * @return string 'Cancel'
     */
    const VALUE_CANCEL = 'Cancel';
    /**
     * Constant for value 'Delete'
     * Meta information extracted from the WSDL
     * - documentation: Remove specified data.
     * @return string 'Delete'
     */
    const VALUE_DELETE = 'Delete';
    /**
     * Constant for value 'Replace'
     * Meta information extracted from the WSDL
     * - documentation: Overlay existing data with specified data.
     * @return string 'Replace'
     */
    const VALUE_REPLACE = 'Replace';
    /**
     * Constant for value 'Other_'
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CREATE_ADD
     * @uses self::VALUE_READ_QUERY
     * @uses self::VALUE_UPDATE_MODIFY
     * @uses self::VALUE_CANCEL
     * @uses self::VALUE_DELETE
     * @uses self::VALUE_REPLACE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CREATE_ADD,
            self::VALUE_READ_QUERY,
            self::VALUE_UPDATE_MODIFY,
            self::VALUE_CANCEL,
            self::VALUE_DELETE,
            self::VALUE_REPLACE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
