<?php

namespace EnumType;

/**
 * This class stands for List_ChargeUnit_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Charge Type (CHG) OpenTravel codelist. | An open list of charge types and units.
 * @subpackage Enumerations
 */
class List_ChargeUnit_Base
{
    /**
     * Constant for value 'AdditionsPerStay'
     * @return string 'AdditionsPerStay'
     */
    const VALUE_ADDITIONS_PER_STAY = 'AdditionsPerStay';
    /**
     * Constant for value 'Complimentary'
     * @return string 'Complimentary'
     */
    const VALUE_COMPLIMENTARY = 'Complimentary';
    /**
     * Constant for value 'Event'
     * @return string 'Event'
     */
    const VALUE_EVENT = 'Event';
    /**
     * Constant for value 'Gallon'
     * @return string 'Gallon'
     */
    const VALUE_GALLON = 'Gallon';
    /**
     * Constant for value 'Item'
     * @return string 'Item'
     */
    const VALUE_ITEM = 'Item';
    /**
     * Constant for value 'MaximumCharge'
     * @return string 'MaximumCharge'
     */
    const VALUE_MAXIMUM_CHARGE = 'MaximumCharge';
    /**
     * Constant for value 'MinimumCharge'
     * @return string 'MinimumCharge'
     */
    const VALUE_MINIMUM_CHARGE = 'MinimumCharge';
    /**
     * Constant for value 'OneTimeUse'
     * @return string 'OneTimeUse'
     */
    const VALUE_ONE_TIME_USE = 'OneTimeUse';
    /**
     * Constant for value 'OneWay'
     * @return string 'OneWay'
     */
    const VALUE_ONE_WAY = 'OneWay';
    /**
     * Constant for value 'Order'
     * @return string 'Order'
     */
    const VALUE_ORDER = 'Order';
    /**
     * Constant for value 'OverMinuteCharge'
     * @return string 'OverMinuteCharge'
     */
    const VALUE_OVER_MINUTE_CHARGE = 'OverMinuteCharge';
    /**
     * Constant for value 'Person'
     * @return string 'Person'
     */
    const VALUE_PERSON = 'Person';
    /**
     * Constant for value 'Rental'
     * @return string 'Rental'
     */
    const VALUE_RENTAL = 'Rental';
    /**
     * Constant for value 'Reservation/Booking'
     * @return string 'Reservation/Booking'
     */
    const VALUE_RESERVATION_BOOKING = 'Reservation/Booking';
    /**
     * Constant for value 'Room'
     * @return string 'Room'
     */
    const VALUE_ROOM = 'Room';
    /**
     * Constant for value 'Stay'
     * @return string 'Stay'
     */
    const VALUE_STAY = 'Stay';
    /**
     * Constant for value 'Tray'
     * @return string 'Tray'
     */
    const VALUE_TRAY = 'Tray';
    /**
     * Constant for value 'Unit'
     * @return string 'Unit'
     */
    const VALUE_UNIT = 'Unit';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADDITIONS_PER_STAY
     * @uses self::VALUE_COMPLIMENTARY
     * @uses self::VALUE_EVENT
     * @uses self::VALUE_GALLON
     * @uses self::VALUE_ITEM
     * @uses self::VALUE_MAXIMUM_CHARGE
     * @uses self::VALUE_MINIMUM_CHARGE
     * @uses self::VALUE_ONE_TIME_USE
     * @uses self::VALUE_ONE_WAY
     * @uses self::VALUE_ORDER
     * @uses self::VALUE_OVER_MINUTE_CHARGE
     * @uses self::VALUE_PERSON
     * @uses self::VALUE_RENTAL
     * @uses self::VALUE_RESERVATION_BOOKING
     * @uses self::VALUE_ROOM
     * @uses self::VALUE_STAY
     * @uses self::VALUE_TRAY
     * @uses self::VALUE_UNIT
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADDITIONS_PER_STAY,
            self::VALUE_COMPLIMENTARY,
            self::VALUE_EVENT,
            self::VALUE_GALLON,
            self::VALUE_ITEM,
            self::VALUE_MAXIMUM_CHARGE,
            self::VALUE_MINIMUM_CHARGE,
            self::VALUE_ONE_TIME_USE,
            self::VALUE_ONE_WAY,
            self::VALUE_ORDER,
            self::VALUE_OVER_MINUTE_CHARGE,
            self::VALUE_PERSON,
            self::VALUE_RENTAL,
            self::VALUE_RESERVATION_BOOKING,
            self::VALUE_ROOM,
            self::VALUE_STAY,
            self::VALUE_TRAY,
            self::VALUE_UNIT,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
