<?php

namespace EnumType;

/**
 * This class stands for List_ChargeFrequency_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Charge Type (CHG) OpenTravel codelist. | An open list of charge units.
 * @subpackage Enumerations
 */
class List_ChargeFrequency_Base
{
    /**
     * Constant for value 'Daily'
     * @return string 'Daily'
     */
    const VALUE_DAILY = 'Daily';
    /**
     * Constant for value 'FirstUse'
     * @return string 'FirstUse'
     */
    const VALUE_FIRST_USE = 'FirstUse';
    /**
     * Constant for value 'HalfDay'
     * @return string 'HalfDay'
     */
    const VALUE_HALF_DAY = 'HalfDay';
    /**
     * Constant for value 'Hourly'
     * @return string 'Hourly'
     */
    const VALUE_HOURLY = 'Hourly';
    /**
     * Constant for value 'Night'
     * @return string 'Night'
     */
    const VALUE_NIGHT = 'Night';
    /**
     * Constant for value 'Minute'
     * @return string 'Minute'
     */
    const VALUE_MINUTE = 'Minute';
    /**
     * Constant for value 'Occurrence'
     * @return string 'Occurrence'
     */
    const VALUE_OCCURRENCE = 'Occurrence';
    /**
     * Constant for value 'PerDozen'
     * @return string 'PerDozen'
     */
    const VALUE_PER_DOZEN = 'PerDozen';
    /**
     * Constant for value 'Stay'
     * @return string 'Stay'
     */
    const VALUE_STAY = 'Stay';
    /**
     * Constant for value 'Weekly'
     * @return string 'Weekly'
     */
    const VALUE_WEEKLY = 'Weekly';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Constant for value ''
     * @return string ''
     */
    const VALUE_ = '';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DAILY
     * @uses self::VALUE_FIRST_USE
     * @uses self::VALUE_HALF_DAY
     * @uses self::VALUE_HOURLY
     * @uses self::VALUE_NIGHT
     * @uses self::VALUE_MINUTE
     * @uses self::VALUE_OCCURRENCE
     * @uses self::VALUE_PER_DOZEN
     * @uses self::VALUE_STAY
     * @uses self::VALUE_WEEKLY
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DAILY,
            self::VALUE_FIRST_USE,
            self::VALUE_HALF_DAY,
            self::VALUE_HOURLY,
            self::VALUE_NIGHT,
            self::VALUE_MINUTE,
            self::VALUE_OCCURRENCE,
            self::VALUE_PER_DOZEN,
            self::VALUE_STAY,
            self::VALUE_WEEKLY,
            self::VALUE_OTHER,
            self::VALUE_,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
