<?php

namespace EnumType;

/**
 * This class stands for List_CabinClass_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel | An open list of cabin types.
 * @subpackage Enumerations
 */
class List_CabinClass_Base
{
    /**
     * Constant for value 'Business'
     * Meta information extracted from the WSDL
     * - documentation: Business class compartment.
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Constant for value 'Cockpit'
     * Meta information extracted from the WSDL
     * - documentation: Cockpit area.
     * @return string 'Cockpit'
     */
    const VALUE_COCKPIT = 'Cockpit';
    /**
     * Constant for value 'Economy'
     * Meta information extracted from the WSDL
     * - documentation: Economy class compartment.
     * @return string 'Economy'
     */
    const VALUE_ECONOMY = 'Economy';
    /**
     * Constant for value 'First'
     * Meta information extracted from the WSDL
     * - documentation: First class compartment.
     * @return string 'First'
     */
    const VALUE_FIRST = 'First';
    /**
     * Constant for value 'PremiumBusiness'
     * Meta information extracted from the WSDL
     * - documentation: Premium Business class compartment.
     * @return string 'PremiumBusiness'
     */
    const VALUE_PREMIUM_BUSINESS = 'PremiumBusiness';
    /**
     * Constant for value 'PremiumEconomy'
     * Meta information extracted from the WSDL
     * - documentation: Premium Economy class compartment.
     * @return string 'PremiumEconomy'
     */
    const VALUE_PREMIUM_ECONOMY = 'PremiumEconomy';
    /**
     * Constant for value 'Suite'
     * Meta information extracted from the WSDL
     * - documentation: Suites or Sleep compartments.
     * @return string 'Suite'
     */
    const VALUE_SUITE = 'Suite';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_COCKPIT
     * @uses self::VALUE_ECONOMY
     * @uses self::VALUE_FIRST
     * @uses self::VALUE_PREMIUM_BUSINESS
     * @uses self::VALUE_PREMIUM_ECONOMY
     * @uses self::VALUE_SUITE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BUSINESS,
            self::VALUE_COCKPIT,
            self::VALUE_ECONOMY,
            self::VALUE_FIRST,
            self::VALUE_PREMIUM_BUSINESS,
            self::VALUE_PREMIUM_ECONOMY,
            self::VALUE_SUITE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
