<?php

namespace EnumType;

/**
 * This class stands for List_AirTripType_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel. | An open list of air trip types.
 * @subpackage Enumerations
 */
class List_AirTripType_Base
{
    /**
     * Constant for value 'Circle'
     * Meta information extracted from the WSDL
     * - documentation: Identifies a circle trip type.
     * @return string 'Circle'
     */
    const VALUE_CIRCLE = 'Circle';
    /**
     * Constant for value 'Inbound'
     * Meta information extracted from the WSDL
     * - documentation: The direction for the fare is inbound.
     * @return string 'Inbound'
     */
    const VALUE_INBOUND = 'Inbound';
    /**
     * Constant for value 'NonDirectional'
     * Meta information extracted from the WSDL
     * - documentation: There is no direction specified for the fare.
     * @return string 'NonDirectional'
     */
    const VALUE_NON_DIRECTIONAL = 'NonDirectional';
    /**
     * Constant for value 'OneWay'
     * Meta information extracted from the WSDL
     * - documentation: Identifies a one way trip type.
     * @return string 'OneWay'
     */
    const VALUE_ONE_WAY = 'OneWay';
    /**
     * Constant for value 'OneWayOnly'
     * Meta information extracted from the WSDL
     * - documentation: Cannot be doubled to create a roundtrip.
     * @return string 'OneWayOnly'
     */
    const VALUE_ONE_WAY_ONLY = 'OneWayOnly';
    /**
     * Constant for value 'OpenJaw'
     * Meta information extracted from the WSDL
     * - documentation: Identifies an open jaw trip type.
     * @return string 'OpenJaw'
     */
    const VALUE_OPEN_JAW = 'OpenJaw';
    /**
     * Constant for value 'Outbound'
     * Meta information extracted from the WSDL
     * - documentation: The direction for the fare is outbound.
     * @return string 'Outbound'
     */
    const VALUE_OUTBOUND = 'Outbound';
    /**
     * Constant for value 'OutboundSeasonRoundtrip'
     * Meta information extracted from the WSDL
     * - documentation: The direction for the fare is outbound seasonal roundtrip.
     * @return string 'OutboundSeasonRoundtrip'
     */
    const VALUE_OUTBOUND_SEASON_ROUNDTRIP = 'OutboundSeasonRoundtrip';
    /**
     * Constant for value 'Return'
     * Meta information extracted from the WSDL
     * - documentation: Identifies a return trip type.
     * @return string 'Return'
     */
    const VALUE_RETURN = 'Return';
    /**
     * Constant for value 'Roundtrip'
     * Meta information extracted from the WSDL
     * - documentation: Identifies travel from one point to another point and return to the original point. (The outbound fare shall be used also for the inbound fare component for the purpose of determining if the pricing unit is a round trip).
     * @return string 'Roundtrip'
     */
    const VALUE_ROUNDTRIP = 'Roundtrip';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CIRCLE
     * @uses self::VALUE_INBOUND
     * @uses self::VALUE_NON_DIRECTIONAL
     * @uses self::VALUE_ONE_WAY
     * @uses self::VALUE_ONE_WAY_ONLY
     * @uses self::VALUE_OPEN_JAW
     * @uses self::VALUE_OUTBOUND
     * @uses self::VALUE_OUTBOUND_SEASON_ROUNDTRIP
     * @uses self::VALUE_RETURN
     * @uses self::VALUE_ROUNDTRIP
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CIRCLE,
            self::VALUE_INBOUND,
            self::VALUE_NON_DIRECTIONAL,
            self::VALUE_ONE_WAY,
            self::VALUE_ONE_WAY_ONLY,
            self::VALUE_OPEN_JAW,
            self::VALUE_OUTBOUND,
            self::VALUE_OUTBOUND_SEASON_ROUNDTRIP,
            self::VALUE_RETURN,
            self::VALUE_ROUNDTRIP,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
