<?php

namespace EnumType;

/**
 * This class stands for List_AdditionalOperationInfo_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Additional Operation Info (OPR) OpenTravel codelist. | An open list of hours of operation details.
 * @subpackage Enumerations
 */
class List_AdditionalOperationInfo_Base
{
    /**
     * Constant for value 'AfterHoursAvailable'
     * @return string 'AfterHoursAvailable'
     */
    const VALUE_AFTER_HOURS_AVAILABLE = 'AfterHoursAvailable';
    /**
     * Constant for value 'AfterHoursConditional'
     * @return string 'AfterHoursConditional'
     */
    const VALUE_AFTER_HOURS_CONDITIONAL = 'AfterHoursConditional';
    /**
     * Constant for value 'AfterHoursPickups'
     * @return string 'AfterHoursPickups'
     */
    const VALUE_AFTER_HOURS_PICKUPS = 'AfterHoursPickups';
    /**
     * Constant for value 'AfterHoursReturns'
     * @return string 'AfterHoursReturns'
     */
    const VALUE_AFTER_HOURS_RETURNS = 'AfterHoursReturns';
    /**
     * Constant for value 'LimitedAvailability'
     * @return string 'LimitedAvailability'
     */
    const VALUE_LIMITED_AVAILABILITY = 'LimitedAvailability';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AFTER_HOURS_AVAILABLE
     * @uses self::VALUE_AFTER_HOURS_CONDITIONAL
     * @uses self::VALUE_AFTER_HOURS_PICKUPS
     * @uses self::VALUE_AFTER_HOURS_RETURNS
     * @uses self::VALUE_LIMITED_AVAILABILITY
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AFTER_HOURS_AVAILABLE,
            self::VALUE_AFTER_HOURS_CONDITIONAL,
            self::VALUE_AFTER_HOURS_PICKUPS,
            self::VALUE_AFTER_HOURS_RETURNS,
            self::VALUE_LIMITED_AVAILABILITY,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
