<?php

namespace EnumType;

/**
 * This class stands for Enum_Status EnumType
 * Meta information extracted from the WSDL
 * - documentation: An extensible list of inventory statuses.
 * @subpackage Enumerations
 */
class Enum_Status
{
    /**
     * Constant for value 'Cancel_ConfirmedRequested'
     * @return string 'Cancel_ConfirmedRequested'
     */
    const VALUE_CANCEL_CONFIRMED_REQUESTED = 'Cancel_ConfirmedRequested';
    /**
     * Constant for value 'Cancel_Listing'
     * @return string 'Cancel_Listing'
     */
    const VALUE_CANCEL_LISTING = 'Cancel_Listing';
    /**
     * Constant for value 'Cancel_OnlyIfRequestedSegmentIsAvailable'
     * @return string 'Cancel_OnlyIfRequestedSegmentIsAvailable'
     */
    const VALUE_CANCEL_ONLY_IF_REQUESTED_SEGMENT_IS_AVAILABLE = 'Cancel_OnlyIfRequestedSegmentIsAvailable';
    /**
     * Constant for value 'CancellationRecommended'
     * @return string 'CancellationRecommended'
     */
    const VALUE_CANCELLATION_RECOMMENDED = 'CancellationRecommended';
    /**
     * Constant for value 'CodeToReportActionTakenFromPreviousAccess'
     * @return string 'CodeToReportActionTakenFromPreviousAccess'
     */
    const VALUE_CODE_TO_REPORT_ACTION_TAKEN_FROM_PREVIOUS_ACCESS = 'CodeToReportActionTakenFromPreviousAccess';
    /**
     * Constant for value 'IfHolding_ThenCancel'
     * @return string 'IfHolding_ThenCancel'
     */
    const VALUE_IF_HOLDING_THEN_CANCEL = 'IfHolding_ThenCancel';
    /**
     * Constant for value 'IfNotHolding_ThenNeed'
     * @return string 'IfNotHolding_ThenNeed'
     */
    const VALUE_IF_NOT_HOLDING_THEN_NEED = 'IfNotHolding_ThenNeed';
    /**
     * Constant for value 'IfNotHolding_ThenSold'
     * @return string 'IfNotHolding_ThenSold'
     */
    const VALUE_IF_NOT_HOLDING_THEN_SOLD = 'IfNotHolding_ThenSold';
    /**
     * Constant for value 'List_AddToWaitingList'
     * @return string 'List_AddToWaitingList'
     */
    const VALUE_LIST_ADD_TO_WAITING_LIST = 'List_AddToWaitingList';
    /**
     * Constant for value 'List_SpaceAvailable'
     * @return string 'List_SpaceAvailable'
     */
    const VALUE_LIST_SPACE_AVAILABLE = 'List_SpaceAvailable';
    /**
     * Constant for value 'Need'
     * @return string 'Need'
     */
    const VALUE_NEED = 'Need';
    /**
     * Constant for value 'Need_SegmentSpecifiedOrAlternative'
     * @return string 'Need_SegmentSpecifiedOrAlternative'
     */
    const VALUE_NEED_SEGMENT_SPECIFIED_OR_ALTERNATIVE = 'Need_SegmentSpecifiedOrAlternative';
    /**
     * Constant for value 'Sold'
     * @return string 'Sold'
     */
    const VALUE_SOLD = 'Sold';
    /**
     * Constant for value 'Sold_OnFreeSaleBasis'
     * @return string 'Sold_OnFreeSaleBasis'
     */
    const VALUE_SOLD_ON_FREE_SALE_BASIS = 'Sold_OnFreeSaleBasis';
    /**
     * Constant for value 'SpaceRequested'
     * @return string 'SpaceRequested'
     */
    const VALUE_SPACE_REQUESTED = 'SpaceRequested';
    /**
     * Constant for value 'Cancelled'
     * @return string 'Cancelled'
     */
    const VALUE_CANCELLED = 'Cancelled';
    /**
     * Constant for value 'Confirming'
     * @return string 'Confirming'
     */
    const VALUE_CONFIRMING = 'Confirming';
    /**
     * Constant for value 'Confirming_FromWaitlist'
     * @return string 'Confirming_FromWaitlist'
     */
    const VALUE_CONFIRMING_FROM_WAITLIST = 'Confirming_FromWaitlist';
    /**
     * Constant for value 'NoActionTaken'
     * @return string 'NoActionTaken'
     */
    const VALUE_NO_ACTION_TAKEN = 'NoActionTaken';
    /**
     * Constant for value 'Unable_HaveWaitlisted'
     * @return string 'Unable_HaveWaitlisted'
     */
    const VALUE_UNABLE_HAVE_WAITLISTED = 'Unable_HaveWaitlisted';
    /**
     * Constant for value 'Unable_FlightDoesNotOperate'
     * @return string 'Unable_FlightDoesNotOperate'
     */
    const VALUE_UNABLE_FLIGHT_DOES_NOT_OPERATE = 'Unable_FlightDoesNotOperate';
    /**
     * Constant for value 'Unable_ToAcceptSale'
     * @return string 'Unable_ToAcceptSale'
     */
    const VALUE_UNABLE_TO_ACCEPT_SALE = 'Unable_ToAcceptSale';
    /**
     * Constant for value 'Waitlist_Closed'
     * @return string 'Waitlist_Closed'
     */
    const VALUE_WAITLIST_CLOSED = 'Waitlist_Closed';
    /**
     * Constant for value 'Have_Listed'
     * @return string 'Have_Listed'
     */
    const VALUE_HAVE_LISTED = 'Have_Listed';
    /**
     * Constant for value 'Have_Requested'
     * @return string 'Have_Requested'
     */
    const VALUE_HAVE_REQUESTED = 'Have_Requested';
    /**
     * Constant for value 'HoldsConfirmed'
     * @return string 'HoldsConfirmed'
     */
    const VALUE_HOLDS_CONFIRMED = 'HoldsConfirmed';
    /**
     * Constant for value 'Reconfirmed'
     * @return string 'Reconfirmed'
     */
    const VALUE_RECONFIRMED = 'Reconfirmed';
    /**
     * Constant for value 'HaveSold'
     * @return string 'HaveSold'
     */
    const VALUE_HAVE_SOLD = 'HaveSold';
    /**
     * Constant for value 'SpaceAlreadyRequested'
     * @return string 'SpaceAlreadyRequested'
     */
    const VALUE_SPACE_ALREADY_REQUESTED = 'SpaceAlreadyRequested';
    /**
     * Constant for value 'OK'
     * @return string 'OK'
     */
    const VALUE_OK = 'OK';
    /**
     * Constant for value 'HaveCancelled'
     * @return string 'HaveCancelled'
     */
    const VALUE_HAVE_CANCELLED = 'HaveCancelled';
    /**
     * Constant for value 'PendingConfirmation'
     * @return string 'PendingConfirmation'
     */
    const VALUE_PENDING_CONFIRMATION = 'PendingConfirmation';
    /**
     * Constant for value 'DeferredFromWaitList'
     * @return string 'DeferredFromWaitList'
     */
    const VALUE_DEFERRED_FROM_WAIT_LIST = 'DeferredFromWaitList';
    /**
     * Constant for value 'StaffRequest'
     * @return string 'StaffRequest'
     */
    const VALUE_STAFF_REQUEST = 'StaffRequest';
    /**
     * Constant for value 'Active'
     * @return string 'Active'
     */
    const VALUE_ACTIVE = 'Active';
    /**
     * Constant for value 'Available'
     * @return string 'Available'
     */
    const VALUE_AVAILABLE = 'Available';
    /**
     * Constant for value 'BookOnBoard'
     * @return string 'BookOnBoard'
     */
    const VALUE_BOOK_ON_BOARD = 'BookOnBoard';
    /**
     * Constant for value 'Closed'
     * @return string 'Closed'
     */
    const VALUE_CLOSED = 'Closed';
    /**
     * Constant for value 'Confirmed'
     * @return string 'Confirmed'
     */
    const VALUE_CONFIRMED = 'Confirmed';
    /**
     * Constant for value 'Declined'
     * @return string 'Declined'
     */
    const VALUE_DECLINED = 'Declined';
    /**
     * Constant for value 'NotApplicable'
     * @return string 'NotApplicable'
     */
    const VALUE_NOT_APPLICABLE = 'NotApplicable';
    /**
     * Constant for value 'Offered'
     * @return string 'Offered'
     */
    const VALUE_OFFERED = 'Offered';
    /**
     * Constant for value 'OnRequest'
     * @return string 'OnRequest'
     */
    const VALUE_ON_REQUEST = 'OnRequest';
    /**
     * Constant for value 'Prepaid'
     * @return string 'Prepaid'
     */
    const VALUE_PREPAID = 'Prepaid';
    /**
     * Constant for value 'Shared'
     * @return string 'Shared'
     */
    const VALUE_SHARED = 'Shared';
    /**
     * Constant for value 'Waitlisted'
     * @return string 'Waitlisted'
     */
    const VALUE_WAITLISTED = 'Waitlisted';
    /**
     * Constant for value 'Guaranteed'
     * @return string 'Guaranteed'
     */
    const VALUE_GUARANTEED = 'Guaranteed';
    /**
     * Constant for value 'Held'
     * @return string 'Held'
     */
    const VALUE_HELD = 'Held';
    /**
     * Constant for value 'Booked'
     * @return string 'Booked'
     */
    const VALUE_BOOKED = 'Booked';
    /**
     * Constant for value 'Open'
     * @return string 'Open'
     */
    const VALUE_OPEN = 'Open';
    /**
     * Constant for value 'SegmentConfirmedAfterScheduleChange'
     * @return string 'SegmentConfirmedAfterScheduleChange'
     */
    const VALUE_SEGMENT_CONFIRMED_AFTER_SCHEDULE_CHANGE = 'SegmentConfirmedAfterScheduleChange';
    /**
     * Constant for value 'SegmentConfirmed'
     * @return string 'SegmentConfirmed'
     */
    const VALUE_SEGMENT_CONFIRMED = 'SegmentConfirmed';
    /**
     * Constant for value 'Overbook'
     * @return string 'Overbook'
     */
    const VALUE_OVERBOOK = 'Overbook';
    /**
     * Constant for value 'Waitlisted_PriorityA'
     * @return string 'Waitlisted_PriorityA'
     */
    const VALUE_WAITLISTED_PRIORITY_A = 'Waitlisted_PriorityA';
    /**
     * Constant for value 'Waitlisted_PriorityB'
     * @return string 'Waitlisted_PriorityB'
     */
    const VALUE_WAITLISTED_PRIORITY_B = 'Waitlisted_PriorityB';
    /**
     * Constant for value 'Waitlisted_PriorityC'
     * @return string 'Waitlisted_PriorityC'
     */
    const VALUE_WAITLISTED_PRIORITY_C = 'Waitlisted_PriorityC';
    /**
     * Constant for value 'Waitlisted_PriorityD'
     * @return string 'Waitlisted_PriorityD'
     */
    const VALUE_WAITLISTED_PRIORITY_D = 'Waitlisted_PriorityD';
    /**
     * Constant for value 'Jumpseat'
     * @return string 'Jumpseat'
     */
    const VALUE_JUMPSEAT = 'Jumpseat';
    /**
     * Constant for value 'NeedGroupSpace'
     * @return string 'NeedGroupSpace'
     */
    const VALUE_NEED_GROUP_SPACE = 'NeedGroupSpace';
    /**
     * Constant for value 'PriorityGroup'
     * @return string 'PriorityGroup'
     */
    const VALUE_PRIORITY_GROUP = 'PriorityGroup';
    /**
     * Constant for value 'Unable_GroupWaitlisted'
     * @return string 'Unable_GroupWaitlisted'
     */
    const VALUE_UNABLE_GROUP_WAITLISTED = 'Unable_GroupWaitlisted';
    /**
     * Constant for value 'Waitlist_Group'
     * @return string 'Waitlist_Group'
     */
    const VALUE_WAITLIST_GROUP = 'Waitlist_Group';
    /**
     * Constant for value 'SegmentWasWaitlist'
     * @return string 'SegmentWasWaitlist'
     */
    const VALUE_SEGMENT_WAS_WAITLIST = 'SegmentWasWaitlist';
    /**
     * Constant for value 'SegmentWasReconfirmed'
     * @return string 'SegmentWasReconfirmed'
     */
    const VALUE_SEGMENT_WAS_RECONFIRMED = 'SegmentWasReconfirmed';
    /**
     * Constant for value 'SegmentWasPending'
     * @return string 'SegmentWasPending'
     */
    const VALUE_SEGMENT_WAS_PENDING = 'SegmentWasPending';
    /**
     * Constant for value 'BookedOutsideSystem'
     * @return string 'BookedOutsideSystem'
     */
    const VALUE_BOOKED_OUTSIDE_SYSTEM = 'BookedOutsideSystem';
    /**
     * Constant for value 'PendingCancel'
     * @return string 'PendingCancel'
     */
    const VALUE_PENDING_CANCEL = 'PendingCancel';
    /**
     * Constant for value 'MandatoryNeed'
     * @return string 'MandatoryNeed'
     */
    const VALUE_MANDATORY_NEED = 'MandatoryNeed';
    /**
     * Constant for value 'NeedProtection'
     * @return string 'NeedProtection'
     */
    const VALUE_NEED_PROTECTION = 'NeedProtection';
    /**
     * Constant for value 'PendingRequest'
     * @return string 'PendingRequest'
     */
    const VALUE_PENDING_REQUEST = 'PendingRequest';
    /**
     * Constant for value 'PendingCancellation'
     * @return string 'PendingCancellation'
     */
    const VALUE_PENDING_CANCELLATION = 'PendingCancellation';
    /**
     * Constant for value 'StaffListingInSSR'
     * @return string 'StaffListingInSSR'
     */
    const VALUE_STAFF_LISTING_IN_SSR = 'StaffListingInSSR';
    /**
     * Constant for value 'LinkSold_HistoryOnly'
     * @return string 'LinkSold_HistoryOnly'
     */
    const VALUE_LINK_SOLD_HISTORY_ONLY = 'LinkSold_HistoryOnly';
    /**
     * Constant for value 'CodeshareSold_HistoryOnly'
     * @return string 'CodeshareSold_HistoryOnly'
     */
    const VALUE_CODESHARE_SOLD_HISTORY_ONLY = 'CodeshareSold_HistoryOnly';
    /**
     * Constant for value 'SuperGuaranteedSell_HistoryOnly'
     * @return string 'SuperGuaranteedSell_HistoryOnly'
     */
    const VALUE_SUPER_GUARANTEED_SELL_HISTORY_ONLY = 'SuperGuaranteedSell_HistoryOnly';
    /**
     * Constant for value 'Confirming_NewSchedule'
     * @return string 'Confirming_NewSchedule'
     */
    const VALUE_CONFIRMING_NEW_SCHEDULE = 'Confirming_NewSchedule';
    /**
     * Constant for value 'OnRequest_NewSchedule'
     * @return string 'OnRequest_NewSchedule'
     */
    const VALUE_ON_REQUEST_NEW_SCHEDULE = 'OnRequest_NewSchedule';
    /**
     * Constant for value 'PlacingOnWaitlist_NewSchedule'
     * @return string 'PlacingOnWaitlist_NewSchedule'
     */
    const VALUE_PLACING_ON_WAITLIST_NEW_SCHEDULE = 'PlacingOnWaitlist_NewSchedule';
    /**
     * Constant for value 'StandbyBoarded'
     * @return string 'StandbyBoarded'
     */
    const VALUE_STANDBY_BOARDED = 'StandbyBoarded';
    /**
     * Constant for value 'Flown'
     * @return string 'Flown'
     */
    const VALUE_FLOWN = 'Flown';
    /**
     * Constant for value 'NoRecordAvailable_NOREC'
     * @return string 'NoRecordAvailable_NOREC'
     */
    const VALUE_NO_RECORD_AVAILABLE_NOREC = 'NoRecordAvailable_NOREC';
    /**
     * Constant for value 'GoShow'
     * @return string 'GoShow'
     */
    const VALUE_GO_SHOW = 'GoShow';
    /**
     * Constant for value 'NoShow'
     * @return string 'NoShow'
     */
    const VALUE_NO_SHOW = 'NoShow';
    /**
     * Constant for value 'OffloadFirmBooked'
     * @return string 'OffloadFirmBooked'
     */
    const VALUE_OFFLOAD_FIRM_BOOKED = 'OffloadFirmBooked';
    /**
     * Constant for value 'OffloadOfGoShow'
     * @return string 'OffloadOfGoShow'
     */
    const VALUE_OFFLOAD_OF_GO_SHOW = 'OffloadOfGoShow';
    /**
     * Constant for value 'Downgrade_ToEconomyClass'
     * @return string 'Downgrade_ToEconomyClass'
     */
    const VALUE_DOWNGRADE_TO_ECONOMY_CLASS = 'Downgrade_ToEconomyClass';
    /**
     * Constant for value 'DownUpgrade_ToBusinessClass'
     * @return string 'DownUpgrade_ToBusinessClass'
     */
    const VALUE_DOWN_UPGRADE_TO_BUSINESS_CLASS = 'DownUpgrade_ToBusinessClass';
    /**
     * Constant for value 'Upgrade_ToFirstClass'
     * @return string 'Upgrade_ToFirstClass'
     */
    const VALUE_UPGRADE_TO_FIRST_CLASS = 'Upgrade_ToFirstClass';
    /**
     * Constant for value 'OffloadOfNoRecordPassenger'
     * @return string 'OffloadOfNoRecordPassenger'
     */
    const VALUE_OFFLOAD_OF_NO_RECORD_PASSENGER = 'OffloadOfNoRecordPassenger';
    /**
     * Constant for value 'HoldsConfirmed_ConditionalEMD_Required'
     * @return string 'HoldsConfirmed_ConditionalEMD_Required'
     */
    const VALUE_HOLDS_CONFIRMED_CONDITIONAL_EMD_REQUIRED = 'HoldsConfirmed_ConditionalEMD_Required';
    /**
     * Constant for value 'HoldsConfirmed_EMD_Required'
     * @return string 'HoldsConfirmed_EMD_Required'
     */
    const VALUE_HOLDS_CONFIRMED_EMD_REQUIRED = 'HoldsConfirmed_EMD_Required';
    /**
     * Constant for value 'HoldsConfirmed_EMD_Issued'
     * @return string 'HoldsConfirmed_EMD_Issued'
     */
    const VALUE_HOLDS_CONFIRMED_EMD_ISSUED = 'HoldsConfirmed_EMD_Issued';
    /**
     * Constant for value 'HoldsConfirmed_NewSchedule_EMDAlreadyIssued'
     * @return string 'HoldsConfirmed_NewSchedule_EMDAlreadyIssued'
     */
    const VALUE_HOLDS_CONFIRMED_NEW_SCHEDULE_EMDALREADY_ISSUED = 'HoldsConfirmed_NewSchedule_EMDAlreadyIssued';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use this value to provide an extended enumeration that is not in the provided list. | It is strongly recommended that you submit a comment to have any of your extended list values permanently added to the OpenTravel specification to
     * support maximum trading partner interoperability. http://www.opentraveldevelopersnetwork.com/specificationcomments/2/entercomment.html
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CANCEL_CONFIRMED_REQUESTED
     * @uses self::VALUE_CANCEL_LISTING
     * @uses self::VALUE_CANCEL_ONLY_IF_REQUESTED_SEGMENT_IS_AVAILABLE
     * @uses self::VALUE_CANCELLATION_RECOMMENDED
     * @uses self::VALUE_CODE_TO_REPORT_ACTION_TAKEN_FROM_PREVIOUS_ACCESS
     * @uses self::VALUE_IF_HOLDING_THEN_CANCEL
     * @uses self::VALUE_IF_NOT_HOLDING_THEN_NEED
     * @uses self::VALUE_IF_NOT_HOLDING_THEN_SOLD
     * @uses self::VALUE_LIST_ADD_TO_WAITING_LIST
     * @uses self::VALUE_LIST_SPACE_AVAILABLE
     * @uses self::VALUE_NEED
     * @uses self::VALUE_NEED_SEGMENT_SPECIFIED_OR_ALTERNATIVE
     * @uses self::VALUE_SOLD
     * @uses self::VALUE_SOLD_ON_FREE_SALE_BASIS
     * @uses self::VALUE_SPACE_REQUESTED
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_CONFIRMING
     * @uses self::VALUE_CONFIRMING_FROM_WAITLIST
     * @uses self::VALUE_NO_ACTION_TAKEN
     * @uses self::VALUE_UNABLE_HAVE_WAITLISTED
     * @uses self::VALUE_UNABLE_FLIGHT_DOES_NOT_OPERATE
     * @uses self::VALUE_UNABLE_TO_ACCEPT_SALE
     * @uses self::VALUE_WAITLIST_CLOSED
     * @uses self::VALUE_HAVE_LISTED
     * @uses self::VALUE_HAVE_REQUESTED
     * @uses self::VALUE_HOLDS_CONFIRMED
     * @uses self::VALUE_RECONFIRMED
     * @uses self::VALUE_HAVE_SOLD
     * @uses self::VALUE_SPACE_ALREADY_REQUESTED
     * @uses self::VALUE_OK
     * @uses self::VALUE_HAVE_CANCELLED
     * @uses self::VALUE_PENDING_CONFIRMATION
     * @uses self::VALUE_DEFERRED_FROM_WAIT_LIST
     * @uses self::VALUE_STAFF_REQUEST
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_AVAILABLE
     * @uses self::VALUE_BOOK_ON_BOARD
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_CONFIRMED
     * @uses self::VALUE_DECLINED
     * @uses self::VALUE_NOT_APPLICABLE
     * @uses self::VALUE_OFFERED
     * @uses self::VALUE_ON_REQUEST
     * @uses self::VALUE_PREPAID
     * @uses self::VALUE_SHARED
     * @uses self::VALUE_WAITLISTED
     * @uses self::VALUE_GUARANTEED
     * @uses self::VALUE_HELD
     * @uses self::VALUE_BOOKED
     * @uses self::VALUE_OPEN
     * @uses self::VALUE_SEGMENT_CONFIRMED_AFTER_SCHEDULE_CHANGE
     * @uses self::VALUE_SEGMENT_CONFIRMED
     * @uses self::VALUE_OVERBOOK
     * @uses self::VALUE_WAITLISTED_PRIORITY_A
     * @uses self::VALUE_WAITLISTED_PRIORITY_B
     * @uses self::VALUE_WAITLISTED_PRIORITY_C
     * @uses self::VALUE_WAITLISTED_PRIORITY_D
     * @uses self::VALUE_JUMPSEAT
     * @uses self::VALUE_NEED_GROUP_SPACE
     * @uses self::VALUE_PRIORITY_GROUP
     * @uses self::VALUE_UNABLE_GROUP_WAITLISTED
     * @uses self::VALUE_WAITLIST_GROUP
     * @uses self::VALUE_SEGMENT_WAS_WAITLIST
     * @uses self::VALUE_SEGMENT_WAS_RECONFIRMED
     * @uses self::VALUE_SEGMENT_WAS_PENDING
     * @uses self::VALUE_BOOKED_OUTSIDE_SYSTEM
     * @uses self::VALUE_PENDING_CANCEL
     * @uses self::VALUE_MANDATORY_NEED
     * @uses self::VALUE_NEED_PROTECTION
     * @uses self::VALUE_PENDING_REQUEST
     * @uses self::VALUE_PENDING_CANCELLATION
     * @uses self::VALUE_STAFF_LISTING_IN_SSR
     * @uses self::VALUE_LINK_SOLD_HISTORY_ONLY
     * @uses self::VALUE_CODESHARE_SOLD_HISTORY_ONLY
     * @uses self::VALUE_SUPER_GUARANTEED_SELL_HISTORY_ONLY
     * @uses self::VALUE_CONFIRMING_NEW_SCHEDULE
     * @uses self::VALUE_ON_REQUEST_NEW_SCHEDULE
     * @uses self::VALUE_PLACING_ON_WAITLIST_NEW_SCHEDULE
     * @uses self::VALUE_STANDBY_BOARDED
     * @uses self::VALUE_FLOWN
     * @uses self::VALUE_NO_RECORD_AVAILABLE_NOREC
     * @uses self::VALUE_GO_SHOW
     * @uses self::VALUE_NO_SHOW
     * @uses self::VALUE_OFFLOAD_FIRM_BOOKED
     * @uses self::VALUE_OFFLOAD_OF_GO_SHOW
     * @uses self::VALUE_DOWNGRADE_TO_ECONOMY_CLASS
     * @uses self::VALUE_DOWN_UPGRADE_TO_BUSINESS_CLASS
     * @uses self::VALUE_UPGRADE_TO_FIRST_CLASS
     * @uses self::VALUE_OFFLOAD_OF_NO_RECORD_PASSENGER
     * @uses self::VALUE_HOLDS_CONFIRMED_CONDITIONAL_EMD_REQUIRED
     * @uses self::VALUE_HOLDS_CONFIRMED_EMD_REQUIRED
     * @uses self::VALUE_HOLDS_CONFIRMED_EMD_ISSUED
     * @uses self::VALUE_HOLDS_CONFIRMED_NEW_SCHEDULE_EMDALREADY_ISSUED
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CANCEL_CONFIRMED_REQUESTED,
            self::VALUE_CANCEL_LISTING,
            self::VALUE_CANCEL_ONLY_IF_REQUESTED_SEGMENT_IS_AVAILABLE,
            self::VALUE_CANCELLATION_RECOMMENDED,
            self::VALUE_CODE_TO_REPORT_ACTION_TAKEN_FROM_PREVIOUS_ACCESS,
            self::VALUE_IF_HOLDING_THEN_CANCEL,
            self::VALUE_IF_NOT_HOLDING_THEN_NEED,
            self::VALUE_IF_NOT_HOLDING_THEN_SOLD,
            self::VALUE_LIST_ADD_TO_WAITING_LIST,
            self::VALUE_LIST_SPACE_AVAILABLE,
            self::VALUE_NEED,
            self::VALUE_NEED_SEGMENT_SPECIFIED_OR_ALTERNATIVE,
            self::VALUE_SOLD,
            self::VALUE_SOLD_ON_FREE_SALE_BASIS,
            self::VALUE_SPACE_REQUESTED,
            self::VALUE_CANCELLED,
            self::VALUE_CONFIRMING,
            self::VALUE_CONFIRMING_FROM_WAITLIST,
            self::VALUE_NO_ACTION_TAKEN,
            self::VALUE_UNABLE_HAVE_WAITLISTED,
            self::VALUE_UNABLE_FLIGHT_DOES_NOT_OPERATE,
            self::VALUE_UNABLE_TO_ACCEPT_SALE,
            self::VALUE_WAITLIST_CLOSED,
            self::VALUE_HAVE_LISTED,
            self::VALUE_HAVE_REQUESTED,
            self::VALUE_HOLDS_CONFIRMED,
            self::VALUE_RECONFIRMED,
            self::VALUE_HAVE_SOLD,
            self::VALUE_SPACE_ALREADY_REQUESTED,
            self::VALUE_OK,
            self::VALUE_HAVE_CANCELLED,
            self::VALUE_PENDING_CONFIRMATION,
            self::VALUE_DEFERRED_FROM_WAIT_LIST,
            self::VALUE_STAFF_REQUEST,
            self::VALUE_ACTIVE,
            self::VALUE_AVAILABLE,
            self::VALUE_BOOK_ON_BOARD,
            self::VALUE_CLOSED,
            self::VALUE_CONFIRMED,
            self::VALUE_DECLINED,
            self::VALUE_NOT_APPLICABLE,
            self::VALUE_OFFERED,
            self::VALUE_ON_REQUEST,
            self::VALUE_PREPAID,
            self::VALUE_SHARED,
            self::VALUE_WAITLISTED,
            self::VALUE_GUARANTEED,
            self::VALUE_HELD,
            self::VALUE_BOOKED,
            self::VALUE_OPEN,
            self::VALUE_SEGMENT_CONFIRMED_AFTER_SCHEDULE_CHANGE,
            self::VALUE_SEGMENT_CONFIRMED,
            self::VALUE_OVERBOOK,
            self::VALUE_WAITLISTED_PRIORITY_A,
            self::VALUE_WAITLISTED_PRIORITY_B,
            self::VALUE_WAITLISTED_PRIORITY_C,
            self::VALUE_WAITLISTED_PRIORITY_D,
            self::VALUE_JUMPSEAT,
            self::VALUE_NEED_GROUP_SPACE,
            self::VALUE_PRIORITY_GROUP,
            self::VALUE_UNABLE_GROUP_WAITLISTED,
            self::VALUE_WAITLIST_GROUP,
            self::VALUE_SEGMENT_WAS_WAITLIST,
            self::VALUE_SEGMENT_WAS_RECONFIRMED,
            self::VALUE_SEGMENT_WAS_PENDING,
            self::VALUE_BOOKED_OUTSIDE_SYSTEM,
            self::VALUE_PENDING_CANCEL,
            self::VALUE_MANDATORY_NEED,
            self::VALUE_NEED_PROTECTION,
            self::VALUE_PENDING_REQUEST,
            self::VALUE_PENDING_CANCELLATION,
            self::VALUE_STAFF_LISTING_IN_SSR,
            self::VALUE_LINK_SOLD_HISTORY_ONLY,
            self::VALUE_CODESHARE_SOLD_HISTORY_ONLY,
            self::VALUE_SUPER_GUARANTEED_SELL_HISTORY_ONLY,
            self::VALUE_CONFIRMING_NEW_SCHEDULE,
            self::VALUE_ON_REQUEST_NEW_SCHEDULE,
            self::VALUE_PLACING_ON_WAITLIST_NEW_SCHEDULE,
            self::VALUE_STANDBY_BOARDED,
            self::VALUE_FLOWN,
            self::VALUE_NO_RECORD_AVAILABLE_NOREC,
            self::VALUE_GO_SHOW,
            self::VALUE_NO_SHOW,
            self::VALUE_OFFLOAD_FIRM_BOOKED,
            self::VALUE_OFFLOAD_OF_GO_SHOW,
            self::VALUE_DOWNGRADE_TO_ECONOMY_CLASS,
            self::VALUE_DOWN_UPGRADE_TO_BUSINESS_CLASS,
            self::VALUE_UPGRADE_TO_FIRST_CLASS,
            self::VALUE_OFFLOAD_OF_NO_RECORD_PASSENGER,
            self::VALUE_HOLDS_CONFIRMED_CONDITIONAL_EMD_REQUIRED,
            self::VALUE_HOLDS_CONFIRMED_EMD_REQUIRED,
            self::VALUE_HOLDS_CONFIRMED_EMD_ISSUED,
            self::VALUE_HOLDS_CONFIRMED_NEW_SCHEDULE_EMDALREADY_ISSUED,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
