<?php

namespace EnumType;

/**
 * This class stands for Enum_SeatMapOperations EnumType
 * Meta information extracted from the WSDL
 * - documentation: An extensible list of seat map operations.
 * @subpackage Enumerations
 */
class Enum_SeatMapOperations
{
    /**
     * Constant for value 'GetSeatAssignment'
     * Meta information extracted from the WSDL
     * - documentation: Get a seat map for one or more already assigned seats. [Flight, PNR, Traveler]
     * @return string 'GetSeatAssignment'
     */
    const VALUE_GET_SEAT_ASSIGNMENT = 'GetSeatAssignment';
    /**
     * Constant for value 'GetSeatMap'
     * Meta information extracted from the WSDL
     * - documentation: Get a seat map for the specified criteria [Flight, PNR, Traveler].
     * @return string 'GetSeatMap'
     */
    const VALUE_GET_SEAT_MAP = 'GetSeatMap';
    /**
     * Constant for value 'GetSeatMapForPNR'
     * Meta information extracted from the WSDL
     * - documentation: Get a seat map fpr a specified passenger name record. [Multiple crafts, multi flight segments]
     * @return string 'GetSeatMapForPNR'
     */
    const VALUE_GET_SEAT_MAP_FOR_PNR = 'GetSeatMapForPNR';
    /**
     * Constant for value 'GetSeatMapWithRules'
     * Meta information extracted from the WSDL
     * - documentation: Get a seat map that includes fare, upgrade and other associated rules for each seat.
     * @return string 'GetSeatMapWithRules'
     */
    const VALUE_GET_SEAT_MAP_WITH_RULES = 'GetSeatMapWithRules';
    /**
     * Constant for value 'GetSeatPurchases'
     * Meta information extracted from the WSDL
     * - documentation: Get a list of purchased seats for travelers and/or by aircraft.
     * @return string 'GetSeatPurchases'
     */
    const VALUE_GET_SEAT_PURCHASES = 'GetSeatPurchases';
    /**
     * Constant for value 'GetSeatMapForSeatType'
     * Meta information extracted from the WSDL
     * - documentation: Get a seat map for a specified seat type and/or traveler special requirements.
     * @return string 'GetSeatMapForSeatType'
     */
    const VALUE_GET_SEAT_MAP_FOR_SEAT_TYPE = 'GetSeatMapForSeatType';
    /**
     * Constant for value 'GetSeatZones'
     * Meta information extracted from the WSDL
     * - documentation: Get a seat map organized by one or more seating zones.
     * @return string 'GetSeatZones'
     */
    const VALUE_GET_SEAT_ZONES = 'GetSeatZones';
    /**
     * Constant for value 'GetSeatMapForUpgrade'
     * Meta information extracted from the WSDL
     * - documentation: Get a seat map for an upgrade (which may be voluntary or in-voluntary.
     * @return string 'GetSeatMapForUpgrade'
     */
    const VALUE_GET_SEAT_MAP_FOR_UPGRADE = 'GetSeatMapForUpgrade';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use this value to provide an extended enumeration that is not in the provided list. | It is strongly recommended that you submit a comment to have any of your extended list values permanently added to the OpenTravel specification to
     * support maximum trading partner interoperability. http://www.opentraveldevelopersnetwork.com/specificationcomments/2/entercomment.html
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GET_SEAT_ASSIGNMENT
     * @uses self::VALUE_GET_SEAT_MAP
     * @uses self::VALUE_GET_SEAT_MAP_FOR_PNR
     * @uses self::VALUE_GET_SEAT_MAP_WITH_RULES
     * @uses self::VALUE_GET_SEAT_PURCHASES
     * @uses self::VALUE_GET_SEAT_MAP_FOR_SEAT_TYPE
     * @uses self::VALUE_GET_SEAT_ZONES
     * @uses self::VALUE_GET_SEAT_MAP_FOR_UPGRADE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GET_SEAT_ASSIGNMENT,
            self::VALUE_GET_SEAT_MAP,
            self::VALUE_GET_SEAT_MAP_FOR_PNR,
            self::VALUE_GET_SEAT_MAP_WITH_RULES,
            self::VALUE_GET_SEAT_PURCHASES,
            self::VALUE_GET_SEAT_MAP_FOR_SEAT_TYPE,
            self::VALUE_GET_SEAT_ZONES,
            self::VALUE_GET_SEAT_MAP_FOR_UPGRADE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
