<?php

namespace EnumType;

/**
 * This class stands for Enum_SeatFeatures EnumType
 * Meta information extracted from the WSDL
 * - documentation: An extensible list of seat map features.
 * @subpackage Enumerations
 */
class Enum_SeatFeatures
{
    /**
     * Constant for value 'AdjacentSeat'
     * @return string 'AdjacentSeat'
     */
    const VALUE_ADJACENT_SEAT = 'AdjacentSeat';
    /**
     * Constant for value 'AdjacentSeat_Aisle'
     * @return string 'AdjacentSeat_Aisle'
     */
    const VALUE_ADJACENT_SEAT_AISLE = 'AdjacentSeat_Aisle';
    /**
     * Constant for value 'AdjacentSeat_Together'
     * @return string 'AdjacentSeat_Together'
     */
    const VALUE_ADJACENT_SEAT_TOGETHER = 'AdjacentSeat_Together';
    /**
     * Constant for value 'Aisle'
     * @return string 'Aisle'
     */
    const VALUE_AISLE = 'Aisle';
    /**
     * Constant for value 'BlockedSeat'
     * @return string 'BlockedSeat'
     */
    const VALUE_BLOCKED_SEAT = 'BlockedSeat';
    /**
     * Constant for value 'BlockedSeat_Permanent'
     * @return string 'BlockedSeat_Permanent'
     */
    const VALUE_BLOCKED_SEAT_PERMANENT = 'BlockedSeat_Permanent';
    /**
     * Constant for value 'Center'
     * @return string 'Center'
     */
    const VALUE_CENTER = 'Center';
    /**
     * Constant for value 'ExitRow'
     * @return string 'ExitRow'
     */
    const VALUE_EXIT_ROW = 'ExitRow';
    /**
     * Constant for value 'GroupSeating'
     * @return string 'GroupSeating'
     */
    const VALUE_GROUP_SEATING = 'GroupSeating';
    /**
     * Constant for value 'InfantOnLap'
     * @return string 'InfantOnLap'
     */
    const VALUE_INFANT_ON_LAP = 'InfantOnLap';
    /**
     * Constant for value 'NearCloset'
     * @return string 'NearCloset'
     */
    const VALUE_NEAR_CLOSET = 'NearCloset';
    /**
     * Constant for value 'NearLavatory'
     * @return string 'NearLavatory'
     */
    const VALUE_NEAR_LAVATORY = 'NearLavatory';
    /**
     * Constant for value 'NearSpace'
     * @return string 'NearSpace'
     */
    const VALUE_NEAR_SPACE = 'NearSpace';
    /**
     * Constant for value 'NearStairs'
     * @return string 'NearStairs'
     */
    const VALUE_NEAR_STAIRS = 'NearStairs';
    /**
     * Constant for value 'Nonsmoking'
     * @return string 'Nonsmoking'
     */
    const VALUE_NONSMOKING = 'Nonsmoking';
    /**
     * Constant for value 'Overwing'
     * @return string 'Overwing'
     */
    const VALUE_OVERWING = 'Overwing';
    /**
     * Constant for value 'Pet_Carriage'
     * @return string 'Pet_Carriage'
     */
    const VALUE_PET_CARRIAGE = 'Pet_Carriage';
    /**
     * Constant for value 'Pet_Medium'
     * @return string 'Pet_Medium'
     */
    const VALUE_PET_MEDIUM = 'Pet_Medium';
    /**
     * Constant for value 'Pet_Small'
     * @return string 'Pet_Small'
     */
    const VALUE_PET_SMALL = 'Pet_Small';
    /**
     * Constant for value 'PortableOxygen'
     * @return string 'PortableOxygen'
     */
    const VALUE_PORTABLE_OXYGEN = 'PortableOxygen';
    /**
     * Constant for value 'PremiumSeat'
     * @return string 'PremiumSeat'
     */
    const VALUE_PREMIUM_SEAT = 'PremiumSeat';
    /**
     * Constant for value 'PremiumSeat_Reassign'
     * @return string 'PremiumSeat_Reassign'
     */
    const VALUE_PREMIUM_SEAT_REASSIGN = 'PremiumSeat_Reassign';
    /**
     * Constant for value 'ProximitySeating_Together'
     * @return string 'ProximitySeating_Together'
     */
    const VALUE_PROXIMITY_SEATING_TOGETHER = 'ProximitySeating_Together';
    /**
     * Constant for value 'PremiumSeat_Upgrade'
     * @return string 'PremiumSeat_Upgrade'
     */
    const VALUE_PREMIUM_SEAT_UPGRADE = 'PremiumSeat_Upgrade';
    /**
     * Constant for value 'Smoking'
     * @return string 'Smoking'
     */
    const VALUE_SMOKING = 'Smoking';
    /**
     * Constant for value 'Specific'
     * @return string 'Specific'
     */
    const VALUE_SPECIFIC = 'Specific';
    /**
     * Constant for value 'UnaccompaniedTravel_Minor'
     * @return string 'UnaccompaniedTravel_Minor'
     */
    const VALUE_UNACCOMPANIED_TRAVEL_MINOR = 'UnaccompaniedTravel_Minor';
    /**
     * Constant for value 'UnaccompaniedTravel_Senior'
     * @return string 'UnaccompaniedTravel_Senior'
     */
    const VALUE_UNACCOMPANIED_TRAVEL_SENIOR = 'UnaccompaniedTravel_Senior';
    /**
     * Constant for value 'UnaccompaniedTravel_PassengerAssistance'
     * @return string 'UnaccompaniedTravel_PassengerAssistance'
     */
    const VALUE_UNACCOMPANIED_TRAVEL_PASSENGER_ASSISTANCE = 'UnaccompaniedTravel_PassengerAssistance';
    /**
     * Constant for value 'Window'
     * @return string 'Window'
     */
    const VALUE_WINDOW = 'Window';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use this value to provide an extended enumeration that is not in the provided list. | It is strongly recommended that you submit a comment to have any of your extended list values permanently added to the OpenTravel specification to
     * support maximum trading partner interoperability. http://www.opentraveldevelopersnetwork.com/specificationcomments/2/entercomment.html
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADJACENT_SEAT
     * @uses self::VALUE_ADJACENT_SEAT_AISLE
     * @uses self::VALUE_ADJACENT_SEAT_TOGETHER
     * @uses self::VALUE_AISLE
     * @uses self::VALUE_BLOCKED_SEAT
     * @uses self::VALUE_BLOCKED_SEAT_PERMANENT
     * @uses self::VALUE_CENTER
     * @uses self::VALUE_EXIT_ROW
     * @uses self::VALUE_GROUP_SEATING
     * @uses self::VALUE_INFANT_ON_LAP
     * @uses self::VALUE_NEAR_CLOSET
     * @uses self::VALUE_NEAR_LAVATORY
     * @uses self::VALUE_NEAR_SPACE
     * @uses self::VALUE_NEAR_STAIRS
     * @uses self::VALUE_NONSMOKING
     * @uses self::VALUE_OVERWING
     * @uses self::VALUE_PET_CARRIAGE
     * @uses self::VALUE_PET_MEDIUM
     * @uses self::VALUE_PET_SMALL
     * @uses self::VALUE_PORTABLE_OXYGEN
     * @uses self::VALUE_PREMIUM_SEAT
     * @uses self::VALUE_PREMIUM_SEAT_REASSIGN
     * @uses self::VALUE_PROXIMITY_SEATING_TOGETHER
     * @uses self::VALUE_PREMIUM_SEAT_UPGRADE
     * @uses self::VALUE_SMOKING
     * @uses self::VALUE_SPECIFIC
     * @uses self::VALUE_UNACCOMPANIED_TRAVEL_MINOR
     * @uses self::VALUE_UNACCOMPANIED_TRAVEL_SENIOR
     * @uses self::VALUE_UNACCOMPANIED_TRAVEL_PASSENGER_ASSISTANCE
     * @uses self::VALUE_WINDOW
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADJACENT_SEAT,
            self::VALUE_ADJACENT_SEAT_AISLE,
            self::VALUE_ADJACENT_SEAT_TOGETHER,
            self::VALUE_AISLE,
            self::VALUE_BLOCKED_SEAT,
            self::VALUE_BLOCKED_SEAT_PERMANENT,
            self::VALUE_CENTER,
            self::VALUE_EXIT_ROW,
            self::VALUE_GROUP_SEATING,
            self::VALUE_INFANT_ON_LAP,
            self::VALUE_NEAR_CLOSET,
            self::VALUE_NEAR_LAVATORY,
            self::VALUE_NEAR_SPACE,
            self::VALUE_NEAR_STAIRS,
            self::VALUE_NONSMOKING,
            self::VALUE_OVERWING,
            self::VALUE_PET_CARRIAGE,
            self::VALUE_PET_MEDIUM,
            self::VALUE_PET_SMALL,
            self::VALUE_PORTABLE_OXYGEN,
            self::VALUE_PREMIUM_SEAT,
            self::VALUE_PREMIUM_SEAT_REASSIGN,
            self::VALUE_PROXIMITY_SEATING_TOGETHER,
            self::VALUE_PREMIUM_SEAT_UPGRADE,
            self::VALUE_SMOKING,
            self::VALUE_SPECIFIC,
            self::VALUE_UNACCOMPANIED_TRAVEL_MINOR,
            self::VALUE_UNACCOMPANIED_TRAVEL_SENIOR,
            self::VALUE_UNACCOMPANIED_TRAVEL_PASSENGER_ASSISTANCE,
            self::VALUE_WINDOW,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
