<?php

namespace EnumType;

/**
 * This class stands for Enum_SeatAvailability EnumType
 * Meta information extracted from the WSDL
 * - documentation: An extensible list of seat availability types.
 * @subpackage Enumerations
 */
class Enum_SeatAvailability
{
    /**
     * Constant for value 'AdvancedSeatSelectionSeat '
     * @return string 'AdvancedSeatSelectionSeat '
     */
    const VALUE_ADVANCED_SEAT_SELECTION_SEAT = 'AdvancedSeatSelectionSeat ';
    /**
     * Constant for value 'CourtesyReservedSeat'
     * @return string 'CourtesyReservedSeat'
     */
    const VALUE_COURTESY_RESERVED_SEAT = 'CourtesyReservedSeat';
    /**
     * Constant for value 'DownlineProtectedSeats'
     * @return string 'DownlineProtectedSeats'
     */
    const VALUE_DOWNLINE_PROTECTED_SEATS = 'DownlineProtectedSeats';
    /**
     * Constant for value 'ExtraSeat'
     * @return string 'ExtraSeat'
     */
    const VALUE_EXTRA_SEAT = 'ExtraSeat';
    /**
     * Constant for value 'FreeSeat'
     * @return string 'FreeSeat'
     */
    const VALUE_FREE_SEAT = 'FreeSeat';
    /**
     * Constant for value 'GroupPreallocationSeat'
     * @return string 'GroupPreallocationSeat'
     */
    const VALUE_GROUP_PREALLOCATION_SEAT = 'GroupPreallocationSeat';
    /**
     * Constant for value 'NoSeatHere'
     * @return string 'NoSeatHere'
     */
    const VALUE_NO_SEAT_HERE = 'NoSeatHere';
    /**
     * Constant for value 'ProtectedSeat'
     * @return string 'ProtectedSeat'
     */
    const VALUE_PROTECTED_SEAT = 'ProtectedSeat';
    /**
     * Constant for value 'SeatAvailable'
     * @return string 'SeatAvailable'
     */
    const VALUE_SEAT_AVAILABLE = 'SeatAvailable';
    /**
     * Constant for value 'SeatBlocked_AirportUse'
     * @return string 'SeatBlocked_AirportUse'
     */
    const VALUE_SEAT_BLOCKED_AIRPORT_USE = 'SeatBlocked_AirportUse';
    /**
     * Constant for value 'SeatBlocked_Deadload'
     * @return string 'SeatBlocked_Deadload'
     */
    const VALUE_SEAT_BLOCKED_DEADLOAD = 'SeatBlocked_Deadload';
    /**
     * Constant for value 'SeatBlocked_LocalPassengerBoarded'
     * @return string 'SeatBlocked_LocalPassengerBoarded'
     */
    const VALUE_SEAT_BLOCKED_LOCAL_PASSENGER_BOARDED = 'SeatBlocked_LocalPassengerBoarded';
    /**
     * Constant for value 'SeatBlocked_OtherReason'
     * @return string 'SeatBlocked_OtherReason'
     */
    const VALUE_SEAT_BLOCKED_OTHER_REASON = 'SeatBlocked_OtherReason';
    /**
     * Constant for value 'SeatBlocked_ThroughPassengerBoarded'
     * @return string 'SeatBlocked_ThroughPassengerBoarded'
     */
    const VALUE_SEAT_BLOCKED_THROUGH_PASSENGER_BOARDED = 'SeatBlocked_ThroughPassengerBoarded';
    /**
     * Constant for value 'SeatHeld'
     * @return string 'SeatHeld'
     */
    const VALUE_SEAT_HELD = 'SeatHeld';
    /**
     * Constant for value 'SeatNotAvailableForInterlineThroughCheckin'
     * @return string 'SeatNotAvailableForInterlineThroughCheckin'
     */
    const VALUE_SEAT_NOT_AVAILABLE_FOR_INTERLINE_THROUGH_CHECKIN = 'SeatNotAvailableForInterlineThroughCheckin';
    /**
     * Constant for value 'SeatNotAvailableForPartnerAirlineUse '
     * @return string 'SeatNotAvailableForPartnerAirlineUse '
     */
    const VALUE_SEAT_NOT_AVAILABLE_FOR_PARTNER_AIRLINE_USE = 'SeatNotAvailableForPartnerAirlineUse ';
    /**
     * Constant for value 'SeatProtectedForCodeSharing'
     * @return string 'SeatProtectedForCodeSharing'
     */
    const VALUE_SEAT_PROTECTED_FOR_CODE_SHARING = 'SeatProtectedForCodeSharing';
    /**
     * Constant for value 'SeatOccupied'
     * @return string 'SeatOccupied'
     */
    const VALUE_SEAT_OCCUPIED = 'SeatOccupied';
    /**
     * Constant for value 'SeatOccupied_MedicalReasons'
     * @return string 'SeatOccupied_MedicalReasons'
     */
    const VALUE_SEAT_OCCUPIED_MEDICAL_REASONS = 'SeatOccupied_MedicalReasons';
    /**
     * Constant for value 'SeatReserved'
     * @return string 'SeatReserved'
     */
    const VALUE_SEAT_RESERVED = 'SeatReserved';
    /**
     * Constant for value 'SeatReserved_Generic'
     * @return string 'SeatReserved_Generic'
     */
    const VALUE_SEAT_RESERVED_GENERIC = 'SeatReserved_Generic';
    /**
     * Constant for value 'TransitPassengerOrLoad'
     * @return string 'TransitPassengerOrLoad'
     */
    const VALUE_TRANSIT_PASSENGER_OR_LOAD = 'TransitPassengerOrLoad';
    /**
     * Constant for value 'UplineProtectedSeat '
     * @return string 'UplineProtectedSeat '
     */
    const VALUE_UPLINE_PROTECTED_SEAT = 'UplineProtectedSeat ';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use this value to provide an extended enumeration that is not in the provided list. | It is strongly recommended that you submit a comment to have any of your extended list values permanently added to the OpenTravel specification to
     * support maximum trading partner interoperability. http://www.opentraveldevelopersnetwork.com/specificationcomments/2/entercomment.html
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADVANCED_SEAT_SELECTION_SEAT
     * @uses self::VALUE_COURTESY_RESERVED_SEAT
     * @uses self::VALUE_DOWNLINE_PROTECTED_SEATS
     * @uses self::VALUE_EXTRA_SEAT
     * @uses self::VALUE_FREE_SEAT
     * @uses self::VALUE_GROUP_PREALLOCATION_SEAT
     * @uses self::VALUE_NO_SEAT_HERE
     * @uses self::VALUE_PROTECTED_SEAT
     * @uses self::VALUE_SEAT_AVAILABLE
     * @uses self::VALUE_SEAT_BLOCKED_AIRPORT_USE
     * @uses self::VALUE_SEAT_BLOCKED_DEADLOAD
     * @uses self::VALUE_SEAT_BLOCKED_LOCAL_PASSENGER_BOARDED
     * @uses self::VALUE_SEAT_BLOCKED_OTHER_REASON
     * @uses self::VALUE_SEAT_BLOCKED_THROUGH_PASSENGER_BOARDED
     * @uses self::VALUE_SEAT_HELD
     * @uses self::VALUE_SEAT_NOT_AVAILABLE_FOR_INTERLINE_THROUGH_CHECKIN
     * @uses self::VALUE_SEAT_NOT_AVAILABLE_FOR_PARTNER_AIRLINE_USE
     * @uses self::VALUE_SEAT_PROTECTED_FOR_CODE_SHARING
     * @uses self::VALUE_SEAT_OCCUPIED
     * @uses self::VALUE_SEAT_OCCUPIED_MEDICAL_REASONS
     * @uses self::VALUE_SEAT_RESERVED
     * @uses self::VALUE_SEAT_RESERVED_GENERIC
     * @uses self::VALUE_TRANSIT_PASSENGER_OR_LOAD
     * @uses self::VALUE_UPLINE_PROTECTED_SEAT
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADVANCED_SEAT_SELECTION_SEAT,
            self::VALUE_COURTESY_RESERVED_SEAT,
            self::VALUE_DOWNLINE_PROTECTED_SEATS,
            self::VALUE_EXTRA_SEAT,
            self::VALUE_FREE_SEAT,
            self::VALUE_GROUP_PREALLOCATION_SEAT,
            self::VALUE_NO_SEAT_HERE,
            self::VALUE_PROTECTED_SEAT,
            self::VALUE_SEAT_AVAILABLE,
            self::VALUE_SEAT_BLOCKED_AIRPORT_USE,
            self::VALUE_SEAT_BLOCKED_DEADLOAD,
            self::VALUE_SEAT_BLOCKED_LOCAL_PASSENGER_BOARDED,
            self::VALUE_SEAT_BLOCKED_OTHER_REASON,
            self::VALUE_SEAT_BLOCKED_THROUGH_PASSENGER_BOARDED,
            self::VALUE_SEAT_HELD,
            self::VALUE_SEAT_NOT_AVAILABLE_FOR_INTERLINE_THROUGH_CHECKIN,
            self::VALUE_SEAT_NOT_AVAILABLE_FOR_PARTNER_AIRLINE_USE,
            self::VALUE_SEAT_PROTECTED_FOR_CODE_SHARING,
            self::VALUE_SEAT_OCCUPIED,
            self::VALUE_SEAT_OCCUPIED_MEDICAL_REASONS,
            self::VALUE_SEAT_RESERVED,
            self::VALUE_SEAT_RESERVED_GENERIC,
            self::VALUE_TRANSIT_PASSENGER_OR_LOAD,
            self::VALUE_UPLINE_PROTECTED_SEAT,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
