<?php

namespace EnumType;

/**
 * This class stands for EMD_Type EnumType
 * Meta information extracted from the WSDL
 * - documentation: Type of EMD. EMD-S (standalone) or EMD-A (associated with flight segment and an eticket.)
 * @subpackage Enumerations
 */
class EMD_Type
{
    /**
     * Constant for value 'EMD-S'
     * @return string 'EMD-S'
     */
    const VALUE_EMD_S = 'EMD-S';
    /**
     * Constant for value 'EMD-A'
     * @return string 'EMD-A'
     */
    const VALUE_EMD_A = 'EMD-A';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EMD_S
     * @uses self::VALUE_EMD_A
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EMD_S,
            self::VALUE_EMD_A,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
