<?php

namespace EnumType;

/**
 * This class stands for Code EnumType
 * Meta information extracted from the WSDL
 * - documentation: A code identifying the taxable status of an item e.g. E (Exempt), S (Standard) etc..
 * @subpackage Enumerations
 */
class Code
{
    /**
     * Constant for value 'E'
     * @return string 'E'
     */
    const VALUE_E = 'E';
    /**
     * Constant for value 'S'
     * @return string 'S'
     */
    const VALUE_S = 'S';
    /**
     * Constant for value 'Z'
     * @return string 'Z'
     */
    const VALUE_Z = 'Z';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_E
     * @uses self::VALUE_S
     * @uses self::VALUE_Z
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_E,
            self::VALUE_S,
            self::VALUE_Z,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
