<?php

namespace EnumType;

/**
 * This class stands for Category EnumType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the unit on which on Extra is charged, e.g. per person, room, adult etc.
 * @subpackage Enumerations
 */
class Category
{
    /**
     * Constant for value 'Room'
     * @return string 'Room'
     */
    const VALUE_ROOM = 'Room';
    /**
     * Constant for value 'Booking'
     * @return string 'Booking'
     */
    const VALUE_BOOKING = 'Booking';
    /**
     * Constant for value 'Person'
     * @return string 'Person'
     */
    const VALUE_PERSON = 'Person';
    /**
     * Constant for value 'Adult'
     * @return string 'Adult'
     */
    const VALUE_ADULT = 'Adult';
    /**
     * Constant for value 'Child'
     * @return string 'Child'
     */
    const VALUE_CHILD = 'Child';
    /**
     * Constant for value 'Car'
     * @return string 'Car'
     */
    const VALUE_CAR = 'Car';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ROOM
     * @uses self::VALUE_BOOKING
     * @uses self::VALUE_PERSON
     * @uses self::VALUE_ADULT
     * @uses self::VALUE_CHILD
     * @uses self::VALUE_CAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ROOM,
            self::VALUE_BOOKING,
            self::VALUE_PERSON,
            self::VALUE_ADULT,
            self::VALUE_CHILD,
            self::VALUE_CAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
