<?php

namespace EnumType;

/**
 * This class stands for AncillaryServiceFamilyEnum EnumType
 * Meta information extracted from the WSDL
 * - documentation: Extensible service family types enumerated list.
 * @subpackage Enumerations
 */
class AncillaryServiceFamilyEnum
{
    /**
     * Constant for value 'All'
     * Meta information extracted from the WSDL
     * - documentation: All service family types.
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'A_FreeBaggageAllowance'
     * Meta information extracted from the WSDL
     * - documentation: Free Baggage Allowance
     * @return string 'A_FreeBaggageAllowance'
     */
    const VALUE_A_FREE_BAGGAGE_ALLOWANCE = 'A_FreeBaggageAllowance';
    /**
     * Constant for value 'C_BaggageCharges'
     * Meta information extracted from the WSDL
     * - documentation: Baggage Charges
     * @return string 'C_BaggageCharges'
     */
    const VALUE_C_BAGGAGE_CHARGES = 'C_BaggageCharges';
    /**
     * Constant for value 'F_FlightRelated'
     * Meta information extracted from the WSDL
     * - documentation: Flight-Related.
     * @return string 'F_FlightRelated'
     */
    const VALUE_F_FLIGHT_RELATED = 'F_FlightRelated';
    /**
     * Constant for value 'T_TicketRelated'
     * Meta information extracted from the WSDL
     * - documentation: Ticket-Related.
     * @return string 'T_TicketRelated'
     */
    const VALUE_T_TICKET_RELATED = 'T_TicketRelated';
    /**
     * Constant for value 'M_MerchandiseRelated'
     * Meta information extracted from the WSDL
     * - documentation: Merchandise-Related
     * @return string 'M_MerchandiseRelated'
     */
    const VALUE_M_MERCHANDISE_RELATED = 'M_MerchandiseRelated';
    /**
     * Constant for value 'R_RuleBuster'
     * Meta information extracted from the WSDL
     * - documentation: Rule Buster (fare override)
     * @return string 'R_RuleBuster'
     */
    const VALUE_R_RULE_BUSTER = 'R_RuleBuster';
    /**
     * Constant for value 'P_PrepaidBaggage'
     * Meta information extracted from the WSDL
     * - documentation: Pre-paid Baggage
     * @return string 'P_PrepaidBaggage'
     */
    const VALUE_P_PREPAID_BAGGAGE = 'P_PrepaidBaggage';
    /**
     * Constant for value 'E_Embargos'
     * Meta information extracted from the WSDL
     * - documentation: Embargos
     * @return string 'E_Embargos'
     */
    const VALUE_E_EMBARGOS = 'E_Embargos';
    /**
     * Constant for value 'GT_GroundTransportationNonAirServices'
     * @return string 'GT_GroundTransportationNonAirServices'
     */
    const VALUE_GT_GROUND_TRANSPORTATION_NON_AIR_SERVICES = 'GT_GroundTransportationNonAirServices';
    /**
     * Constant for value 'IE_InFlightEntertainment'
     * @return string 'IE_InFlightEntertainment'
     */
    const VALUE_IE_IN_FLIGHT_ENTERTAINMENT = 'IE_InFlightEntertainment';
    /**
     * Constant for value 'LG_Lounge'
     * @return string 'LG_Lounge'
     */
    const VALUE_LG_LOUNGE = 'LG_Lounge';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: OpenTravel Reserved words, "Other_" as enumerated value for open enumeration support to support additional compartment type. The Value corresponding to "Other_" will be specified in the "Value" attribute. See CompartmentType.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_A_FREE_BAGGAGE_ALLOWANCE
     * @uses self::VALUE_C_BAGGAGE_CHARGES
     * @uses self::VALUE_F_FLIGHT_RELATED
     * @uses self::VALUE_T_TICKET_RELATED
     * @uses self::VALUE_M_MERCHANDISE_RELATED
     * @uses self::VALUE_R_RULE_BUSTER
     * @uses self::VALUE_P_PREPAID_BAGGAGE
     * @uses self::VALUE_E_EMBARGOS
     * @uses self::VALUE_GT_GROUND_TRANSPORTATION_NON_AIR_SERVICES
     * @uses self::VALUE_IE_IN_FLIGHT_ENTERTAINMENT
     * @uses self::VALUE_LG_LOUNGE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_A_FREE_BAGGAGE_ALLOWANCE,
            self::VALUE_C_BAGGAGE_CHARGES,
            self::VALUE_F_FLIGHT_RELATED,
            self::VALUE_T_TICKET_RELATED,
            self::VALUE_M_MERCHANDISE_RELATED,
            self::VALUE_R_RULE_BUSTER,
            self::VALUE_P_PREPAID_BAGGAGE,
            self::VALUE_E_EMBARGOS,
            self::VALUE_GT_GROUND_TRANSPORTATION_NON_AIR_SERVICES,
            self::VALUE_IE_IN_FLIGHT_ENTERTAINMENT,
            self::VALUE_LG_LOUNGE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
