<?php

namespace EnumType;

/**
 * This class stands for AirTaxExemptionEnum EnumType
 * Meta information extracted from the WSDL
 * - documentation: Types of fees with tax exemption in certain locations.
 * @subpackage Enumerations
 */
class AirTaxExemptionEnum
{
    /**
     * Constant for value 'PFC_PassengerFacilitationCharge'
     * Meta information extracted from the WSDL
     * - documentation: Free Baggage Allowance
     * @return string 'PFC_PassengerFacilitationCharge'
     */
    const VALUE_PFC_PASSENGER_FACILITATION_CHARGE = 'PFC_PassengerFacilitationCharge';
    /**
     * Constant for value 'ZP_DomesticSegment'
     * Meta information extracted from the WSDL
     * - documentation: Baggage Charges
     * @return string 'ZP_DomesticSegment'
     */
    const VALUE_ZP_DOMESTIC_SEGMENT = 'ZP_DomesticSegment';
    /**
     * Constant for value 'AY_SecurityFee'
     * Meta information extracted from the WSDL
     * - documentation: Flight-Related.
     * @return string 'AY_SecurityFee'
     */
    const VALUE_AY_SECURITY_FEE = 'AY_SecurityFee';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: OpenTravel Reserved words, "Other_" as enumerated value for open enumeration support to support additional compartment type. The Value corresponding to "Other_" will be specified in the "Value" attribute. See CompartmentType.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PFC_PASSENGER_FACILITATION_CHARGE
     * @uses self::VALUE_ZP_DOMESTIC_SEGMENT
     * @uses self::VALUE_AY_SECURITY_FEE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PFC_PASSENGER_FACILITATION_CHARGE,
            self::VALUE_ZP_DOMESTIC_SEGMENT,
            self::VALUE_AY_SECURITY_FEE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
