<?php

namespace EnumType;

/**
 * This class stands for AccommodationClassEnum EnumType
 * Meta information extracted from the WSDL
 * - documentation: Rail accommodation types with an "Other" value to support open enumeration list.
 * @subpackage Enumerations
 */
class AccommodationClassEnum
{
    /**
     * Constant for value 'FirstClass'
     * @return string 'FirstClass'
     */
    const VALUE_FIRST_CLASS = 'FirstClass';
    /**
     * Constant for value 'SecondClass'
     * @return string 'SecondClass'
     */
    const VALUE_SECOND_CLASS = 'SecondClass';
    /**
     * Constant for value 'Premium'
     * @return string 'Premium'
     */
    const VALUE_PREMIUM = 'Premium';
    /**
     * Constant for value 'Business'
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Constant for value 'Leisure'
     * @return string 'Leisure'
     */
    const VALUE_LEISURE = 'Leisure';
    /**
     * Constant for value 'Coach'
     * @return string 'Coach'
     */
    const VALUE_COACH = 'Coach';
    /**
     * Constant for value 'Deluxe'
     * @return string 'Deluxe'
     */
    const VALUE_DELUXE = 'Deluxe';
    /**
     * Constant for value 'GranClasse'
     * @return string 'GranClasse'
     */
    const VALUE_GRAN_CLASSE = 'GranClasse';
    /**
     * Constant for value 'SoftClass'
     * @return string 'SoftClass'
     */
    const VALUE_SOFT_CLASS = 'SoftClass';
    /**
     * Constant for value 'HardClass'
     * @return string 'HardClass'
     */
    const VALUE_HARD_CLASS = 'HardClass';
    /**
     * Constant for value 'SpecialClass'
     * @return string 'SpecialClass'
     */
    const VALUE_SPECIAL_CLASS = 'SpecialClass';
    /**
     * Constant for value 'HighGradeSoftClass'
     * @return string 'HighGradeSoftClass'
     */
    const VALUE_HIGH_GRADE_SOFT_CLASS = 'HighGradeSoftClass';
    /**
     * Constant for value 'MixedHardClass'
     * @return string 'MixedHardClass'
     */
    const VALUE_MIXED_HARD_CLASS = 'MixedHardClass';
    /**
     * Constant for value 'MixedSoftClass'
     * @return string 'MixedSoftClass'
     */
    const VALUE_MIXED_SOFT_CLASS = 'MixedSoftClass';
    /**
     * Constant for value 'SoftCompartmentClass'
     * @return string 'SoftCompartmentClass'
     */
    const VALUE_SOFT_COMPARTMENT_CLASS = 'SoftCompartmentClass';
    /**
     * Constant for value 'HardCompartmentClass'
     * @return string 'HardCompartmentClass'
     */
    const VALUE_HARD_COMPARTMENT_CLASS = 'HardCompartmentClass';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: OpenTravel Reserved words, "Other_" as enumerated value for open enumeration support. See AccommodationClass.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIRST_CLASS
     * @uses self::VALUE_SECOND_CLASS
     * @uses self::VALUE_PREMIUM
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_LEISURE
     * @uses self::VALUE_COACH
     * @uses self::VALUE_DELUXE
     * @uses self::VALUE_GRAN_CLASSE
     * @uses self::VALUE_SOFT_CLASS
     * @uses self::VALUE_HARD_CLASS
     * @uses self::VALUE_SPECIAL_CLASS
     * @uses self::VALUE_HIGH_GRADE_SOFT_CLASS
     * @uses self::VALUE_MIXED_HARD_CLASS
     * @uses self::VALUE_MIXED_SOFT_CLASS
     * @uses self::VALUE_SOFT_COMPARTMENT_CLASS
     * @uses self::VALUE_HARD_COMPARTMENT_CLASS
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIRST_CLASS,
            self::VALUE_SECOND_CLASS,
            self::VALUE_PREMIUM,
            self::VALUE_BUSINESS,
            self::VALUE_LEISURE,
            self::VALUE_COACH,
            self::VALUE_DELUXE,
            self::VALUE_GRAN_CLASSE,
            self::VALUE_SOFT_CLASS,
            self::VALUE_HARD_CLASS,
            self::VALUE_SPECIAL_CLASS,
            self::VALUE_HIGH_GRADE_SOFT_CLASS,
            self::VALUE_MIXED_HARD_CLASS,
            self::VALUE_MIXED_SOFT_CLASS,
            self::VALUE_SOFT_COMPARTMENT_CLASS,
            self::VALUE_HARD_COMPARTMENT_CLASS,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
