<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'CodeListSummaryExtension' => '\\StructType\\CodeListSummaryExtension',
            'CodeListDetailExtension' => '\\StructType\\CodeListDetailExtension',
            'CodeListExtension' => '\\StructType\\CodeListExtension',
            'CodeListFeeType' => '\\StructType\\CodeListFeeType',
            'Amount' => '\\StructType\\Amount',
            'Currency' => '\\StructType\\Currency',
            'AlternateCurrency' => '\\StructType\\AlternateCurrency',
            'Qualifiers' => '\\StructType\\Qualifiers',
            'ChargeUnit' => '\\StructType\\ChargeUnit',
            'Unit' => '\\StructType\\Unit',
            'Frequency' => '\\StructType\\Frequency',
            'Taxes' => '\\StructType\\Taxes',
            'CodeListScheduleType' => '\\StructType\\CodeListScheduleType',
            'OperationTimes' => '\\StructType\\OperationTimes',
            'OperationTime' => '\\StructType\\OperationTime',
            'List_AdditionalOperationInfo' => '\\StructType\\List_AdditionalOperationInfo',
            'List_AgeCategory' => '\\StructType\\List_AgeCategory',
            'List_AirFareDateType' => '\\StructType\\List_AirFareDateType',
            'List_AirTripType' => '\\StructType\\List_AirTripType',
            'List_ApplyToLevel' => '\\StructType\\List_ApplyToLevel',
            'List_BankAccountType' => '\\StructType\\List_BankAccountType',
            'List_CabinClass' => '\\StructType\\List_CabinClass',
            'List_ChargeFrequency' => '\\StructType\\List_ChargeFrequency',
            'List_ChargeUnit' => '\\StructType\\List_ChargeUnit',
            'List_DataActionType' => '\\StructType\\List_DataActionType',
            'List_FareStatus' => '\\StructType\\List_FareStatus',
            'List_FeeTaxType' => '\\StructType\\List_FeeTaxType',
            'List_GlobalIndicatorType' => '\\StructType\\List_GlobalIndicatorType',
            'List_GolferType' => '\\StructType\\List_GolferType',
            'List_GroundLocationType' => '\\StructType\\List_GroundLocationType',
            'List_GroundServiceProvided' => '\\StructType\\List_GroundServiceProvided',
            'List_LevelOfService' => '\\StructType\\List_LevelOfService',
            'List_LoyaltyPrgCurrency' => '\\StructType\\List_LoyaltyPrgCurrency',
            'List_PaymentCardIssuer' => '\\StructType\\List_PaymentCardIssuer',
            'List_PowerType' => '\\StructType\\List_PowerType',
            'List_Proximity' => '\\StructType\\List_Proximity',
            'List_RateCategory' => '\\StructType\\List_RateCategory',
            'List_RatePlanType' => '\\StructType\\List_RatePlanType',
            'List_RecycledProducts' => '\\StructType\\List_RecycledProducts',
            'List_RecycleFacilityLocation' => '\\StructType\\List_RecycleFacilityLocation',
            'List_ReservationBilling' => '\\StructType\\List_ReservationBilling',
            'List_SSRType' => '\\StructType\\List_SSRType',
            'List_TransactionAction' => '\\StructType\\List_TransactionAction',
            'List_TravelPurpose' => '\\StructType\\List_TravelPurpose',
            'List_UnitOfMeasure' => '\\StructType\\List_UnitOfMeasure',
            'List_VehCategory' => '\\StructType\\List_VehCategory',
            'List_VehChargePurpose' => '\\StructType\\List_VehChargePurpose',
            'List_VehSize' => '\\StructType\\List_VehSize',
            'List_QuestionCategory' => '\\StructType\\List_QuestionCategory',
            'AcceptablePaymentCardsInfoType' => '\\StructType\\AcceptablePaymentCardsInfoType',
            'AcceptablePaymentCards' => '\\StructType\\AcceptablePaymentCards',
            'AcceptablePaymentCard' => '\\StructType\\AcceptablePaymentCard',
            'AcceptedPaymentsType' => '\\StructType\\AcceptedPaymentsType',
            'AcceptedPayment' => '\\StructType\\AcceptedPayment',
            'AddressInfoType' => '\\StructType\\AddressInfoType',
            'AddressType' => '\\StructType\\AddressType',
            'StreetNmbr' => '\\StructType\\StreetNmbr',
            'BldgRoom' => '\\StructType\\BldgRoom',
            'AgeQualifierType' => '\\StructType\\AgeQualifierType',
            'AlternateCurrencyType' => '\\StructType\\AlternateCurrencyType',
            'Conversion' => '\\StructType\\Conversion',
            'BaggageSizeType' => '\\StructType\\BaggageSizeType',
            'BaggageSpecificationType' => '\\StructType\\BaggageSpecificationType',
            'SpecialItem' => '\\StructType\\SpecialItem',
            'BaggageWeightType' => '\\StructType\\BaggageWeightType',
            'BankAcctType' => '\\StructType\\BankAcctType',
            'BlackoutDateType' => '\\StructType\\BlackoutDateType',
            'CancelInfoRQType' => '\\StructType\\CancelInfoRQType',
            'CancelInfoRSType' => '\\StructType\\CancelInfoRSType',
            'CancelRules' => '\\StructType\\CancelRules',
            'CancelRuleType' => '\\StructType\\CancelRuleType',
            'CommentType' => '\\StructType\\CommentType',
            'Comment' => '\\StructType\\Comment',
            'CommissionType' => '\\StructType\\CommissionType',
            'CommissionableAmount' => '\\StructType\\CommissionableAmount',
            'PrepaidAmount' => '\\StructType\\PrepaidAmount',
            'FlatCommission' => '\\StructType\\FlatCommission',
            'CommissionPayableAmount' => '\\StructType\\CommissionPayableAmount',
            'CompanyNameType' => '\\StructType\\CompanyNameType',
            'ConnectionType' => '\\StructType\\ConnectionType',
            'ConnectionLocation' => '\\StructType\\ConnectionLocation',
            'ContactPersonType' => '\\StructType\\ContactPersonType',
            'Telephone' => '\\StructType\\Telephone',
            'CountryNameType' => '\\StructType\\CountryNameType',
            'CoverageLimitType' => '\\StructType\\CoverageLimitType',
            'Deductible' => '\\StructType\\Deductible',
            'PolicyLimit' => '\\StructType\\PolicyLimit',
            'IndividualLimit' => '\\StructType\\IndividualLimit',
            'CustomerType' => '\\StructType\\CustomerType',
            'Email' => '\\StructType\\Email',
            'Address' => '\\StructType\\Address',
            'URL' => '\\StructType\\URL',
            'CitizenCountryName' => '\\StructType\\CitizenCountryName',
            'PhysChallName' => '\\StructType\\PhysChallName',
            'PaymentForm' => '\\StructType\\PaymentForm',
            'AssociatedSupplier' => '\\StructType\\AssociatedSupplier',
            'CustLoyalty' => '\\StructType\\CustLoyalty',
            'MemberPreferences' => '\\StructType\\MemberPreferences',
            'AdditionalReward' => '\\StructType\\AdditionalReward',
            'Offer' => '\\StructType\\Offer',
            'Communication' => '\\StructType\\Communication',
            'SecurityInfo' => '\\StructType\\SecurityInfo',
            'PasswordHint' => '\\StructType\\PasswordHint',
            'SubAccountBalance' => '\\StructType\\SubAccountBalance',
            'AdditionalLanguage' => '\\StructType\\AdditionalLanguage',
            'DateTimeSpanType' => '\\StructType\\DateTimeSpanType',
            'StartDateWindow' => '\\StructType\\StartDateWindow',
            'EndDateWindow' => '\\StructType\\EndDateWindow',
            'DirectBillType' => '\\StructType\\DirectBillType',
            'CompanyName' => '\\StructType\\CompanyName',
            'DocumentType' => '\\StructType\\DocumentType',
            'AdditionalPersonNames' => '\\StructType\\AdditionalPersonNames',
            'DonationType' => '\\StructType\\DonationType',
            'FrontOfficeInfo' => '\\StructType\\FrontOfficeInfo',
            'CreditCardInfo' => '\\StructType\\CreditCardInfo',
            'DonorInfo' => '\\StructType\\DonorInfo',
            'Name' => '\\StructType\\Name',
            'ContactInfo' => '\\StructType\\ContactInfo',
            'EmailType' => '\\StructType\\EmailType',
            'EmployeeInfoType' => '\\StructType\\EmployeeInfoType',
            'EncryptionTokenType' => '\\StructType\\EncryptionTokenType',
            'EquipmentType' => '\\StructType\\EquipmentType',
            'ErrorsType' => '\\StructType\\ErrorsType',
            'ErrorType' => '\\StructType\\ErrorType',
            'FeesType' => '\\StructType\\FeesType',
            'FeeType' => '\\StructType\\FeeType',
            'FlightSegmentBaseType' => '\\StructType\\FlightSegmentBaseType',
            'DepartureAirport' => '\\StructType\\DepartureAirport',
            'ArrivalAirport' => '\\StructType\\ArrivalAirport',
            'FormattedTextSubSectionType' => '\\StructType\\FormattedTextSubSectionType',
            'FormattedTextTextType' => '\\StructType\\FormattedTextTextType',
            'FormattedTextType' => '\\StructType\\FormattedTextType',
            'FreeTextType' => '\\StructType\\FreeTextType',
            'ImageDescriptionType' => '\\StructType\\ImageDescriptionType',
            'ImageFormat' => '\\StructType\\ImageFormat',
            'Description' => '\\StructType\\Description',
            'ImageItemsType' => '\\StructType\\ImageItemsType',
            'ImageItem' => '\\StructType\\ImageItem',
            'ImageItemType' => '\\StructType\\ImageItemType',
            'IndCoverageReqsType' => '\\StructType\\IndCoverageReqsType',
            'IndTripCost' => '\\StructType\\IndTripCost',
            'FlightAccidentAmount' => '\\StructType\\FlightAccidentAmount',
            'CoveredLuggage' => '\\StructType\\CoveredLuggage',
            'LuggageItem' => '\\StructType\\LuggageItem',
            'ItemDeclaredValue' => '\\StructType\\ItemDeclaredValue',
            'LuggagePremium' => '\\StructType\\LuggagePremium',
            'PreexistingConditions' => '\\StructType\\PreexistingConditions',
            'PreexistingCondition' => '\\StructType\\PreexistingCondition',
            'InsuranceCustomerType' => '\\StructType\\InsuranceCustomerType',
            'ItemSearchCriterionType' => '\\StructType\\ItemSearchCriterionType',
            'Position' => '\\StructType\\Position',
            'RefPoint' => '\\StructType\\RefPoint',
            'CodeRef' => '\\StructType\\CodeRef',
            'HotelRef' => '\\StructType\\HotelRef',
            'Radius' => '\\StructType\\Radius',
            'MapArea' => '\\StructType\\MapArea',
            'AdditionalContents' => '\\StructType\\AdditionalContents',
            'AdditionalContent' => '\\StructType\\AdditionalContent',
            'LocationGeneralType' => '\\StructType\\LocationGeneralType',
            'LocationType' => '\\StructType\\LocationType',
            'MessageAcknowledgementType' => '\\StructType\\MessageAcknowledgementType',
            'MonetaryRuleType' => '\\StructType\\MonetaryRuleType',
            'MultimediaDescriptionsType' => '\\StructType\\MultimediaDescriptionsType',
            'MultimediaDescriptionType' => '\\StructType\\MultimediaDescriptionType',
            'MultiModalOfferType' => '\\StructType\\MultiModalOfferType',
            'RequestingParty' => '\\StructType\\RequestingParty',
            'Ontology' => '\\StructType\\Ontology',
            'CompatibleWith' => '\\StructType\\CompatibleWith',
            'RequestedOffer' => '\\StructType\\RequestedOffer',
            'TimePeriod' => '\\StructType\\TimePeriod',
            'EarliestStart' => '\\StructType\\EarliestStart',
            'CalculationMethod' => '\\StructType\\CalculationMethod',
            'Formula' => '\\StructType\\Formula',
            'Distance' => '\\StructType\\Distance',
            'Duration' => '\\StructType\\Duration',
            'MaximumDuration' => '\\StructType\\MaximumDuration',
            'GuidelinePricing' => '\\StructType\\GuidelinePricing',
            'TripCharacteristics' => '\\StructType\\TripCharacteristics',
            'DateTimeDuration' => '\\StructType\\DateTimeDuration',
            'Location' => '\\StructType\\Location',
            'Baggage' => '\\StructType\\Baggage',
            'Animals' => '\\StructType\\Animals',
            'Lodging' => '\\StructType\\Lodging',
            'TravelerCharacteristics' => '\\StructType\\TravelerCharacteristics',
            'Classification' => '\\StructType\\Classification',
            'DetailInfo' => '\\StructType\\DetailInfo',
            'Identification' => '\\StructType\\Identification',
            'OntologyActivityType' => '\\StructType\\OntologyActivityType',
            'Type' => '\\StructType\\Type',
            'OntologyAddressType' => '\\StructType\\OntologyAddressType',
            'Street' => '\\StructType\\Street',
            'City' => '\\StructType\\City',
            'StateProvince' => '\\StructType\\StateProvince',
            'Postal' => '\\StructType\\Postal',
            'Country' => '\\StructType\\Country',
            'OntologyAgeBirthDateType' => '\\StructType\\OntologyAgeBirthDateType',
            'OntologyAnimalType' => '\\StructType\\OntologyAnimalType',
            'Detail' => '\\StructType\\Detail',
            'Weight' => '\\StructType\\Weight',
            'OntologyBaggageType' => '\\StructType\\OntologyBaggageType',
            'Item' => '\\StructType\\Item',
            'OntologyBookingMethodType' => '\\StructType\\OntologyBookingMethodType',
            'OntologyCodeType' => '\\StructType\\OntologyCodeType',
            'OntologyCompanyType' => '\\StructType\\OntologyCompanyType',
            'TravelSegment' => '\\StructType\\TravelSegment',
            'OntologyContactType' => '\\StructType\\OntologyContactType',
            'Phone' => '\\StructType\\Phone',
            'OntologyCurrencyType' => '\\StructType\\OntologyCurrencyType',
            'OntologyDefinitionType' => '\\StructType\\OntologyDefinitionType',
            'OntologyDimensionType' => '\\StructType\\OntologyDimensionType',
            'DimensionUnit' => '\\StructType\\DimensionUnit',
            'OntologyDistanceType' => '\\StructType\\OntologyDistanceType',
            'OntologyExtensionType' => '\\StructType\\OntologyExtensionType',
            'OntologyLocationType' => '\\StructType\\OntologyLocationType',
            'GeneralLocation' => '\\StructType\\GeneralLocation',
            'Geocode' => '\\StructType\\Geocode',
            'UniversalAddress' => '\\StructType\\UniversalAddress',
            'PhysicalLocation' => '\\StructType\\PhysicalLocation',
            'OntologyLodgingType' => '\\StructType\\OntologyLodgingType',
            'PropertyClass' => '\\StructType\\PropertyClass',
            'OntologyLoyaltyType' => '\\StructType\\OntologyLoyaltyType',
            'Sector' => '\\StructType\\Sector',
            'ProgramNameOrCode' => '\\StructType\\ProgramNameOrCode',
            'MemberInfo' => '\\StructType\\MemberInfo',
            'OntologyNameType' => '\\StructType\\OntologyNameType',
            'OntologyOfferType' => '\\StructType\\OntologyOfferType',
            'OntologyPaymentType' => '\\StructType\\OntologyPaymentType',
            'TotalTripPrice' => '\\StructType\\TotalTripPrice',
            'Rate' => '\\StructType\\Rate',
            'Category' => '\\StructType\\Category',
            'Code' => '\\StructType\\Code',
            'PaymentStatus' => '\\StructType\\PaymentStatus',
            'PaymentMethod' => '\\StructType\\PaymentMethod',
            'CardType' => '\\StructType\\CardType',
            'CardIssuer' => '\\StructType\\CardIssuer',
            'OntologyPricingMethodType' => '\\StructType\\OntologyPricingMethodType',
            'OntologyReservationStatusType' => '\\StructType\\OntologyReservationStatusType',
            'OntologyTimeDurationType' => '\\StructType\\OntologyTimeDurationType',
            'StartAndEnd' => '\\StructType\\StartAndEnd',
            'OntologyTransportationType' => '\\StructType\\OntologyTransportationType',
            'TripDirection' => '\\StructType\\TripDirection',
            'FlightAndRail' => '\\StructType\\FlightAndRail',
            'Number' => '\\StructType\\Number',
            'Class' => '\\StructType\\_Class',
            'Vehicle' => '\\StructType\\Vehicle',
            'Make' => '\\StructType\\Make',
            'Model' => '\\StructType\\Model',
            'OntologyTravelerClassType' => '\\StructType\\OntologyTravelerClassType',
            'AgeCategory' => '\\StructType\\AgeCategory',
            'PassengerCategory' => '\\StructType\\PassengerCategory',
            'OntologyTripModeType' => '\\StructType\\OntologyTripModeType',
            'OntologyTripPurposeType' => '\\StructType\\OntologyTripPurposeType',
            'OntologyWeightType' => '\\StructType\\OntologyWeightType',
            'WeightUnit' => '\\StructType\\WeightUnit',
            'OntologyValueType' => '\\StructType\\OntologyValueType',
            'ScoreBasis' => '\\StructType\\ScoreBasis',
            'OperatingAirlineType' => '\\StructType\\OperatingAirlineType',
            'OperationSchedulePlusChargeType' => '\\StructType\\OperationSchedulePlusChargeType',
            'OperationSchedulesPlusChargeType' => '\\StructType\\OperationSchedulesPlusChargeType',
            'OperationSchedule' => '\\StructType\\OperationSchedule',
            'OperationSchedulesType' => '\\StructType\\OperationSchedulesType',
            'OperationScheduleType' => '\\StructType\\OperationScheduleType',
            'OrdersType' => '\\StructType\\OrdersType',
            'Order' => '\\StructType\\Order',
            'Products' => '\\StructType\\Products',
            'Product' => '\\StructType\\Product',
            'OriginDestinationInformationType' => '\\StructType\\OriginDestinationInformationType',
            'OriginLocation' => '\\StructType\\OriginLocation',
            'DestinationLocation' => '\\StructType\\DestinationLocation',
            'ParagraphType' => '\\StructType\\ParagraphType',
            'ListItem' => '\\StructType\\ListItem',
            'PaymentCardType' => '\\StructType\\PaymentCardType',
            'Issuer' => '\\StructType\\Issuer',
            'ThreeDomainSecurity' => '\\StructType\\ThreeDomainSecurity',
            'Gateway' => '\\StructType\\Gateway',
            'AuthenticationVerificationValue' => '\\StructType\\AuthenticationVerificationValue',
            'TransactionPassword' => '\\StructType\\TransactionPassword',
            'Results' => '\\StructType\\Results',
            'SignatureOnFile' => '\\StructType\\SignatureOnFile',
            'PaymentDetailType' => '\\StructType\\PaymentDetailType',
            'PaymentAmount' => '\\StructType\\PaymentAmount',
            'PaymentFormType' => '\\StructType\\PaymentFormType',
            'Voucher' => '\\StructType\\Voucher',
            'BillingAccountName' => '\\StructType\\BillingAccountName',
            'LoyaltyRedemption' => '\\StructType\\LoyaltyRedemption',
            'LoyaltyCertificate' => '\\StructType\\LoyaltyCertificate',
            'MiscChargeOrder' => '\\StructType\\MiscChargeOrder',
            'Ticket' => '\\StructType\\Ticket',
            'ConjunctionTicketNbr' => '\\StructType\\ConjunctionTicketNbr',
            'Cash' => '\\StructType\\Cash',
            'PaymentRulesType' => '\\StructType\\PaymentRulesType',
            'PersonNameType' => '\\StructType\\PersonNameType',
            'Document' => '\\StructType\\Document',
            'PlanCostType' => '\\StructType\\PlanCostType',
            'BasePremium' => '\\StructType\\BasePremium',
            'Charges' => '\\StructType\\Charges',
            'POS_Type' => '\\StructType\\POS_Type',
            'RateQualifierType' => '\\StructType\\RateQualifierType',
            'RateComments' => '\\StructType\\RateComments',
            'RateComment' => '\\StructType\\RateComment',
            'RebateType' => '\\StructType\\RebateType',
            'RecipientInfosType' => '\\StructType\\RecipientInfosType',
            'RecipientInfo' => '\\StructType\\RecipientInfo',
            'ShippingInfo' => '\\StructType\\ShippingInfo',
            'Comments' => '\\StructType\\Comments',
            'ReferencePlaceHolderType' => '\\StructType\\ReferencePlaceHolderType',
            'RelatedTravelerType' => '\\StructType\\RelatedTravelerType',
            'RelativePositionType' => '\\StructType\\RelativePositionType',
            'RestaurantType' => '\\StructType\\RestaurantType',
            'MultimediaDescriptions' => '\\StructType\\MultimediaDescriptions',
            'InfoCodes' => '\\StructType\\InfoCodes',
            'InfoCode' => '\\StructType\\InfoCode',
            'CuisineCodes' => '\\StructType\\CuisineCodes',
            'CuisineCode' => '\\StructType\\CuisineCode',
            'SearchTravelerType' => '\\StructType\\SearchTravelerType',
            'SourceType' => '\\StructType\\SourceType',
            'RequestorID' => '\\StructType\\RequestorID',
            'BookingChannel' => '\\StructType\\BookingChannel',
            'SpecialRequestType' => '\\StructType\\SpecialRequestType',
            'SpecialRequest' => '\\StructType\\SpecialRequest',
            'StateProvType' => '\\StructType\\StateProvType',
            'StatusType' => '\\StructType\\StatusType',
            'StreetNmbrType' => '\\StructType\\StreetNmbrType',
            'SuccessType' => '\\StructType\\SuccessType',
            'TaxesType' => '\\StructType\\TaxesType',
            'TaxType' => '\\StructType\\TaxType',
            'TextDescriptionType' => '\\StructType\\TextDescriptionType',
            'TextItemsType' => '\\StructType\\TextItemsType',
            'TextItem' => '\\StructType\\TextItem',
            'TimeDurationType' => '\\StructType\\TimeDurationType',
            'TimeInstantType' => '\\StructType\\TimeInstantType',
            'TotalType' => '\\StructType\\TotalType',
            'TPA_ExtensionsType' => '\\StructType\\TPA_ExtensionsType',
            'TransportationsType' => '\\StructType\\TransportationsType',
            'TransportationType' => '\\StructType\\TransportationType',
            'Transportation' => '\\StructType\\Transportation',
            'TravelDateTimeType' => '\\StructType\\TravelDateTimeType',
            'TravelerRPHs' => '\\StructType\\TravelerRPHs',
            'TravelerRPH' => '\\StructType\\TravelerRPH',
            'UniqueID_Type' => '\\StructType\\UniqueID_Type',
            'URL_Type' => '\\StructType\\URL_Type',
            'VendorMessagesType' => '\\StructType\\VendorMessagesType',
            'VendorMessageType' => '\\StructType\\VendorMessageType',
            'VerificationType' => '\\StructType\\VerificationType',
            'PersonName' => '\\StructType\\PersonName',
            'TelephoneInfo' => '\\StructType\\TelephoneInfo',
            'ReservationTimeSpan' => '\\StructType\\ReservationTimeSpan',
            'AssociatedQuantity' => '\\StructType\\AssociatedQuantity',
            'StartLocation' => '\\StructType\\StartLocation',
            'EndLocation' => '\\StructType\\EndLocation',
            'VideoDescriptionType' => '\\StructType\\VideoDescriptionType',
            'VideoFormat' => '\\StructType\\VideoFormat',
            'VideoItemsType' => '\\StructType\\VideoItemsType',
            'VideoItem' => '\\StructType\\VideoItem',
            'VideoItemType' => '\\StructType\\VideoItemType',
            'WarningsType' => '\\StructType\\WarningsType',
            'WarningType' => '\\StructType\\WarningType',
            'WrittenConfInstType' => '\\StructType\\WrittenConfInstType',
            'AdvResTicketingType' => '\\StructType\\AdvResTicketingType',
            'AdvReservation' => '\\StructType\\AdvReservation',
            'AdvTicketing' => '\\StructType\\AdvTicketing',
            'AirAncillaryServiceType' => '\\StructType\\AirAncillaryServiceType',
            'ProductGroup' => '\\StructType\\ProductGroup',
            'SubGroup' => '\\StructType\\SubGroup',
            'AirArrangerType' => '\\StructType\\AirArrangerType',
            'ProfileRef' => '\\StructType\\ProfileRef',
            'AirFeeType' => '\\StructType\\AirFeeType',
            'AirInsuranceOfferType' => '\\StructType\\AirInsuranceOfferType',
            'TotalTripCost' => '\\StructType\\TotalTripCost',
            'AirItineraryPricingInfoType' => '\\StructType\\AirItineraryPricingInfoType',
            'ItinTotalFare' => '\\StructType\\ItinTotalFare',
            'PTC_FareBreakdowns' => '\\StructType\\PTC_FareBreakdowns',
            'FareInfos' => '\\StructType\\FareInfos',
            'FareInfo' => '\\StructType\\FareInfo',
            'AirItineraryType' => '\\StructType\\AirItineraryType',
            'OriginDestinationOptions' => '\\StructType\\OriginDestinationOptions',
            'OriginDestinationOption' => '\\StructType\\OriginDestinationOption',
            'AirLandProductType' => '\\StructType\\AirLandProductType',
            'AirOfferChoiceType' => '\\StructType\\AirOfferChoiceType',
            'Summary' => '\\StructType\\Summary',
            'Priced' => '\\StructType\\Priced',
            'AirOfferType' => '\\StructType\\AirOfferType',
            'Restriction' => '\\StructType\\Restriction',
            'TermsAndConditions' => '\\StructType\\TermsAndConditions',
            'VoluntaryChanges' => '\\StructType\\VoluntaryChanges',
            'VoluntaryRefunds' => '\\StructType\\VoluntaryRefunds',
            'AirPricedInsuranceType' => '\\StructType\\AirPricedInsuranceType',
            'AirPricedOfferType' => '\\StructType\\AirPricedOfferType',
            'Pricing' => '\\StructType\\Pricing',
            'PricingDetail' => '\\StructType\\PricingDetail',
            'OriginDestination' => '\\StructType\\OriginDestination',
            'AlternateLocationInfo' => '\\StructType\\AlternateLocationInfo',
            'SeatInfo' => '\\StructType\\SeatInfo',
            'OtherServices' => '\\StructType\\OtherServices',
            'TripInsurance' => '\\StructType\\TripInsurance',
            'CoveredTraveler' => '\\StructType\\CoveredTraveler',
            'BookingInstruction' => '\\StructType\\BookingInstruction',
            'Upgrade' => '\\StructType\\Upgrade',
            'Multimedia' => '\\StructType\\Multimedia',
            'AirPricingQualifierType' => '\\StructType\\AirPricingQualifierType',
            'Restrictions' => '\\StructType\\Restrictions',
            'TaxExemption' => '\\StructType\\TaxExemption',
            'TaxCode' => '\\StructType\\TaxCode',
            'DesignatorCode' => '\\StructType\\DesignatorCode',
            'PromotionCode' => '\\StructType\\PromotionCode',
            'AirPurchasedOfferType' => '\\StructType\\AirPurchasedOfferType',
            'PurchasedItem' => '\\StructType\\PurchasedItem',
            'AirRedemptionMilesType' => '\\StructType\\AirRedemptionMilesType',
            'AirReservationType' => '\\StructType\\AirReservationType',
            'Queues' => '\\StructType\\Queues',
            'Queue' => '\\StructType\\Queue',
            'BookingReferenceID' => '\\StructType\\BookingReferenceID',
            'PricingOverview' => '\\StructType\\PricingOverview',
            'PricingIndicator' => '\\StructType\\PricingIndicator',
            'Account' => '\\StructType\\Account',
            'AirSeatAvailabilityType' => '\\StructType\\AirSeatAvailabilityType',
            'AirSeatMarketingClassType' => '\\StructType\\AirSeatMarketingClassType',
            'CabinInfo' => '\\StructType\\CabinInfo',
            'SubType' => '\\StructType\\SubType',
            'AirTaxType' => '\\StructType\\AirTaxType',
            'AirTravelerType' => '\\StructType\\AirTravelerType',
            'TravelerRefNumber' => '\\StructType\\TravelerRefNumber',
            'FlightSegmentRPHs' => '\\StructType\\FlightSegmentRPHs',
            'AncillaryServiceActionType' => '\\StructType\\AncillaryServiceActionType',
            'AncillaryServiceDetailType' => '\\StructType\\AncillaryServiceDetailType',
            'AppliedRuleType' => '\\StructType\\AppliedRuleType',
            'RuleInfo' => '\\StructType\\RuleInfo',
            'ApplyPriceToType' => '\\StructType\\ApplyPriceToType',
            'AuthorizationType' => '\\StructType\\AuthorizationType',
            'CheckAuthorization' => '\\StructType\\CheckAuthorization',
            'CreditCardAuthorization' => '\\StructType\\CreditCardAuthorization',
            'AccountAuthorization' => '\\StructType\\AccountAuthorization',
            'AccountInfo' => '\\StructType\\AccountInfo',
            'BaggageQueryType' => '\\StructType\\BaggageQueryType',
            'AirlineCarrier' => '\\StructType\\AirlineCarrier',
            'BookFlightSegmentType' => '\\StructType\\BookFlightSegmentType',
            'BookingClassAvails' => '\\StructType\\BookingClassAvails',
            'BookingClassAvail' => '\\StructType\\BookingClassAvail',
            'StopLocation' => '\\StructType\\StopLocation',
            'BookingPriceInfoType' => '\\StructType\\BookingPriceInfoType',
            'BookingReferenceType' => '\\StructType\\BookingReferenceType',
            'CabinAvailabilityType' => '\\StructType\\CabinAvailabilityType',
            'Meal' => '\\StructType\\Meal',
            'BaggageAllowance' => '\\StructType\\BaggageAllowance',
            'Entertainment' => '\\StructType\\Entertainment',
            'FlightLoadInfo' => '\\StructType\\FlightLoadInfo',
            'CabinClassAvailabilityType' => '\\StructType\\CabinClassAvailabilityType',
            'CabinClassDetailType' => '\\StructType\\CabinClassDetailType',
            'CabinClassQueryType' => '\\StructType\\CabinClassQueryType',
            'CabinClassSummaryType' => '\\StructType\\CabinClassSummaryType',
            'EMD_LiteType' => '\\StructType\\EMD_LiteType',
            'Endorsement' => '\\StructType\\Endorsement',
            'TotalFare' => '\\StructType\\TotalFare',
            'Tax' => '\\StructType\\Tax',
            'TicketDocument' => '\\StructType\\TicketDocument',
            'CouponInfo' => '\\StructType\\CouponInfo',
            'ExcessBaggage' => '\\StructType\\ExcessBaggage',
            'PresentInfo' => '\\StructType\\PresentInfo',
            'ReasonForIssuance' => '\\StructType\\ReasonForIssuance',
            'ValidatingAirline' => '\\StructType\\ValidatingAirline',
            'OriginalIssueInfo' => '\\StructType\\OriginalIssueInfo',
            'EMD_Type' => '\\StructType\\EMD_Type',
            'BaseFare' => '\\StructType\\BaseFare',
            'EquivFare' => '\\StructType\\EquivFare',
            'UnstructuredFareCalc' => '\\StructType\\UnstructuredFareCalc',
            'FiledFeeInfo' => '\\StructType\\FiledFeeInfo',
            'Commission' => '\\StructType\\Commission',
            'CarrierFeeInfo' => '\\StructType\\CarrierFeeInfo',
            'CarrierFee' => '\\StructType\\CarrierFee',
            'FeeAmount' => '\\StructType\\FeeAmount',
            'ExchResidualFareComponent' => '\\StructType\\ExchResidualFareComponent',
            'TotalAmount' => '\\StructType\\TotalAmount',
            'ReissuedFlown' => '\\StructType\\ReissuedFlown',
            'TaxCouponInformation' => '\\StructType\\TaxCouponInformation',
            'CouponNumber' => '\\StructType\\CouponNumber',
            'TaxCouponInfo' => '\\StructType\\TaxCouponInfo',
            'UnticketedPointInfo' => '\\StructType\\UnticketedPointInfo',
            'ET_FareInfo' => '\\StructType\\ET_FareInfo',
            'Waiver' => '\\StructType\\Waiver',
            'RuleIndicator' => '\\StructType\\RuleIndicator',
            'FareBasisCodeType' => '\\StructType\\FareBasisCodeType',
            'FareComponentType' => '\\StructType\\FareComponentType',
            'PriceableUnit' => '\\StructType\\PriceableUnit',
            'FareComponentDetail' => '\\StructType\\FareComponentDetail',
            'CouponSequence' => '\\StructType\\CouponSequence',
            'ConstructionPrinciple' => '\\StructType\\ConstructionPrinciple',
            'BaseAmount' => '\\StructType\\BaseAmount',
            'TicketDesignator' => '\\StructType\\TicketDesignator',
            'TotalConstructionAmount' => '\\StructType\\TotalConstructionAmount',
            'FareInfoType' => '\\StructType\\FareInfoType',
            'FareReference' => '\\StructType\\FareReference',
            'Date' => '\\StructType\\Date',
            'Fare' => '\\StructType\\Fare',
            'PTC' => '\\StructType\\PTC',
            'DiscountPricing' => '\\StructType\\DiscountPricing',
            'Airport' => '\\StructType\\Airport',
            'FareType' => '\\StructType\\FareType',
            'Fees' => '\\StructType\\Fees',
            'FareConstruction' => '\\StructType\\FareConstruction',
            'FareBaggageAllowance' => '\\StructType\\FareBaggageAllowance',
            'TourCode' => '\\StructType\\TourCode',
            'Remark' => '\\StructType\\Remark',
            'ExchangeInfo' => '\\StructType\\ExchangeInfo',
            'OriginalOriginDestination' => '\\StructType\\OriginalOriginDestination',
            'Discounts' => '\\StructType\\Discounts',
            'Discount' => '\\StructType\\Discount',
            'FlightLegType' => '\\StructType\\FlightLegType',
            'FlightSegmentType' => '\\StructType\\FlightSegmentType',
            'MarketingAirline' => '\\StructType\\MarketingAirline',
            'FulfillmentType' => '\\StructType\\FulfillmentType',
            'PaymentDetails' => '\\StructType\\PaymentDetails',
            'PaymentDetail' => '\\StructType\\PaymentDetail',
            'Receipt' => '\\StructType\\Receipt',
            'PaymentText' => '\\StructType\\PaymentText',
            'MarketingCabinType' => '\\StructType\\MarketingCabinType',
            'OriginDestinationOptionType' => '\\StructType\\OriginDestinationOptionType',
            'FlightSegment' => '\\StructType\\FlightSegment',
            'OtherServiceInfoType' => '\\StructType\\OtherServiceInfoType',
            'PassengerTypeQuantityType' => '\\StructType\\PassengerTypeQuantityType',
            'PricedItinerariesType' => '\\StructType\\PricedItinerariesType',
            'PricedItinerary' => '\\StructType\\PricedItinerary',
            'PricedItineraryType' => '\\StructType\\PricedItineraryType',
            'AirItineraryPricingInfo' => '\\StructType\\AirItineraryPricingInfo',
            'TicketingInfo' => '\\StructType\\TicketingInfo',
            'DeliveryInfo' => '\\StructType\\DeliveryInfo',
            'PriceRequestInformationType' => '\\StructType\\PriceRequestInformationType',
            'NegotiatedFareCode' => '\\StructType\\NegotiatedFareCode',
            'RebookOption' => '\\StructType\\RebookOption',
            'PrivateFareType' => '\\StructType\\PrivateFareType',
            'FareDetails' => '\\StructType\\FareDetails',
            'PassengerType' => '\\StructType\\PassengerType',
            'PTCFareBreakdownType' => '\\StructType\\PTCFareBreakdownType',
            'FareBasisCodes' => '\\StructType\\FareBasisCodes',
            'PassengerFare' => '\\StructType\\PassengerFare',
            'TicketFeeDetail' => '\\StructType\\TicketFeeDetail',
            'Fee' => '\\StructType\\Fee',
            'BaseFee' => '\\StructType\\BaseFee',
            'Total' => '\\StructType\\Total',
            'TicketDesignators' => '\\StructType\\TicketDesignators',
            'Endorsements' => '\\StructType\\Endorsements',
            'PricingUnit' => '\\StructType\\PricingUnit',
            'FareComponent' => '\\StructType\\FareComponent',
            'FlightLeg' => '\\StructType\\FlightLeg',
            'RowCharacteristicsType' => '\\StructType\\RowCharacteristicsType',
            'RowDetailType' => '\\StructType\\RowDetailType',
            'RowSummaryType' => '\\StructType\\RowSummaryType',
            'RuleInfoType' => '\\StructType\\RuleInfoType',
            'ResTicketingRules' => '\\StructType\\ResTicketingRules',
            'AdvResTicketing' => '\\StructType\\AdvResTicketing',
            'ChargesRules' => '\\StructType\\ChargesRules',
            'SeatDetailsType' => '\\StructType\\SeatDetailsType',
            'Amenity' => '\\StructType\\Amenity',
            'Service' => '\\StructType\\Service',
            'SeatFeaturesType' => '\\StructType\\SeatFeaturesType',
            'SeatMapDetailsType' => '\\StructType\\SeatMapDetailsType',
            'CabinClass' => '\\StructType\\CabinClass',
            'SeatMapQueryType' => '\\StructType\\SeatMapQueryType',
            'FlightInfo' => '\\StructType\\FlightInfo',
            'SpecificSeatInfo' => '\\StructType\\SpecificSeatInfo',
            'SeatDetails' => '\\StructType\\SeatDetails',
            'ResBookDesignations' => '\\StructType\\ResBookDesignations',
            'ResBookDesignation' => '\\StructType\\ResBookDesignation',
            'SeatRequestType' => '\\StructType\\SeatRequestType',
            'SeatSummaryType' => '\\StructType\\SeatSummaryType',
            'SeatZoneDetailType' => '\\StructType\\SeatZoneDetailType',
            'SeatTypeDetail' => '\\StructType\\SeatTypeDetail',
            'SeatZoneQueryType' => '\\StructType\\SeatZoneQueryType',
            'SeatZoneSummaryType' => '\\StructType\\SeatZoneSummaryType',
            'SpecialRemarkType' => '\\StructType\\SpecialRemarkType',
            'FlightRefNumber' => '\\StructType\\FlightRefNumber',
            'AuthorizedViewers' => '\\StructType\\AuthorizedViewers',
            'AuthorizedViewer' => '\\StructType\\AuthorizedViewer',
            'SpecialReqDetailsType' => '\\StructType\\SpecialReqDetailsType',
            'SeatRequests' => '\\StructType\\SeatRequests',
            'SeatRequest' => '\\StructType\\SeatRequest',
            'SpecialServiceRequests' => '\\StructType\\SpecialServiceRequests',
            'SpecialServiceRequest' => '\\StructType\\SpecialServiceRequest',
            'OtherServiceInformations' => '\\StructType\\OtherServiceInformations',
            'OtherServiceInformation' => '\\StructType\\OtherServiceInformation',
            'Remarks' => '\\StructType\\Remarks',
            'SpecialRemarks' => '\\StructType\\SpecialRemarks',
            'SpecialRemark' => '\\StructType\\SpecialRemark',
            'SpecialServiceRequestType' => '\\StructType\\SpecialServiceRequestType',
            'SpecificFlightInfoType' => '\\StructType\\SpecificFlightInfoType',
            'BookingClassPref' => '\\StructType\\BookingClassPref',
            'StayRestrictionsType' => '\\StructType\\StayRestrictionsType',
            'MinimumStay' => '\\StructType\\MinimumStay',
            'MaximumStay' => '\\StructType\\MaximumStay',
            'TicketingInfoRS_Type' => '\\StructType\\TicketingInfoRS_Type',
            'TicketingInfoType' => '\\StructType\\TicketingInfoType',
            'TicketAdvisory' => '\\StructType\\TicketAdvisory',
            'TicketingVendor' => '\\StructType\\TicketingVendor',
            'PricingSystem' => '\\StructType\\PricingSystem',
            'TravelerInformationType' => '\\StructType\\TravelerInformationType',
            'TravelerInfoSummaryType' => '\\StructType\\TravelerInfoSummaryType',
            'PriceRequestInformation' => '\\StructType\\PriceRequestInformation',
            'FareRestrictionPref' => '\\StructType\\FareRestrictionPref',
            'FlightReference' => '\\StructType\\FlightReference',
            'SegmentOverride' => '\\StructType\\SegmentOverride',
            'LocationRequirement' => '\\StructType\\LocationRequirement',
            'TravelerInfoType' => '\\StructType\\TravelerInfoType',
            'AirTraveler' => '\\StructType\\AirTraveler',
            'VoluntaryChangesType' => '\\StructType\\VoluntaryChangesType',
            'Penalty' => '\\StructType\\Penalty',
            'AddressPrefType' => '\\StructType\\AddressPrefType',
            'CommonPrefType' => '\\StructType\\CommonPrefType',
            'ContactPref' => '\\StructType\\ContactPref',
            'CompanyNamePrefType' => '\\StructType\\CompanyNamePrefType',
            'InsurancePrefType' => '\\StructType\\InsurancePrefType',
            'InterestPrefType' => '\\StructType\\InterestPrefType',
            'LoyaltyPrefType' => '\\StructType\\LoyaltyPrefType',
            'MealPrefType' => '\\StructType\\MealPrefType',
            'MediaEntertainPrefType' => '\\StructType\\MediaEntertainPrefType',
            'NamePrefType' => '\\StructType\\NamePrefType',
            'OtherSrvcPrefType' => '\\StructType\\OtherSrvcPrefType',
            'PaymentFormPrefType' => '\\StructType\\PaymentFormPrefType',
            'PetInfoPrefType' => '\\StructType\\PetInfoPrefType',
            'PhonePrefType' => '\\StructType\\PhonePrefType',
            'RelatedTravelerPrefType' => '\\StructType\\RelatedTravelerPrefType',
            'SeatingPrefType' => '\\StructType\\SeatingPrefType',
            'SpecRequestPrefType' => '\\StructType\\SpecRequestPrefType',
            'TicketDistribPrefType' => '\\StructType\\TicketDistribPrefType',
            'AirlinePrefType' => '\\StructType\\AirlinePrefType',
            'VendorPref' => '\\StructType\\VendorPref',
            'FareRestrictPref' => '\\StructType\\FareRestrictPref',
            'FarePref' => '\\StructType\\FarePref',
            'TourCodePref' => '\\StructType\\TourCodePref',
            'TourCodeInfo' => '\\StructType\\TourCodeInfo',
            'StaffTourCodeInfo' => '\\StructType\\StaffTourCodeInfo',
            'FlightTypePref' => '\\StructType\\FlightTypePref',
            'CabinPref' => '\\StructType\\CabinPref',
            'SeatPref' => '\\StructType\\SeatPref',
            'SSR_Pref' => '\\StructType\\SSR_Pref',
            'AccountInformation' => '\\StructType\\AccountInformation',
            'TaxRegistrationDetails' => '\\StructType\\TaxRegistrationDetails',
            'KeywordPref' => '\\StructType\\KeywordPref',
            'AirportPrefType' => '\\StructType\\AirportPrefType',
            'AirSearchPrefsType' => '\\StructType\\AirSearchPrefsType',
            'TicketDistribPref' => '\\StructType\\TicketDistribPref',
            'BookingSeatPref' => '\\StructType\\BookingSeatPref',
            'EquipmentTypePref' => '\\StructType\\EquipmentTypePref',
            'BedTypePrefType' => '\\StructType\\BedTypePrefType',
            'BusinessSrvcPrefType' => '\\StructType\\BusinessSrvcPrefType',
            'FoodSrvcPrefType' => '\\StructType\\FoodSrvcPrefType',
            'HotelPrefType' => '\\StructType\\HotelPrefType',
            'PersonalSrvcPrefType' => '\\StructType\\PersonalSrvcPrefType',
            'PhysChallFeaturePrefType' => '\\StructType\\PhysChallFeaturePrefType',
            'PropertyAmenityPrefType' => '\\StructType\\PropertyAmenityPrefType',
            'PropertyClassPrefType' => '\\StructType\\PropertyClassPrefType',
            'PropertyLocationPrefType' => '\\StructType\\PropertyLocationPrefType',
            'PropertyNamePrefType' => '\\StructType\\PropertyNamePrefType',
            'PropertyTypePrefType' => '\\StructType\\PropertyTypePrefType',
            'RecreationSrvcPrefType' => '\\StructType\\RecreationSrvcPrefType',
            'RoomAmenityPrefType' => '\\StructType\\RoomAmenityPrefType',
            'RoomLocationPrefType' => '\\StructType\\RoomLocationPrefType',
            'SecurityFeaturePrefType' => '\\StructType\\SecurityFeaturePrefType',
            'CoverageDetailsType' => '\\StructType\\CoverageDetailsType',
            'CoveragePricedType' => '\\StructType\\CoveragePricedType',
            'CoverageType' => '\\StructType\\CoverageType',
            'CustomerPrimaryAdditionalType' => '\\StructType\\CustomerPrimaryAdditionalType',
            'Primary' => '\\StructType\\Primary',
            'Additional' => '\\StructType\\Additional',
            'DeductibleType' => '\\StructType\\DeductibleType',
            'NoShowFeeType' => '\\StructType\\NoShowFeeType',
            'Deadline' => '\\StructType\\Deadline',
            'GracePeriod' => '\\StructType\\GracePeriod',
            'OffLocationServiceCoreType' => '\\StructType\\OffLocationServiceCoreType',
            'OffLocationServicePricedType' => '\\StructType\\OffLocationServicePricedType',
            'OffLocationServiceType' => '\\StructType\\OffLocationServiceType',
            'RateRulesType' => '\\StructType\\RateRulesType',
            'AdvanceBooking' => '\\StructType\\AdvanceBooking',
            'PickupReturnRules' => '\\StructType\\PickupReturnRules',
            'EarliestPickup' => '\\StructType\\EarliestPickup',
            'LatestPickup' => '\\StructType\\LatestPickup',
            'LatestReturn' => '\\StructType\\LatestReturn',
            'EarliestReturn' => '\\StructType\\EarliestReturn',
            'RateGuarantee' => '\\StructType\\RateGuarantee',
            'PaymentRules' => '\\StructType\\PaymentRules',
            'AcceptablePayments' => '\\StructType\\AcceptablePayments',
            'AcceptablePayment' => '\\StructType\\AcceptablePayment',
            'CancelPenaltyInfo' => '\\StructType\\CancelPenaltyInfo',
            'PenaltyFee' => '\\StructType\\PenaltyFee',
            'RateDeposit' => '\\StructType\\RateDeposit',
            'VehicleAdditionalDriverRequirementsType' => '\\StructType\\VehicleAdditionalDriverRequirementsType',
            'AddlDriverInfos' => '\\StructType\\AddlDriverInfos',
            'AddlDriverInfo' => '\\StructType\\AddlDriverInfo',
            'Vehicles' => '\\StructType\\Vehicles',
            'VehicleAgeRequirementsType' => '\\StructType\\VehicleAgeRequirementsType',
            'Age' => '\\StructType\\Age',
            'AgeSurcharge' => '\\StructType\\AgeSurcharge',
            'AgeInfos' => '\\StructType\\AgeInfos',
            'AgeInfo' => '\\StructType\\AgeInfo',
            'VehicleArrivalDetailsType' => '\\StructType\\VehicleArrivalDetailsType',
            'VehicleAvailAdditionalInfoType' => '\\StructType\\VehicleAvailAdditionalInfoType',
            'PricedCoverages' => '\\StructType\\PricedCoverages',
            'VehicleAvailCoreType' => '\\StructType\\VehicleAvailCoreType',
            'TotalCharge' => '\\StructType\\TotalCharge',
            'PricedEquips' => '\\StructType\\PricedEquips',
            'Reference' => '\\StructType\\Reference',
            'Vendor' => '\\StructType\\Vendor',
            'VendorLocation' => '\\StructType\\VendorLocation',
            'DropOffLocation' => '\\StructType\\DropOffLocation',
            'VehicleAvailRQAdditionalInfoType' => '\\StructType\\VehicleAvailRQAdditionalInfoType',
            'CoveragePrefs' => '\\StructType\\CoveragePrefs',
            'CoveragePref' => '\\StructType\\CoveragePref',
            'VehicleAvailRQCoreType' => '\\StructType\\VehicleAvailRQCoreType',
            'VendorPrefs' => '\\StructType\\VendorPrefs',
            'VehPrefs' => '\\StructType\\VehPrefs',
            'VehPref' => '\\StructType\\VehPref',
            'DriverType' => '\\StructType\\DriverType',
            'RateQualifier' => '\\StructType\\RateQualifier',
            'RateRange' => '\\StructType\\RateRange',
            'SpecialEquipPrefs' => '\\StructType\\SpecialEquipPrefs',
            'SpecialEquipPref' => '\\StructType\\SpecialEquipPref',
            'VehicleAvailRSAdditionalInfoType' => '\\StructType\\VehicleAvailRSAdditionalInfoType',
            'VehicleAvailRSCoreType' => '\\StructType\\VehicleAvailRSCoreType',
            'VehVendorAvails' => '\\StructType\\VehVendorAvails',
            'VehicleAvailVendorInfoType' => '\\StructType\\VehicleAvailVendorInfoType',
            'TourInfo' => '\\StructType\\TourInfo',
            'VehicleChargePurposeType' => '\\StructType\\VehicleChargePurposeType',
            'VehicleChargeType' => '\\StructType\\VehicleChargeType',
            'TaxAmounts' => '\\StructType\\TaxAmounts',
            'TaxAmount' => '\\StructType\\TaxAmount',
            'MinMax' => '\\StructType\\MinMax',
            'Calculation' => '\\StructType\\Calculation',
            'VehicleCoreType' => '\\StructType\\VehicleCoreType',
            'VehType' => '\\StructType\\VehType',
            'VehClass' => '\\StructType\\VehClass',
            'VehicleEquipmentPricedType' => '\\StructType\\VehicleEquipmentPricedType',
            'VehicleEquipmentType' => '\\StructType\\VehicleEquipmentType',
            'VehicleLocationAdditionalDetailsType' => '\\StructType\\VehicleLocationAdditionalDetailsType',
            'VehRentLocInfos' => '\\StructType\\VehRentLocInfos',
            'Shuttle' => '\\StructType\\Shuttle',
            'ShuttleInfos' => '\\StructType\\ShuttleInfos',
            'ShuttleInfo' => '\\StructType\\ShuttleInfo',
            'OneWayDropLocations' => '\\StructType\\OneWayDropLocations',
            'OneWayDropLocation' => '\\StructType\\OneWayDropLocation',
            'VehicleLocationAdditionalFeesType' => '\\StructType\\VehicleLocationAdditionalFeesType',
            'Surcharges' => '\\StructType\\Surcharges',
            'Surcharge' => '\\StructType\\Surcharge',
            'MiscellaneousCharges' => '\\StructType\\MiscellaneousCharges',
            'MiscellaneousCharge' => '\\StructType\\MiscellaneousCharge',
            'VehicleLocationDetailsType' => '\\StructType\\VehicleLocationDetailsType',
            'VehicleLocationInformationType' => '\\StructType\\VehicleLocationInformationType',
            'VehicleLocationLiabilitiesType' => '\\StructType\\VehicleLocationLiabilitiesType',
            'Coverages' => '\\StructType\\Coverages',
            'Coverage' => '\\StructType\\Coverage',
            'CoverageFees' => '\\StructType\\CoverageFees',
            'CoverageFee' => '\\StructType\\CoverageFee',
            'VehicleLocationVehiclesType' => '\\StructType\\VehicleLocationVehiclesType',
            'VehicleInfos' => '\\StructType\\VehicleInfos',
            'VehicleInfo' => '\\StructType\\VehicleInfo',
            'VehiclePrefType' => '\\StructType\\VehiclePrefType',
            'VehMakeModel' => '\\StructType\\VehMakeModel',
            'VehicleProfileRentalPrefType' => '\\StructType\\VehicleProfileRentalPrefType',
            'LoyaltyPref' => '\\StructType\\LoyaltyPref',
            'PaymentFormPref' => '\\StructType\\PaymentFormPref',
            'VehicleRentalCoreType' => '\\StructType\\VehicleRentalCoreType',
            'PickUpLocation' => '\\StructType\\PickUpLocation',
            'ReturnLocation' => '\\StructType\\ReturnLocation',
            'VehicleRentalDetailsType' => '\\StructType\\VehicleRentalDetailsType',
            'FuelLevelDetails' => '\\StructType\\FuelLevelDetails',
            'OdometerReading' => '\\StructType\\OdometerReading',
            'ConditionReport' => '\\StructType\\ConditionReport',
            'VehicleRentalRateType' => '\\StructType\\VehicleRentalRateType',
            'RateDistance' => '\\StructType\\RateDistance',
            'VehicleCharges' => '\\StructType\\VehicleCharges',
            'RateRestrictions' => '\\StructType\\RateRestrictions',
            'PickupReturnRule' => '\\StructType\\PickupReturnRule',
            'VehicleRentalTransactionType' => '\\StructType\\VehicleRentalTransactionType',
            'PickUpReturnDetails' => '\\StructType\\PickUpReturnDetails',
            'PricedEquip' => '\\StructType\\PricedEquip',
            'Equipment' => '\\StructType\\Equipment',
            'VehicleReservationRQAdditionalInfoType' => '\\StructType\\VehicleReservationRQAdditionalInfoType',
            'RentalPaymentPref' => '\\StructType\\RentalPaymentPref',
            'VehicleReservationRQCoreType' => '\\StructType\\VehicleReservationRQCoreType',
            'VehicleReservationSummaryType' => '\\StructType\\VehicleReservationSummaryType',
            'ConfID' => '\\StructType\\ConfID',
            'VehicleReservationType' => '\\StructType\\VehicleReservationType',
            'VehSegmentCore' => '\\StructType\\VehSegmentCore',
            'VehicleSegmentAdditionalInfoType' => '\\StructType\\VehicleSegmentAdditionalInfoType',
            'VendorMessages' => '\\StructType\\VendorMessages',
            'VehicleSegmentCoreType' => '\\StructType\\VehicleSegmentCoreType',
            'VehicleSpecialReqPrefType' => '\\StructType\\VehicleSpecialReqPrefType',
            'VehicleTourInfoType' => '\\StructType\\VehicleTourInfoType',
            'VehicleType' => '\\StructType\\VehicleType',
            'VehIdentity' => '\\StructType\\VehIdentity',
            'VehicleVendorAvailabilityType' => '\\StructType\\VehicleVendorAvailabilityType',
            'VehAvails' => '\\StructType\\VehAvails',
            'VehAvail' => '\\StructType\\VehAvail',
            'VehicleWhereAtFacilityType' => '\\StructType\\VehicleWhereAtFacilityType',
            'VehicleResRSAdditionalInfoType' => '\\StructType\\VehicleResRSAdditionalInfoType',
            'VehicleResRSCoreType' => '\\StructType\\VehicleResRSCoreType',
            'AccommodationCategoryBaseType' => '\\StructType\\AccommodationCategoryBaseType',
            'AccommodationCategoryType' => '\\StructType\\AccommodationCategoryType',
            'Accommodation' => '\\StructType\\Accommodation',
            'AccommodationClass' => '\\StructType\\AccommodationClass',
            'AccommodationServiceType' => '\\StructType\\AccommodationServiceType',
            'AccommodationDetail' => '\\StructType\\AccommodationDetail',
            'AccommodationType' => '\\StructType\\AccommodationType',
            'AncillaryService' => '\\StructType\\AncillaryService',
            'AncillaryServiceType' => '\\StructType\\AncillaryServiceType',
            'BerthDetailType' => '\\StructType\\BerthDetailType',
            'BookedTrainSegmentType' => '\\StructType\\BookedTrainSegmentType',
            'Assignment' => '\\StructType\\Assignment',
            'BusIdentificationType' => '\\StructType\\BusIdentificationType',
            'BusInfoType' => '\\StructType\\BusInfoType',
            'ValidDate' => '\\StructType\\ValidDate',
            'BusSegmentType' => '\\StructType\\BusSegmentType',
            'ClassCodeType' => '\\StructType\\ClassCodeType',
            'CodeAmountType' => '\\StructType\\CodeAmountType',
            'CompartmentType' => '\\StructType\\CompartmentType',
            'FareSummaryType_DEPRECATE' => '\\StructType\\FareSummaryType_DEPRECATE',
            'NetworkCodeType' => '\\StructType\\NetworkCodeType',
            'OriginDestinationSummaryType_DEPRECATE' => '\\StructType\\OriginDestinationSummaryType_DEPRECATE',
            'RailAccommDetailType' => '\\StructType\\RailAccommDetailType',
            'Compartment' => '\\StructType\\Compartment',
            'Car' => '\\StructType\\Car',
            'RailAmenityType' => '\\StructType\\RailAmenityType',
            'RailAmenity' => '\\StructType\\RailAmenity',
            'RailAvailPrefsType' => '\\StructType\\RailAvailPrefsType',
            'TransportModes' => '\\StructType\\TransportModes',
            'RailAvailQueryType' => '\\StructType\\RailAvailQueryType',
            'RailAvailScheduleQueryType' => '\\StructType\\RailAvailScheduleQueryType',
            'RailChargesType' => '\\StructType\\RailChargesType',
            'RailConnectionType' => '\\StructType\\RailConnectionType',
            'RailFareType' => '\\StructType\\RailFareType',
            'BasicFare' => '\\StructType\\BasicFare',
            'TermAndCondition' => '\\StructType\\TermAndCondition',
            'FareRule' => '\\StructType\\FareRule',
            'EffectiveDates' => '\\StructType\\EffectiveDates',
            'RailOriginDestinationInformationType' => '\\StructType\\RailOriginDestinationInformationType',
            'RailOriginDestinationSummaryType' => '\\StructType\\RailOriginDestinationSummaryType',
            'RailPassengerCategoryDetailType' => '\\StructType\\RailPassengerCategoryDetailType',
            'RailPassengerCategoryType' => '\\StructType\\RailPassengerCategoryType',
            'PassengerQualifyingInfo' => '\\StructType\\PassengerQualifyingInfo',
            'RailPassengerShopType_DEPRECATE' => '\\StructType\\RailPassengerShopType_DEPRECATE',
            'RailPassengerDetailType' => '\\StructType\\RailPassengerDetailType',
            'RailPassengerOccupationType' => '\\StructType\\RailPassengerOccupationType',
            'RailPersonInfoType' => '\\StructType\\RailPersonInfoType',
            'RailPriceBreakdownType' => '\\StructType\\RailPriceBreakdownType',
            'AccommodationAdjustment' => '\\StructType\\AccommodationAdjustment',
            'DiscountClass' => '\\StructType\\DiscountClass',
            'RailPriceType' => '\\StructType\\RailPriceType',
            'Price' => '\\StructType\\Price',
            'RailRateQualifyingType' => '\\StructType\\RailRateQualifyingType',
            'DiscountType' => '\\StructType\\DiscountType',
            'RailReservationSummaryType' => '\\StructType\\RailReservationSummaryType',
            'ODInfo' => '\\StructType\\ODInfo',
            'TrainSegment' => '\\StructType\\TrainSegment',
            'RailReservationType' => '\\StructType\\RailReservationType',
            'Itinerary' => '\\StructType\\Itinerary',
            'OriginAndDestination' => '\\StructType\\OriginAndDestination',
            'SeatDetailType' => '\\StructType\\SeatDetailType',
            'SeatIdentificationType' => '\\StructType\\SeatIdentificationType',
            'StationDetailsType' => '\\StructType\\StationDetailsType',
            'StationType' => '\\StructType\\StationType',
            'TrainIdentificationType' => '\\StructType\\TrainIdentificationType',
            'TrainInfoType' => '\\StructType\\TrainInfoType',
            'TrainQueryType' => '\\StructType\\TrainQueryType',
            'TrainSegmentSummaryType' => '\\StructType\\TrainSegmentSummaryType',
            'TrainSegmentType' => '\\StructType\\TrainSegmentType',
            'TravelPurposeType' => '\\StructType\\TravelPurposeType',
            'LocationPrefType' => '\\StructType\\LocationPrefType',
            'RailPrefType' => '\\StructType\\RailPrefType',
            'OperatorPref' => '\\StructType\\OperatorPref',
            'TrainPref' => '\\StructType\\TrainPref',
            'TransportModesPref' => '\\StructType\\TransportModesPref',
            'AmenityPref' => '\\StructType\\AmenityPref',
            'EquipmentPref' => '\\StructType\\EquipmentPref',
            'AccommodationPref' => '\\StructType\\AccommodationPref',
            'AncillaryServicePref' => '\\StructType\\AncillaryServicePref',
            'PassengerInfoPref' => '\\StructType\\PassengerInfoPref',
            'OSI_Pref' => '\\StructType\\OSI_Pref',
            'AccessesType' => '\\StructType\\AccessesType',
            'Access' => '\\StructType\\Access',
            'AffiliationsType' => '\\StructType\\AffiliationsType',
            'AgreementsType' => '\\StructType\\AgreementsType',
            'ProfileSecurity' => '\\StructType\\ProfileSecurity',
            'AllianceConsortiumType' => '\\StructType\\AllianceConsortiumType',
            'AllianceMember' => '\\StructType\\AllianceMember',
            'CertificationType' => '\\StructType\\CertificationType',
            'CommissionInfoType' => '\\StructType\\CommissionInfoType',
            'CompanyInfoType' => '\\StructType\\CompanyInfoType',
            'AddressInfo' => '\\StructType\\AddressInfo',
            'TripPurpose' => '\\StructType\\TripPurpose',
            'EmployerType' => '\\StructType\\EmployerType',
            'InsuranceType' => '\\StructType\\InsuranceType',
            'LoyaltyProgramType' => '\\StructType\\LoyaltyProgramType',
            'OrganizationType' => '\\StructType\\OrganizationType',
            'OrgMemberName' => '\\StructType\\OrgMemberName',
            'PreferencesType' => '\\StructType\\PreferencesType',
            'PrefCollection' => '\\StructType\\PrefCollection',
            'ProfileType' => '\\StructType\\ProfileType',
            'UserID' => '\\StructType\\UserID',
            'ProfilesType' => '\\StructType\\ProfilesType',
            'ProfileInfo' => '\\StructType\\ProfileInfo',
            'TravelArrangerType' => '\\StructType\\TravelArrangerType',
            'TravelClubType' => '\\StructType\\TravelClubType',
            'ClubMemberName' => '\\StructType\\ClubMemberName',
            'FolioIDsType' => '\\StructType\\FolioIDsType',
            'HotelResModifyRequestType' => '\\StructType\\HotelResModifyRequestType',
            'HotelResModifyResponseType' => '\\StructType\\HotelResModifyResponseType',
            'HotelResModifyType' => '\\StructType\\HotelResModifyType',
            'HotelResModify' => '\\StructType\\HotelResModify',
            'Verification' => '\\StructType\\Verification',
            'HotelReservationType' => '\\StructType\\HotelReservationType',
            'BillingInstructionCode' => '\\StructType\\BillingInstructionCode',
            'ResGuestRPH' => '\\StructType\\ResGuestRPH',
            'ResGlobalInfo' => '\\StructType\\ResGlobalInfo',
            'HotelReservationsType' => '\\StructType\\HotelReservationsType',
            'HotelReservation' => '\\StructType\\HotelReservation',
            'RebatePrograms' => '\\StructType\\RebatePrograms',
            'HotelResRequestType' => '\\StructType\\HotelResRequestType',
            'HotelResResponseType' => '\\StructType\\HotelResResponseType',
            'LoyaltyPointsAccrualsType' => '\\StructType\\LoyaltyPointsAccrualsType',
            'SelectedLoyalty' => '\\StructType\\SelectedLoyalty',
            'ResCommonDetailType' => '\\StructType\\ResCommonDetailType',
            'TimeSpan' => '\\StructType\\TimeSpan',
            'ResGlobalInfoType' => '\\StructType\\ResGlobalInfoType',
            'ResGuestRPHsType' => '\\StructType\\ResGuestRPHsType',
            'ResGuestType' => '\\StructType\\ResGuestType',
            'ProfileRPHs' => '\\StructType\\ProfileRPHs',
            'ProfileRPH' => '\\StructType\\ProfileRPH',
            'ResGuestsType' => '\\StructType\\ResGuestsType',
            'RevenueCategoriesType' => '\\StructType\\RevenueCategoriesType',
            'RevenueCategoryType' => '\\StructType\\RevenueCategoryType',
            'SummaryAmount' => '\\StructType\\SummaryAmount',
            'RevenueDetailsType' => '\\StructType\\RevenueDetailsType',
            'RevenueDetailType' => '\\StructType\\RevenueDetailType',
            'RoomStaysType' => '\\StructType\\RoomStaysType',
            'RoomStay' => '\\StructType\\RoomStay',
            'ServiceRPHsType' => '\\StructType\\ServiceRPHsType',
            'ServiceRPH' => '\\StructType\\ServiceRPH',
            'ServicesType' => '\\StructType\\ServicesType',
            'ServiceCategory' => '\\StructType\\ServiceCategory',
            'ServiceType' => '\\StructType\\ServiceType',
            'ServiceDetails' => '\\StructType\\ServiceDetails',
            'StayInfosType' => '\\StructType\\StayInfosType',
            'StayInfoType' => '\\StructType\\StayInfoType',
            'TransportInfoType' => '\\StructType\\TransportInfoType',
            'TransportInfo' => '\\StructType\\TransportInfo',
            'AdditionalDetailsType' => '\\StructType\\AdditionalDetailsType',
            'AdditionalDetailType' => '\\StructType\\AdditionalDetailType',
            'AdditionalGuestAmountType' => '\\StructType\\AdditionalGuestAmountType',
            'AddressesType' => '\\StructType\\AddressesType',
            'AdjustmentsType' => '\\StructType\\AdjustmentsType',
            'Adjustment' => '\\StructType\\Adjustment',
            'AmountLiteType' => '\\StructType\\AmountLiteType',
            'AmountPercentType' => '\\StructType\\AmountPercentType',
            'AmountType' => '\\StructType\\AmountType',
            'AdditionalGuestAmounts' => '\\StructType\\AdditionalGuestAmounts',
            'AreasType' => '\\StructType\\AreasType',
            'Area' => '\\StructType\\Area',
            'AvailStatusMessageType' => '\\StructType\\AvailStatusMessageType',
            'BestAvailableRates' => '\\StructType\\BestAvailableRates',
            'BestAvailableRate' => '\\StructType\\BestAvailableRate',
            'HurdleRate' => '\\StructType\\HurdleRate',
            'Delta' => '\\StructType\\Delta',
            'RestrictionStatus' => '\\StructType\\RestrictionStatus',
            'BaseInvCountType' => '\\StructType\\BaseInvCountType',
            'InvCounts' => '\\StructType\\InvCounts',
            'InvCount' => '\\StructType\\InvCount',
            'InvBlockCutoff' => '\\StructType\\InvBlockCutoff',
            'OffSell' => '\\StructType\\OffSell',
            'BasicPropertyInfoType' => '\\StructType\\BasicPropertyInfoType',
            'ContactNumbers' => '\\StructType\\ContactNumbers',
            'ContactNumber' => '\\StructType\\ContactNumber',
            'Award' => '\\StructType\\Award',
            'HotelAmenity' => '\\StructType\\HotelAmenity',
            'HotelFeature' => '\\StructType\\HotelFeature',
            'Recreation' => '\\StructType\\Recreation',
            'Policy' => '\\StructType\\Policy',
            'HotelMeetingFacility' => '\\StructType\\HotelMeetingFacility',
            'BillingInstructionType' => '\\StructType\\BillingInstructionType',
            'BookingRulesType' => '\\StructType\\BookingRulesType',
            'BookingRule' => '\\StructType\\BookingRule',
            'AcceptableGuarantees' => '\\StructType\\AcceptableGuarantees',
            'AcceptableGuarantee' => '\\StructType\\AcceptableGuarantee',
            'AddtionalRules' => '\\StructType\\AddtionalRules',
            'AdditionalRule' => '\\StructType\\AdditionalRule',
            'CheckoutCharge' => '\\StructType\\CheckoutCharge',
            'CancelPenaltiesType' => '\\StructType\\CancelPenaltiesType',
            'CancelPenaltyType' => '\\StructType\\CancelPenaltyType',
            'DestinationSystemCodesType' => '\\StructType\\DestinationSystemCodesType',
            'DestinationSystemCode' => '\\StructType\\DestinationSystemCode',
            'DOW_RestrictionsType' => '\\StructType\\DOW_RestrictionsType',
            'AvailableDaysOfWeek' => '\\StructType\\AvailableDaysOfWeek',
            'ArrivalDaysOfWeek' => '\\StructType\\ArrivalDaysOfWeek',
            'DepartureDaysOfWeek' => '\\StructType\\DepartureDaysOfWeek',
            'RequiredDaysOfWeek' => '\\StructType\\RequiredDaysOfWeek',
            'DOW_RulesType' => '\\StructType\\DOW_RulesType',
            'EnvironmentalImpactType' => '\\StructType\\EnvironmentalImpactType',
            'CarbonFootprint' => '\\StructType\\CarbonFootprint',
            'Water' => '\\StructType\\Water',
            'Energy' => '\\StructType\\Energy',
            'Usage' => '\\StructType\\Usage',
            'Recycling' => '\\StructType\\Recycling',
            'Details' => '\\StructType\\Details',
            'General' => '\\StructType\\General',
            'FeaturesType' => '\\StructType\\FeaturesType',
            'Feature' => '\\StructType\\Feature',
            'Charge' => '\\StructType\\Charge',
            'GDS_InfoType' => '\\StructType\\GDS_InfoType',
            'GDS_Codes' => '\\StructType\\GDS_Codes',
            'GDS_Code' => '\\StructType\\GDS_Code',
            'GDS_CodeDetails' => '\\StructType\\GDS_CodeDetails',
            'GDS_CodeDetail' => '\\StructType\\GDS_CodeDetail',
            'GDS_Statuses' => '\\StructType\\GDS_Statuses',
            'GDS_Status' => '\\StructType\\GDS_Status',
            'GuaranteeType' => '\\StructType\\GuaranteeType',
            'GuaranteesAccepted' => '\\StructType\\GuaranteesAccepted',
            'GuaranteeAccepted' => '\\StructType\\GuaranteeAccepted',
            'GuestCountType' => '\\StructType\\GuestCountType',
            'GuestCount' => '\\StructType\\GuestCount',
            'GuestRoomType' => '\\StructType\\GuestRoomType',
            'Quantities' => '\\StructType\\Quantities',
            'Occupancy' => '\\StructType\\Occupancy',
            'Room' => '\\StructType\\Room',
            'Amenities' => '\\StructType\\Amenities',
            'RoomLevelFees' => '\\StructType\\RoomLevelFees',
            'HotelAdditionalChargesType' => '\\StructType\\HotelAdditionalChargesType',
            'AdditionalCharge' => '\\StructType\\AdditionalCharge',
            'HotelPaymentFormType' => '\\StructType\\HotelPaymentFormType',
            'MasterAccountUsage' => '\\StructType\\MasterAccountUsage',
            'HotelReservationIDsType' => '\\StructType\\HotelReservationIDsType',
            'HotelReservationID' => '\\StructType\\HotelReservationID',
            'HotelRoomListType' => '\\StructType\\HotelRoomListType',
            'Guests' => '\\StructType\\Guests',
            'Guest' => '\\StructType\\Guest',
            'Loyalty' => '\\StructType\\Loyalty',
            'GuaranteePayment' => '\\StructType\\GuaranteePayment',
            'MasterContact' => '\\StructType\\MasterContact',
            'UniqueIDs' => '\\StructType\\UniqueIDs',
            'MasterAccount' => '\\StructType\\MasterAccount',
            'RoomStays' => '\\StructType\\RoomStays',
            'Event' => '\\StructType\\Event',
            'HotelSearchCriteriaType' => '\\StructType\\HotelSearchCriteriaType',
            'Criterion' => '\\StructType\\Criterion',
            'HotelSearchCriterionType' => '\\StructType\\HotelSearchCriterionType',
            'RatePlanCandidates' => '\\StructType\\RatePlanCandidates',
            'RoomStayCandidates' => '\\StructType\\RoomStayCandidates',
            'Media' => '\\StructType\\Media',
            'MealPlan' => '\\StructType\\MealPlan',
            'UserGeneratedContent' => '\\StructType\\UserGeneratedContent',
            'InvBlockRoomType' => '\\StructType\\InvBlockRoomType',
            'RoomTypeAllocations' => '\\StructType\\RoomTypeAllocations',
            'RoomTypeAllocation' => '\\StructType\\RoomTypeAllocation',
            'RoomTypeAllocByGuest' => '\\StructType\\RoomTypeAllocByGuest',
            'RatePlans' => '\\StructType\\RatePlans',
            'RatePlan' => '\\StructType\\RatePlan',
            'MarketCode' => '\\StructType\\MarketCode',
            'MethodInfo' => '\\StructType\\MethodInfo',
            'DaysOfWeeks' => '\\StructType\\DaysOfWeeks',
            'InvBlockType' => '\\StructType\\InvBlockType',
            'InvBlockDates' => '\\StructType\\InvBlockDates',
            'RoomTypes' => '\\StructType\\RoomTypes',
            'BlockDescriptions' => '\\StructType\\BlockDescriptions',
            'BlockDescription' => '\\StructType\\BlockDescription',
            'Contacts' => '\\StructType\\Contacts',
            'TaxInformation' => '\\StructType\\TaxInformation',
            'InvCountType' => '\\StructType\\InvCountType',
            'LengthsOfStayType' => '\\StructType\\LengthsOfStayType',
            'LengthOfStay' => '\\StructType\\LengthOfStay',
            'LOS_Pattern' => '\\StructType\\LOS_Pattern',
            'MeetingRoomCapacityType' => '\\StructType\\MeetingRoomCapacityType',
            'MeetingRoomCodeType' => '\\StructType\\MeetingRoomCodeType',
            'MeetingRoomsType' => '\\StructType\\MeetingRoomsType',
            'MeetingRoom' => '\\StructType\\MeetingRoom',
            'Codes' => '\\StructType\\Codes',
            'Dimension' => '\\StructType\\Dimension',
            'AvailableCapacities' => '\\StructType\\AvailableCapacities',
            'MembershipType' => '\\StructType\\MembershipType',
            'Membership' => '\\StructType\\Membership',
            'MessageType' => '\\StructType\\MessageType',
            'OriginalPayloadStdAttributes' => '\\StructType\\OriginalPayloadStdAttributes',
            'ProductDescriptionsType' => '\\StructType\\ProductDescriptionsType',
            'ProductDescription' => '\\StructType\\ProductDescription',
            'PropertyValueMatchType' => '\\StructType\\PropertyValueMatchType',
            'SearchValueMatch' => '\\StructType\\SearchValueMatch',
            'RateAmountMessageType' => '\\StructType\\RateAmountMessageType',
            'Rates' => '\\StructType\\Rates',
            'RateLiteType' => '\\StructType\\RateLiteType',
            'RatePlanCandidatesType' => '\\StructType\\RatePlanCandidatesType',
            'RatePlanCandidate' => '\\StructType\\RatePlanCandidate',
            'HotelRefs' => '\\StructType\\HotelRefs',
            'MealsIncluded' => '\\StructType\\MealsIncluded',
            'ArrivalPolicy' => '\\StructType\\ArrivalPolicy',
            'RatePlanCommission' => '\\StructType\\RatePlanCommission',
            'RatePlanInclusionsType' => '\\StructType\\RatePlanInclusionsType',
            'RatePlanLiteType' => '\\StructType\\RatePlanLiteType',
            'RatePlanType' => '\\StructType\\RatePlanType',
            'Guarantee' => '\\StructType\\Guarantee',
            'AmountPercent' => '\\StructType\\AmountPercent',
            'RateType' => '\\StructType\\RateType',
            'RateUploadType' => '\\StructType\\RateUploadType',
            'BaseByGuestAmts' => '\\StructType\\BaseByGuestAmts',
            'BaseByGuestAmt' => '\\StructType\\BaseByGuestAmt',
            'AdditionalGuestAmount' => '\\StructType\\AdditionalGuestAmount',
            'GuaranteePolicies' => '\\StructType\\GuaranteePolicies',
            'RequiredPaymentLiteType' => '\\StructType\\RequiredPaymentLiteType',
            'RequiredPaymentsType' => '\\StructType\\RequiredPaymentsType',
            'RFP_ResponseDetailType' => '\\StructType\\RFP_ResponseDetailType',
            'RoomRateLiteType' => '\\StructType\\RoomRateLiteType',
            'RoomRateType' => '\\StructType\\RoomRateType',
            'Features' => '\\StructType\\Features',
            'Availability' => '\\StructType\\Availability',
            'RoomSharesType' => '\\StructType\\RoomSharesType',
            'RoomShare' => '\\StructType\\RoomShare',
            'GuestRPHs' => '\\StructType\\GuestRPHs',
            'GuestRPH' => '\\StructType\\GuestRPH',
            'RoomStayCandidateType' => '\\StructType\\RoomStayCandidateType',
            'RoomStayLiteType' => '\\StructType\\RoomStayLiteType',
            'RoomRates' => '\\StructType\\RoomRates',
            'BasicPropertyInfo' => '\\StructType\\BasicPropertyInfo',
            'RoomStayType' => '\\StructType\\RoomStayType',
            'RoomRate' => '\\StructType\\RoomRate',
            'AdvanceBookingRestriction' => '\\StructType\\AdvanceBookingRestriction',
            'GuestCounts' => '\\StructType\\GuestCounts',
            'MapURL' => '\\StructType\\MapURL',
            'RoomTypeLiteType' => '\\StructType\\RoomTypeLiteType',
            'RoomTypeType' => '\\StructType\\RoomTypeType',
            'RoutingHopType' => '\\StructType\\RoutingHopType',
            'RoutingHop' => '\\StructType\\RoutingHop',
            'SellableProductsType' => '\\StructType\\SellableProductsType',
            'SellableProduct' => '\\StructType\\SellableProduct',
            'DestinationSystemCodes' => '\\StructType\\DestinationSystemCodes',
            'InventoryBlock' => '\\StructType\\InventoryBlock',
            'StatisticApplicationSetType' => '\\StructType\\StatisticApplicationSetType',
            'StatisticCodes' => '\\StructType\\StatisticCodes',
            'StatisticCode' => '\\StructType\\StatisticCode',
            'RevenueCategorySummaries' => '\\StructType\\RevenueCategorySummaries',
            'RevenueCategorySummary' => '\\StructType\\RevenueCategorySummary',
            'CountCategorySummaries' => '\\StructType\\CountCategorySummaries',
            'CountCategorySummary' => '\\StructType\\CountCategorySummary',
            'ReportSummaries' => '\\StructType\\ReportSummaries',
            'StatisticsType' => '\\StructType\\StatisticsType',
            'StatisticType' => '\\StructType\\StatisticType',
            'StatisticApplicationSets' => '\\StructType\\StatisticApplicationSets',
            'StatusApplicationControlType' => '\\StructType\\StatusApplicationControlType',
            'ViewershipsType' => '\\StructType\\ViewershipsType',
            'Viewership' => '\\StructType\\Viewership',
            'ViewershipCodes' => '\\StructType\\ViewershipCodes',
            'SystemCodes' => '\\StructType\\SystemCodes',
            'SystemCode' => '\\StructType\\SystemCode',
            'ProfileTypes' => '\\StructType\\ProfileTypes',
            'ProfileRefs' => '\\StructType\\ProfileRefs',
            'Profiles' => '\\StructType\\Profiles',
            'LocationCodes' => '\\StructType\\LocationCodes',
            'LocationCode' => '\\StructType\\LocationCode',
            'BookingChannelCodes' => '\\StructType\\BookingChannelCodes',
            'BookingChannelCode' => '\\StructType\\BookingChannelCode',
            'DistributorTypes' => '\\StructType\\DistributorTypes',
            'DistributorType' => '\\StructType\\DistributorType',
            'WeatherInfoType' => '\\StructType\\WeatherInfoType',
            'Precipitation' => '\\StructType\\Precipitation',
            'Temperature' => '\\StructType\\Temperature',
            'HotelRatePlanType' => '\\StructType\\HotelRatePlanType',
            'DestinationSystemsCode' => '\\StructType\\DestinationSystemsCode',
            'BookingRules' => '\\StructType\\BookingRules',
            'InventoryInfo' => '\\StructType\\InventoryInfo',
            'Supplements' => '\\StructType\\Supplements',
            'Supplement' => '\\StructType\\Supplement',
            'RoomCompanions' => '\\StructType\\RoomCompanions',
            'PrerequisiteInventory' => '\\StructType\\PrerequisiteInventory',
            'Offers' => '\\StructType\\Offers',
            'RatePlanShoulders' => '\\StructType\\RatePlanShoulders',
            'RatePlanShoulder' => '\\StructType\\RatePlanShoulder',
            'RatePlanLevelFee' => '\\StructType\\RatePlanLevelFee',
            'OfferType' => '\\StructType\\OfferType',
            'OfferRules' => '\\StructType\\OfferRules',
            'OfferRule' => '\\StructType\\OfferRule',
            'DateRestriction' => '\\StructType\\DateRestriction',
            'Inventories' => '\\StructType\\Inventories',
            'Inventory' => '\\StructType\\Inventory',
            'FreeUpgrade' => '\\StructType\\FreeUpgrade',
            'UpgradeFrom' => '\\StructType\\UpgradeFrom',
            'UpgradeTo' => '\\StructType\\UpgradeTo',
            'CompatibleOffers' => '\\StructType\\CompatibleOffers',
            'CompatibleOffer' => '\\StructType\\CompatibleOffer',
            'OTA_HotelRatePlanRQ' => '\\StructType\\OTA_HotelRatePlanRQ',
            'DateRange' => '\\StructType\\DateRange',
            'OTA_HotelRatePlanRS' => '\\StructType\\OTA_HotelRatePlanRS',
            'OTA_HotelAvailNotifRQ' => '\\StructType\\OTA_HotelAvailNotifRQ',
            'AvailStatusMessages' => '\\StructType\\AvailStatusMessages',
            'OTA_HotelRateAmountNotifRQ' => '\\StructType\\OTA_HotelRateAmountNotifRQ',
            'RateAmountMessages' => '\\StructType\\RateAmountMessages',
            'AirInfoType' => '\\StructType\\AirInfoType',
            'AmenityOptionType' => '\\StructType\\AmenityOptionType',
            'CabinOptionType' => '\\StructType\\CabinOptionType',
            'CabinConfiguration' => '\\StructType\\CabinConfiguration',
            'MeasurementInfo' => '\\StructType\\MeasurementInfo',
            'CategoryOptionType' => '\\StructType\\CategoryOptionType',
            'PriceInfos' => '\\StructType\\PriceInfos',
            'PriceInfo' => '\\StructType\\PriceInfo',
            'Dining' => '\\StructType\\Dining',
            'CruiseBookingInfoType' => '\\StructType\\CruiseBookingInfoType',
            'BookingPrices' => '\\StructType\\BookingPrices',
            'BookingPrice' => '\\StructType\\BookingPrice',
            'PaymentSchedule' => '\\StructType\\PaymentSchedule',
            'Payment' => '\\StructType\\Payment',
            'GuestPrices' => '\\StructType\\GuestPrices',
            'GuestPrice' => '\\StructType\\GuestPrice',
            'CruiseGuestDetailType' => '\\StructType\\CruiseGuestDetailType',
            'SelectedFareCode' => '\\StructType\\SelectedFareCode',
            'LoyaltyInfo' => '\\StructType\\LoyaltyInfo',
            'LinkedTraveler' => '\\StructType\\LinkedTraveler',
            'SelectedDining' => '\\StructType\\SelectedDining',
            'SelectedInsurance' => '\\StructType\\SelectedInsurance',
            'SelectedPackages' => '\\StructType\\SelectedPackages',
            'SelectedPackage' => '\\StructType\\SelectedPackage',
            'SelectedSpecialServices' => '\\StructType\\SelectedSpecialServices',
            'AirAccommodations' => '\\StructType\\AirAccommodations',
            'AirAccommodation' => '\\StructType\\AirAccommodation',
            'CruiseGuestInfoType' => '\\StructType\\CruiseGuestInfoType',
            'GuestDetails' => '\\StructType\\GuestDetails',
            'LinkedBookings' => '\\StructType\\LinkedBookings',
            'LinkedBooking' => '\\StructType\\LinkedBooking',
            'PaymentOptions' => '\\StructType\\PaymentOptions',
            'PaymentOption' => '\\StructType\\PaymentOption',
            'CancellationPenalty' => '\\StructType\\CancellationPenalty',
            'CruisePackageType' => '\\StructType\\CruisePackageType',
            'CruiseProfileType' => '\\StructType\\CruiseProfileType',
            'CruiseProfile' => '\\StructType\\CruiseProfile',
            'CruiseReservationType' => '\\StructType\\CruiseReservationType',
            'PaymentsDue' => '\\StructType\\PaymentsDue',
            'PaymentDue' => '\\StructType\\PaymentDue',
            'DocumentHandlingType' => '\\StructType\\DocumentHandlingType',
            'VendorOption' => '\\StructType\\VendorOption',
            'FareCodeOptionType' => '\\StructType\\FareCodeOptionType',
            'FareRemark' => '\\StructType\\FareRemark',
            'GuestTransportationType' => '\\StructType\\GuestTransportationType',
            'GuestType' => '\\StructType\\GuestType',
            'PaymentResponseType' => '\\StructType\\PaymentResponseType',
            'PriceInfoType' => '\\StructType\\PriceInfoType',
            'ReservationID_Type' => '\\StructType\\ReservationID_Type',
            'SailingBaseType' => '\\StructType\\SailingBaseType',
            'CruiseLine' => '\\StructType\\CruiseLine',
            'Region' => '\\StructType\\Region',
            'DeparturePort' => '\\StructType\\DeparturePort',
            'ArrivalPort' => '\\StructType\\ArrivalPort',
            'SailingCategoryInfoType' => '\\StructType\\SailingCategoryInfoType',
            'SelectedCategory' => '\\StructType\\SelectedCategory',
            'CabinAttributes' => '\\StructType\\CabinAttributes',
            'CabinAttribute' => '\\StructType\\CabinAttribute',
            'SelectedCabin' => '\\StructType\\SelectedCabin',
            'SailingInfoType' => '\\StructType\\SailingInfoType',
            'SelectedSailing' => '\\StructType\\SelectedSailing',
            'InclusivePackageOption' => '\\StructType\\InclusivePackageOption',
            'SailingSearchQualifierType' => '\\StructType\\SailingSearchQualifierType',
            'Port' => '\\StructType\\Port',
            'SailingType' => '\\StructType\\SailingType',
            'SearchQualifierType' => '\\StructType\\SearchQualifierType',
            'Residency' => '\\StructType\\Residency',
            'PriceRange' => '\\StructType\\PriceRange',
            'Status' => '\\StructType\\Status',
            'ShipInfoType' => '\\StructType\\ShipInfoType',
            'Ship' => '\\StructType\\Ship',
            'ShipLength' => '\\StructType\\ShipLength',
            'ShipVoltage' => '\\StructType\\ShipVoltage',
            'SpecialServiceType' => '\\StructType\\SpecialServiceType',
            'AccommodationDetailType' => '\\StructType\\AccommodationDetailType',
            'AccommodationInfoType' => '\\StructType\\AccommodationInfoType',
            'Resort' => '\\StructType\\Resort',
            'AccommodationSegmentRequestType' => '\\StructType\\AccommodationSegmentRequestType',
            'RoomProfiles' => '\\StructType\\RoomProfiles',
            'MealPlans' => '\\StructType\\MealPlans',
            'CabinAvailType' => '\\StructType\\CabinAvailType',
            'ChargesType' => '\\StructType\\ChargesType',
            'CostingItemType' => '\\StructType\\CostingItemType',
            'UnitCost' => '\\StructType\\UnitCost',
            'ExtendedCost' => '\\StructType\\ExtendedCost',
            'CustomerCountsType' => '\\StructType\\CustomerCountsType',
            'CustomerCount' => '\\StructType\\CustomerCount',
            'ExtrasCoreType' => '\\StructType\\ExtrasCoreType',
            'SubCategory' => '\\StructType\\SubCategory',
            'ExtrasInfoType' => '\\StructType\\ExtrasInfoType',
            'Criteria' => '\\StructType\\Criteria',
            'Periods' => '\\StructType\\Periods',
            'AdditionalInfoPrompt' => '\\StructType\\AdditionalInfoPrompt',
            'ParentExtras' => '\\StructType\\ParentExtras',
            'ExtraLocationInfo' => '\\StructType\\ExtraLocationInfo',
            'ExtrasType' => '\\StructType\\ExtrasType',
            'FacilityChoicesType' => '\\StructType\\FacilityChoicesType',
            'AvailableRooms' => '\\StructType\\AvailableRooms',
            'AvailableMealPlans' => '\\StructType\\AvailableMealPlans',
            'RoomPrices' => '\\StructType\\RoomPrices',
            'ItineraryItemRequestType' => '\\StructType\\ItineraryItemRequestType',
            'RentalCar' => '\\StructType\\RentalCar',
            'ItineraryItemResponseType' => '\\StructType\\ItineraryItemResponseType',
            'RoomProfile' => '\\StructType\\RoomProfile',
            'Prices' => '\\StructType\\Prices',
            'MealPlanType' => '\\StructType\\MealPlanType',
            'PassengerRPHs' => '\\StructType\\PassengerRPHs',
            'OwnInsuranceChoiceType' => '\\StructType\\OwnInsuranceChoiceType',
            'PackageResponseType' => '\\StructType\\PackageResponseType',
            'ItineraryItems' => '\\StructType\\ItineraryItems',
            'Extras' => '\\StructType\\Extras',
            'Cautions' => '\\StructType\\Cautions',
            'PackageType' => '\\StructType\\PackageType',
            'PeriodPriceType' => '\\StructType\\PeriodPriceType',
            'PersonalInsuranceItemType' => '\\StructType\\PersonalInsuranceItemType',
            'PkgAirSegmentType' => '\\StructType\\PkgAirSegmentType',
            'AvailableSeats' => '\\StructType\\AvailableSeats',
            'Passengers' => '\\StructType\\Passengers',
            'PkgCautionType' => '\\StructType\\PkgCautionType',
            'PkgFlightSegmentBaseType' => '\\StructType\\PkgFlightSegmentBaseType',
            'PkgFlightSegmentType' => '\\StructType\\PkgFlightSegmentType',
            'PkgInvoiceDetail' => '\\StructType\\PkgInvoiceDetail',
            'CostingItems' => '\\StructType\\CostingItems',
            'GrossAmount' => '\\StructType\\GrossAmount',
            'DepositAmount' => '\\StructType\\DepositAmount',
            'AgentCommission' => '\\StructType\\AgentCommission',
            'NetAmount' => '\\StructType\\NetAmount',
            'BalanceDueAmount' => '\\StructType\\BalanceDueAmount',
            'AmountReceived' => '\\StructType\\AmountReceived',
            'PkgPassengerListItem' => '\\StructType\\PkgPassengerListItem',
            'SpecialNeed' => '\\StructType\\SpecialNeed',
            'PkgPassengerRPHs' => '\\StructType\\PkgPassengerRPHs',
            'PassengerRPH' => '\\StructType\\PassengerRPH',
            'PkgPriceType' => '\\StructType\\PkgPriceType',
            'PkgRoomInventoryType' => '\\StructType\\PkgRoomInventoryType',
            'PkgTravelSegment' => '\\StructType\\PkgTravelSegment',
            'PropertyIdentityType' => '\\StructType\\PropertyIdentityType',
            'RoomPriceType' => '\\StructType\\RoomPriceType',
            'ProfilePrice' => '\\StructType\\ProfilePrice',
            'RoomProfileType' => '\\StructType\\RoomProfileType',
            'SeatAvailabilityType' => '\\StructType\\SeatAvailabilityType',
            'ServiceRequestType' => '\\StructType\\ServiceRequestType',
            'SourceIdentificationType' => '\\StructType\\SourceIdentificationType',
            'SupplementChargesType' => '\\StructType\\SupplementChargesType',
            'TaxItemType' => '\\StructType\\TaxItemType',
            'OTA_VehRetResRQ' => '\\StructType\\OTA_VehRetResRQ',
            'VehRetResRQCore' => '\\StructType\\VehRetResRQCore',
            'VehRetResRQInfo' => '\\StructType\\VehRetResRQInfo',
            'VehicleRetrieveResRQAdditionalInfoType' => '\\StructType\\VehicleRetrieveResRQAdditionalInfoType',
            'SearchDateRange' => '\\StructType\\SearchDateRange',
            'VehicleRetrieveResRQCoreType' => '\\StructType\\VehicleRetrieveResRQCoreType',
            'OTA_ReadRQ' => '\\StructType\\OTA_ReadRQ',
            'ReadRequests' => '\\StructType\\ReadRequests',
            'ReadRequest' => '\\StructType\\ReadRequest',
            'GlobalReservationReadRequest' => '\\StructType\\GlobalReservationReadRequest',
            'AirReadRequest' => '\\StructType\\AirReadRequest',
            'QueueInfo' => '\\StructType\\QueueInfo',
            'CruiseReadRequest' => '\\StructType\\CruiseReadRequest',
            'GolfReadRequest' => '\\StructType\\GolfReadRequest',
            'HotelReadRequest' => '\\StructType\\HotelReadRequest',
            'SelectionCriteria' => '\\StructType\\SelectionCriteria',
            'PkgReadRequest' => '\\StructType\\PkgReadRequest',
            'ProfileReadRequest' => '\\StructType\\ProfileReadRequest',
            'UniqueID' => '\\StructType\\UniqueID',
            'RailReadRequest' => '\\StructType\\RailReadRequest',
            'BookingDateTime' => '\\StructType\\BookingDateTime',
            'DepartureDateTime' => '\\StructType\\DepartureDateTime',
            'VehicleReadRequest' => '\\StructType\\VehicleReadRequest',
            'OTA_ResRetrieveRS' => '\\StructType\\OTA_ResRetrieveRS',
            'ReservationsList' => '\\StructType\\ReservationsList',
            'AirReservation' => '\\StructType\\AirReservation',
            'PackageReservation' => '\\StructType\\PackageReservation',
            'GolfReservation' => '\\StructType\\GolfReservation',
            'VehicleReservation' => '\\StructType\\VehicleReservation',
            'GlobalReservation' => '\\StructType\\GlobalReservation',
            'AffiliationInfoType' => '\\StructType\\AffiliationInfoType',
            'DistribSystems' => '\\StructType\\DistribSystems',
            'DistribSystem' => '\\StructType\\DistribSystem',
            'Brands' => '\\StructType\\Brands',
            'Brand' => '\\StructType\\Brand',
            'LoyalPrograms' => '\\StructType\\LoyalPrograms',
            'LoyalProgram' => '\\StructType\\LoyalProgram',
            'ProgramDescription' => '\\StructType\\ProgramDescription',
            'ProgramRestriction' => '\\StructType\\ProgramRestriction',
            'Awards' => '\\StructType\\Awards',
            'PartnerInfos' => '\\StructType\\PartnerInfos',
            'PartnerInfo' => '\\StructType\\PartnerInfo',
            'Descriptions' => '\\StructType\\Descriptions',
            'AreaInfoType' => '\\StructType\\AreaInfoType',
            'RefPoints' => '\\StructType\\RefPoints',
            'Attractions' => '\\StructType\\Attractions',
            'Attraction' => '\\StructType\\Attraction',
            'Contact' => '\\StructType\\Contact',
            'Recreations' => '\\StructType\\Recreations',
            'RecreationDetails' => '\\StructType\\RecreationDetails',
            'RecreationDetail' => '\\StructType\\RecreationDetail',
            'OtherHotels' => '\\StructType\\OtherHotels',
            'OtherHotel' => '\\StructType\\OtherHotel',
            'CategoryCodesType' => '\\StructType\\CategoryCodesType',
            'LocationCategory' => '\\StructType\\LocationCategory',
            'SegmentCategory' => '\\StructType\\SegmentCategory',
            'HotelCategory' => '\\StructType\\HotelCategory',
            'ArchitecturalStyle' => '\\StructType\\ArchitecturalStyle',
            'GuestRoomInfo' => '\\StructType\\GuestRoomInfo',
            'RateRanges' => '\\StructType\\RateRanges',
            'ContactInfoRootType' => '\\StructType\\ContactInfoRootType',
            'ContactInfoType' => '\\StructType\\ContactInfoType',
            'ContactInfosType' => '\\StructType\\ContactInfosType',
            'ContactsType' => '\\StructType\\ContactsType',
            'JobTitle' => '\\StructType\\JobTitle',
            'DescriptionType' => '\\StructType\\DescriptionType',
            'EmailsType' => '\\StructType\\EmailsType',
            'FacilityInfoType' => '\\StructType\\FacilityInfoType',
            'MeetingRooms' => '\\StructType\\MeetingRooms',
            'GuestRooms' => '\\StructType\\GuestRooms',
            'GuestRoom' => '\\StructType\\GuestRoom',
            'TypeRoom' => '\\StructType\\TypeRoom',
            'HotelDescriptiveContentType' => '\\StructType\\HotelDescriptiveContentType',
            'Policies' => '\\StructType\\Policies',
            'EffectivePeriods' => '\\StructType\\EffectivePeriods',
            'EffectivePeriod' => '\\StructType\\EffectivePeriod',
            'Promotions' => '\\StructType\\Promotions',
            'Promotion' => '\\StructType\\Promotion',
            'RoomBlocks' => '\\StructType\\RoomBlocks',
            'HotelInfoType' => '\\StructType\\HotelInfoType',
            'HotelName' => '\\StructType\\HotelName',
            'ClosedSeasons' => '\\StructType\\ClosedSeasons',
            'BlackoutDates' => '\\StructType\\BlackoutDates',
            'BlackoutDate' => '\\StructType\\BlackoutDate',
            'RelativePositions' => '\\StructType\\RelativePositions',
            'Renovation' => '\\StructType\\Renovation',
            'HotelInfoCodes' => '\\StructType\\HotelInfoCodes',
            'HotelInfoCode' => '\\StructType\\HotelInfoCode',
            'Services' => '\\StructType\\Services',
            'WeatherInfos' => '\\StructType\\WeatherInfos',
            'OwnershipManagementInfos' => '\\StructType\\OwnershipManagementInfos',
            'OwnershipManagementInfo' => '\\StructType\\OwnershipManagementInfo',
            'Languages' => '\\StructType\\Languages',
            'Language' => '\\StructType\\Language',
            'PhonesType' => '\\StructType\\PhonesType',
            'PoliciesType' => '\\StructType\\PoliciesType',
            'GuaranteePaymentPolicy' => '\\StructType\\GuaranteePaymentPolicy',
            'PolicyInfoCodes' => '\\StructType\\PolicyInfoCodes',
            'PolicyInfoCode' => '\\StructType\\PolicyInfoCode',
            'CheckoutCharges' => '\\StructType\\CheckoutCharges',
            'PolicyInfo' => '\\StructType\\PolicyInfo',
            'TaxPolicies' => '\\StructType\\TaxPolicies',
            'TaxPolicy' => '\\StructType\\TaxPolicy',
            'PetsPolicies' => '\\StructType\\PetsPolicies',
            'PetsPolicy' => '\\StructType\\PetsPolicy',
            'StayRequirements' => '\\StructType\\StayRequirements',
            'StayRequirement' => '\\StructType\\StayRequirement',
            'CommissionPolicy' => '\\StructType\\CommissionPolicy',
            'PaymentCompany' => '\\StructType\\PaymentCompany',
            'FeePolicies' => '\\StructType\\FeePolicies',
            'RatePolicies' => '\\StructType\\RatePolicies',
            'RatePolicy' => '\\StructType\\RatePolicy',
            'GroupPolicies' => '\\StructType\\GroupPolicies',
            'GroupPolicy' => '\\StructType\\GroupPolicy',
            'RefPointsType' => '\\StructType\\RefPointsType',
            'RestaurantsType' => '\\StructType\\RestaurantsType',
            'Restaurant' => '\\StructType\\Restaurant',
            'SrvcInfoCodes' => '\\StructType\\SrvcInfoCodes',
            'SrvcInfoCode' => '\\StructType\\SrvcInfoCode',
            'URLsType' => '\\StructType\\URLsType',
            'OTA_NotifReportRQ' => '\\StructType\\OTA_NotifReportRQ',
            'NotifDetails' => '\\StructType\\NotifDetails',
            'HotelNotifReport' => '\\StructType\\HotelNotifReport',
            'HotelReservations' => '\\StructType\\HotelReservations',
            'AvailStatusMessage' => '\\StructType\\AvailStatusMessage',
            'RateAmountMessage' => '\\StructType\\RateAmountMessage',
            'HotelDescriptiveContents' => '\\StructType\\HotelDescriptiveContents',
            'HotelDescriptiveContent' => '\\StructType\\HotelDescriptiveContent',
            'VehNotifReport' => '\\StructType\\VehNotifReport',
            'VehRes' => '\\StructType\\VehRes',
            'VehNotifReportRQCore' => '\\StructType\\VehNotifReportRQCore',
        );
    }
}
