<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for REQUEST_ERRORType StructType
 * Meta information extracted from the WSDL
 * - documentation: This will be fault type
 * @subpackage Structs
 */
class REQUEST_ERRORType extends AbstractStructBase
{
    /**
     * The INTL_TXN_ID
     * Meta information extracted from the WSDL
     * - documentation: Internal TXN ID
     * @var int
     */
    public $INTL_TXN_ID;
    /**
     * The CLIENT_TXN_ID
     * Meta information extracted from the WSDL
     * - documentation: Initiating domain Transaction ID of the action
     * - minOccurs: 0
     * @var string
     */
    public $CLIENT_TXN_ID;
    /**
     * The ERROR_CODE
     * Meta information extracted from the WSDL
     * - documentation: Error Code
     * @var int
     */
    public $ERROR_CODE;
    /**
     * The ERROR_SHORT_DES
     * Meta information extracted from the WSDL
     * - documentation: Error Short Description
     * @var string
     */
    public $ERROR_SHORT_DES;
    /**
     * The ERROR_LONG_DES
     * Meta information extracted from the WSDL
     * - documentation: Error Long Description
     * - minOccurs: 0
     * @var string
     */
    public $ERROR_LONG_DES;
    /**
     * The STACKTRACE
     * Meta information extracted from the WSDL
     * - documentation: This is printStackTrace output...
     * - minOccurs: 0
     * @var string
     */
    public $STACKTRACE;
    /**
     * The ERROR_ELEMENT_INDEX
     * Meta information extracted from the WSDL
     * - documentation: In case of multiple requests this is the failing element index
     * - minOccurs: 0
     * @var int
     */
    public $ERROR_ELEMENT_INDEX;
    /**
     * Constructor method for REQUEST_ERRORType
     * @uses REQUEST_ERRORType::setINTL_TXN_ID()
     * @uses REQUEST_ERRORType::setCLIENT_TXN_ID()
     * @uses REQUEST_ERRORType::setERROR_CODE()
     * @uses REQUEST_ERRORType::setERROR_SHORT_DES()
     * @uses REQUEST_ERRORType::setERROR_LONG_DES()
     * @uses REQUEST_ERRORType::setSTACKTRACE()
     * @uses REQUEST_ERRORType::setERROR_ELEMENT_INDEX()
     * @param int $iNTL_TXN_ID
     * @param string $cLIENT_TXN_ID
     * @param int $eRROR_CODE
     * @param string $eRROR_SHORT_DES
     * @param string $eRROR_LONG_DES
     * @param string $sTACKTRACE
     * @param int $eRROR_ELEMENT_INDEX
     */
    public function __construct($iNTL_TXN_ID = null, $cLIENT_TXN_ID = null, $eRROR_CODE = null, $eRROR_SHORT_DES = null, $eRROR_LONG_DES = null, $sTACKTRACE = null, $eRROR_ELEMENT_INDEX = null)
    {
        $this
            ->setINTL_TXN_ID($iNTL_TXN_ID)
            ->setCLIENT_TXN_ID($cLIENT_TXN_ID)
            ->setERROR_CODE($eRROR_CODE)
            ->setERROR_SHORT_DES($eRROR_SHORT_DES)
            ->setERROR_LONG_DES($eRROR_LONG_DES)
            ->setSTACKTRACE($sTACKTRACE)
            ->setERROR_ELEMENT_INDEX($eRROR_ELEMENT_INDEX);
    }
    /**
     * Get INTL_TXN_ID value
     * @return int|null
     */
    public function getINTL_TXN_ID()
    {
        return $this->INTL_TXN_ID;
    }
    /**
     * Set INTL_TXN_ID value
     * @param int $iNTL_TXN_ID
     * @return \StructType\REQUEST_ERRORType
     */
    public function setINTL_TXN_ID($iNTL_TXN_ID = null)
    {
        // validation for constraint: int
        if (!is_null($iNTL_TXN_ID) && !(is_int($iNTL_TXN_ID) || ctype_digit($iNTL_TXN_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iNTL_TXN_ID, true), gettype($iNTL_TXN_ID)), __LINE__);
        }
        $this->INTL_TXN_ID = $iNTL_TXN_ID;
        return $this;
    }
    /**
     * Get CLIENT_TXN_ID value
     * @return string|null
     */
    public function getCLIENT_TXN_ID()
    {
        return $this->CLIENT_TXN_ID;
    }
    /**
     * Set CLIENT_TXN_ID value
     * @param string $cLIENT_TXN_ID
     * @return \StructType\REQUEST_ERRORType
     */
    public function setCLIENT_TXN_ID($cLIENT_TXN_ID = null)
    {
        // validation for constraint: string
        if (!is_null($cLIENT_TXN_ID) && !is_string($cLIENT_TXN_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cLIENT_TXN_ID, true), gettype($cLIENT_TXN_ID)), __LINE__);
        }
        $this->CLIENT_TXN_ID = $cLIENT_TXN_ID;
        return $this;
    }
    /**
     * Get ERROR_CODE value
     * @return int|null
     */
    public function getERROR_CODE()
    {
        return $this->ERROR_CODE;
    }
    /**
     * Set ERROR_CODE value
     * @param int $eRROR_CODE
     * @return \StructType\REQUEST_ERRORType
     */
    public function setERROR_CODE($eRROR_CODE = null)
    {
        // validation for constraint: int
        if (!is_null($eRROR_CODE) && !(is_int($eRROR_CODE) || ctype_digit($eRROR_CODE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eRROR_CODE, true), gettype($eRROR_CODE)), __LINE__);
        }
        $this->ERROR_CODE = $eRROR_CODE;
        return $this;
    }
    /**
     * Get ERROR_SHORT_DES value
     * @return string|null
     */
    public function getERROR_SHORT_DES()
    {
        return $this->ERROR_SHORT_DES;
    }
    /**
     * Set ERROR_SHORT_DES value
     * @param string $eRROR_SHORT_DES
     * @return \StructType\REQUEST_ERRORType
     */
    public function setERROR_SHORT_DES($eRROR_SHORT_DES = null)
    {
        // validation for constraint: string
        if (!is_null($eRROR_SHORT_DES) && !is_string($eRROR_SHORT_DES)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eRROR_SHORT_DES, true), gettype($eRROR_SHORT_DES)), __LINE__);
        }
        $this->ERROR_SHORT_DES = $eRROR_SHORT_DES;
        return $this;
    }
    /**
     * Get ERROR_LONG_DES value
     * @return string|null
     */
    public function getERROR_LONG_DES()
    {
        return $this->ERROR_LONG_DES;
    }
    /**
     * Set ERROR_LONG_DES value
     * @param string $eRROR_LONG_DES
     * @return \StructType\REQUEST_ERRORType
     */
    public function setERROR_LONG_DES($eRROR_LONG_DES = null)
    {
        // validation for constraint: string
        if (!is_null($eRROR_LONG_DES) && !is_string($eRROR_LONG_DES)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eRROR_LONG_DES, true), gettype($eRROR_LONG_DES)), __LINE__);
        }
        $this->ERROR_LONG_DES = $eRROR_LONG_DES;
        return $this;
    }
    /**
     * Get STACKTRACE value
     * @return string|null
     */
    public function getSTACKTRACE()
    {
        return $this->STACKTRACE;
    }
    /**
     * Set STACKTRACE value
     * @param string $sTACKTRACE
     * @return \StructType\REQUEST_ERRORType
     */
    public function setSTACKTRACE($sTACKTRACE = null)
    {
        // validation for constraint: string
        if (!is_null($sTACKTRACE) && !is_string($sTACKTRACE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sTACKTRACE, true), gettype($sTACKTRACE)), __LINE__);
        }
        $this->STACKTRACE = $sTACKTRACE;
        return $this;
    }
    /**
     * Get ERROR_ELEMENT_INDEX value
     * @return int|null
     */
    public function getERROR_ELEMENT_INDEX()
    {
        return $this->ERROR_ELEMENT_INDEX;
    }
    /**
     * Set ERROR_ELEMENT_INDEX value
     * @param int $eRROR_ELEMENT_INDEX
     * @return \StructType\REQUEST_ERRORType
     */
    public function setERROR_ELEMENT_INDEX($eRROR_ELEMENT_INDEX = null)
    {
        // validation for constraint: int
        if (!is_null($eRROR_ELEMENT_INDEX) && !(is_int($eRROR_ELEMENT_INDEX) || ctype_digit($eRROR_ELEMENT_INDEX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eRROR_ELEMENT_INDEX, true), gettype($eRROR_ELEMENT_INDEX)), __LINE__);
        }
        $this->ERROR_ELEMENT_INDEX = $eRROR_ELEMENT_INDEX;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\REQUEST_ERRORType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
