<?php

namespace EnumType;

/**
 * This class stands for DATE_TYPE EnumType
 * @subpackage Enumerations
 */
class DATE_TYPE
{
    /**
     * Constant for value 'ISSUE'
     * @return string 'ISSUE'
     */
    const VALUE_ISSUE = 'ISSUE';
    /**
     * Constant for value 'CREATE'
     * @return string 'CREATE'
     */
    const VALUE_CREATE = 'CREATE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ISSUE
     * @uses self::VALUE_CREATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ISSUE,
            self::VALUE_CREATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
