<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrepareInvoiceResponseRequest StructType
 * Meta information extracted from the WSDL
 * - type: PrepareInvoiceResponseRequest
 * @subpackage Structs
 */
class PrepareInvoiceResponseRequest extends REQUEST
{
    /**
     * The INVOICE
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\INVOICE[]
     */
    public $INVOICE;
    /**
     * The STATUS
     * @var string
     */
    public $STATUS;
    /**
     * The DESCRIPTION
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DESCRIPTION;
    /**
     * Constructor method for PrepareInvoiceResponseRequest
     * @uses PrepareInvoiceResponseRequest::setINVOICE()
     * @uses PrepareInvoiceResponseRequest::setSTATUS()
     * @uses PrepareInvoiceResponseRequest::setDESCRIPTION()
     * @param \StructType\INVOICE[] $iNVOICE
     * @param string $sTATUS
     * @param string[] $dESCRIPTION
     */
    public function __construct(array $iNVOICE = array(), $sTATUS = null, array $dESCRIPTION = array())
    {
        $this
            ->setINVOICE($iNVOICE)
            ->setSTATUS($sTATUS)
            ->setDESCRIPTION($dESCRIPTION);
    }
    /**
     * Get INVOICE value
     * @return \StructType\INVOICE[]
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * This method is responsible for validating the values passed to the setINVOICE method
     * This method is willingly generated in order to preserve the one-line inline validation within the setINVOICE method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateINVOICEForArrayConstraintsFromSetINVOICE(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $prepareInvoiceResponseRequestINVOICEItem) {
            // validation for constraint: itemType
            if (!$prepareInvoiceResponseRequestINVOICEItem instanceof \StructType\INVOICE) {
                $invalidValues[] = is_object($prepareInvoiceResponseRequestINVOICEItem) ? get_class($prepareInvoiceResponseRequestINVOICEItem) : sprintf('%s(%s)', gettype($prepareInvoiceResponseRequestINVOICEItem), var_export($prepareInvoiceResponseRequestINVOICEItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The INVOICE property can only contain items of type \StructType\INVOICE, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE[] $iNVOICE
     * @return \StructType\PrepareInvoiceResponseRequest
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        // validation for constraint: array
        if ('' !== ($iNVOICEArrayErrorMessage = self::validateINVOICEForArrayConstraintsFromSetINVOICE($iNVOICE))) {
            throw new \InvalidArgumentException($iNVOICEArrayErrorMessage, __LINE__);
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE $item
     * @return \StructType\PrepareInvoiceResponseRequest
     */
    public function addToINVOICE(\StructType\INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of type \StructType\INVOICE, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Get STATUS value
     * @return string|null
     */
    public function getSTATUS()
    {
        return $this->STATUS;
    }
    /**
     * Set STATUS value
     * @param string $sTATUS
     * @return \StructType\PrepareInvoiceResponseRequest
     */
    public function setSTATUS($sTATUS = null)
    {
        // validation for constraint: string
        if (!is_null($sTATUS) && !is_string($sTATUS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sTATUS, true), gettype($sTATUS)), __LINE__);
        }
        $this->STATUS = $sTATUS;
        return $this;
    }
    /**
     * Get DESCRIPTION value
     * @return string[]|null
     */
    public function getDESCRIPTION()
    {
        return $this->DESCRIPTION;
    }
    /**
     * This method is responsible for validating the values passed to the setDESCRIPTION method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDESCRIPTION method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDESCRIPTIONForArrayConstraintsFromSetDESCRIPTION(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $prepareInvoiceResponseRequestDESCRIPTIONItem) {
            // validation for constraint: itemType
            if (!is_string($prepareInvoiceResponseRequestDESCRIPTIONItem)) {
                $invalidValues[] = is_object($prepareInvoiceResponseRequestDESCRIPTIONItem) ? get_class($prepareInvoiceResponseRequestDESCRIPTIONItem) : sprintf('%s(%s)', gettype($prepareInvoiceResponseRequestDESCRIPTIONItem), var_export($prepareInvoiceResponseRequestDESCRIPTIONItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DESCRIPTION property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DESCRIPTION value
     * @throws \InvalidArgumentException
     * @param string[] $dESCRIPTION
     * @return \StructType\PrepareInvoiceResponseRequest
     */
    public function setDESCRIPTION(array $dESCRIPTION = array())
    {
        // validation for constraint: array
        if ('' !== ($dESCRIPTIONArrayErrorMessage = self::validateDESCRIPTIONForArrayConstraintsFromSetDESCRIPTION($dESCRIPTION))) {
            throw new \InvalidArgumentException($dESCRIPTIONArrayErrorMessage, __LINE__);
        }
        $this->DESCRIPTION = $dESCRIPTION;
        return $this;
    }
    /**
     * Add item to DESCRIPTION value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PrepareInvoiceResponseRequest
     */
    public function addToDESCRIPTION($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DESCRIPTION property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DESCRIPTION[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrepareInvoiceResponseRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
