<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HEADER StructType
 * @subpackage Structs
 */
class HEADER extends AbstractStructBase
{
    /**
     * The SENDER
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SENDER;
    /**
     * The RECEIVER
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RECEIVER;
    /**
     * The SUPPLIER
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SUPPLIER;
    /**
     * The CUSTOMER
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CUSTOMER;
    /**
     * The ISSUE_DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ISSUE_DATE;
    /**
     * The PAYABLE_AMOUNT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $PAYABLE_AMOUNT;
    /**
     * The FROM
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FROM;
    /**
     * The TO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TO;
    /**
     * The PROFILEID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PROFILEID;
    /**
     * The INVOICE_TYPE_CODE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $INVOICE_TYPE_CODE;
    /**
     * The STATUS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $STATUS;
    /**
     * The STATUS_DESCRIPTION
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $STATUS_DESCRIPTION;
    /**
     * The GIB_STATUS_CODE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GIB_STATUS_CODE;
    /**
     * The GIB_STATUS_DESCRIPTION
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GIB_STATUS_DESCRIPTION;
    /**
     * The DIRECTION
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DIRECTION;
    /**
     * The RESPONSE_CODE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RESPONSE_CODE;
    /**
     * The RESPONSE_DESCRIPTION
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RESPONSE_DESCRIPTION;
    /**
     * The FILENAME
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FILENAME;
    /**
     * The HASH
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HASH;
    /**
     * The CDATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CDATE;
    /**
     * The ENVELOPE_IDENTIFIER
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ENVELOPE_IDENTIFIER;
    /**
     * The GTB_REFNO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GTB_REFNO;
    /**
     * The GTB_GCB_TESCILNO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GTB_GCB_TESCILNO;
    /**
     * The GTB_FIILI_IHRACAT_TARIHI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GTB_FIILI_IHRACAT_TARIHI;
    /**
     * The STATUS_CODE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $STATUS_CODE;
    /**
     * The DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DATE;
    /**
     * The TYPE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TYPE;
    /**
     * Constructor method for HEADER
     * @uses HEADER::setSENDER()
     * @uses HEADER::setRECEIVER()
     * @uses HEADER::setSUPPLIER()
     * @uses HEADER::setCUSTOMER()
     * @uses HEADER::setISSUE_DATE()
     * @uses HEADER::setPAYABLE_AMOUNT()
     * @uses HEADER::setFROM()
     * @uses HEADER::setTO()
     * @uses HEADER::setPROFILEID()
     * @uses HEADER::setINVOICE_TYPE_CODE()
     * @uses HEADER::setSTATUS()
     * @uses HEADER::setSTATUS_DESCRIPTION()
     * @uses HEADER::setGIB_STATUS_CODE()
     * @uses HEADER::setGIB_STATUS_DESCRIPTION()
     * @uses HEADER::setDIRECTION()
     * @uses HEADER::setRESPONSE_CODE()
     * @uses HEADER::setRESPONSE_DESCRIPTION()
     * @uses HEADER::setFILENAME()
     * @uses HEADER::setHASH()
     * @uses HEADER::setCDATE()
     * @uses HEADER::setENVELOPE_IDENTIFIER()
     * @uses HEADER::setGTB_REFNO()
     * @uses HEADER::setGTB_GCB_TESCILNO()
     * @uses HEADER::setGTB_FIILI_IHRACAT_TARIHI()
     * @uses HEADER::setSTATUS_CODE()
     * @uses HEADER::setDATE()
     * @uses HEADER::setTYPE()
     * @param string $sENDER
     * @param string $rECEIVER
     * @param string $sUPPLIER
     * @param string $cUSTOMER
     * @param string $iSSUE_DATE
     * @param \StructType\AmountType $pAYABLE_AMOUNT
     * @param string $fROM
     * @param string $tO
     * @param string $pROFILEID
     * @param string $iNVOICE_TYPE_CODE
     * @param string $sTATUS
     * @param string $sTATUS_DESCRIPTION
     * @param int $gIB_STATUS_CODE
     * @param string $gIB_STATUS_DESCRIPTION
     * @param string $dIRECTION
     * @param string $rESPONSE_CODE
     * @param string $rESPONSE_DESCRIPTION
     * @param string $fILENAME
     * @param string $hASH
     * @param string $cDATE
     * @param string $eNVELOPE_IDENTIFIER
     * @param string $gTB_REFNO
     * @param string $gTB_GCB_TESCILNO
     * @param string $gTB_FIILI_IHRACAT_TARIHI
     * @param string $sTATUS_CODE
     * @param string $dATE
     * @param string $tYPE
     */
    public function __construct($sENDER = null, $rECEIVER = null, $sUPPLIER = null, $cUSTOMER = null, $iSSUE_DATE = null, \StructType\AmountType $pAYABLE_AMOUNT = null, $fROM = null, $tO = null, $pROFILEID = null, $iNVOICE_TYPE_CODE = null, $sTATUS = null, $sTATUS_DESCRIPTION = null, $gIB_STATUS_CODE = null, $gIB_STATUS_DESCRIPTION = null, $dIRECTION = null, $rESPONSE_CODE = null, $rESPONSE_DESCRIPTION = null, $fILENAME = null, $hASH = null, $cDATE = null, $eNVELOPE_IDENTIFIER = null, $gTB_REFNO = null, $gTB_GCB_TESCILNO = null, $gTB_FIILI_IHRACAT_TARIHI = null, $sTATUS_CODE = null, $dATE = null, $tYPE = null)
    {
        $this
            ->setSENDER($sENDER)
            ->setRECEIVER($rECEIVER)
            ->setSUPPLIER($sUPPLIER)
            ->setCUSTOMER($cUSTOMER)
            ->setISSUE_DATE($iSSUE_DATE)
            ->setPAYABLE_AMOUNT($pAYABLE_AMOUNT)
            ->setFROM($fROM)
            ->setTO($tO)
            ->setPROFILEID($pROFILEID)
            ->setINVOICE_TYPE_CODE($iNVOICE_TYPE_CODE)
            ->setSTATUS($sTATUS)
            ->setSTATUS_DESCRIPTION($sTATUS_DESCRIPTION)
            ->setGIB_STATUS_CODE($gIB_STATUS_CODE)
            ->setGIB_STATUS_DESCRIPTION($gIB_STATUS_DESCRIPTION)
            ->setDIRECTION($dIRECTION)
            ->setRESPONSE_CODE($rESPONSE_CODE)
            ->setRESPONSE_DESCRIPTION($rESPONSE_DESCRIPTION)
            ->setFILENAME($fILENAME)
            ->setHASH($hASH)
            ->setCDATE($cDATE)
            ->setENVELOPE_IDENTIFIER($eNVELOPE_IDENTIFIER)
            ->setGTB_REFNO($gTB_REFNO)
            ->setGTB_GCB_TESCILNO($gTB_GCB_TESCILNO)
            ->setGTB_FIILI_IHRACAT_TARIHI($gTB_FIILI_IHRACAT_TARIHI)
            ->setSTATUS_CODE($sTATUS_CODE)
            ->setDATE($dATE)
            ->setTYPE($tYPE);
    }
    /**
     * Get SENDER value
     * @return string|null
     */
    public function getSENDER()
    {
        return $this->SENDER;
    }
    /**
     * Set SENDER value
     * @param string $sENDER
     * @return \StructType\HEADER
     */
    public function setSENDER($sENDER = null)
    {
        // validation for constraint: string
        if (!is_null($sENDER) && !is_string($sENDER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sENDER, true), gettype($sENDER)), __LINE__);
        }
        $this->SENDER = $sENDER;
        return $this;
    }
    /**
     * Get RECEIVER value
     * @return string|null
     */
    public function getRECEIVER()
    {
        return $this->RECEIVER;
    }
    /**
     * Set RECEIVER value
     * @param string $rECEIVER
     * @return \StructType\HEADER
     */
    public function setRECEIVER($rECEIVER = null)
    {
        // validation for constraint: string
        if (!is_null($rECEIVER) && !is_string($rECEIVER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rECEIVER, true), gettype($rECEIVER)), __LINE__);
        }
        $this->RECEIVER = $rECEIVER;
        return $this;
    }
    /**
     * Get SUPPLIER value
     * @return string|null
     */
    public function getSUPPLIER()
    {
        return $this->SUPPLIER;
    }
    /**
     * Set SUPPLIER value
     * @param string $sUPPLIER
     * @return \StructType\HEADER
     */
    public function setSUPPLIER($sUPPLIER = null)
    {
        // validation for constraint: string
        if (!is_null($sUPPLIER) && !is_string($sUPPLIER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUPPLIER, true), gettype($sUPPLIER)), __LINE__);
        }
        $this->SUPPLIER = $sUPPLIER;
        return $this;
    }
    /**
     * Get CUSTOMER value
     * @return string|null
     */
    public function getCUSTOMER()
    {
        return $this->CUSTOMER;
    }
    /**
     * Set CUSTOMER value
     * @param string $cUSTOMER
     * @return \StructType\HEADER
     */
    public function setCUSTOMER($cUSTOMER = null)
    {
        // validation for constraint: string
        if (!is_null($cUSTOMER) && !is_string($cUSTOMER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cUSTOMER, true), gettype($cUSTOMER)), __LINE__);
        }
        $this->CUSTOMER = $cUSTOMER;
        return $this;
    }
    /**
     * Get ISSUE_DATE value
     * @return string|null
     */
    public function getISSUE_DATE()
    {
        return $this->ISSUE_DATE;
    }
    /**
     * Set ISSUE_DATE value
     * @param string $iSSUE_DATE
     * @return \StructType\HEADER
     */
    public function setISSUE_DATE($iSSUE_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($iSSUE_DATE) && !is_string($iSSUE_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iSSUE_DATE, true), gettype($iSSUE_DATE)), __LINE__);
        }
        $this->ISSUE_DATE = $iSSUE_DATE;
        return $this;
    }
    /**
     * Get PAYABLE_AMOUNT value
     * @return \StructType\AmountType|null
     */
    public function getPAYABLE_AMOUNT()
    {
        return $this->PAYABLE_AMOUNT;
    }
    /**
     * Set PAYABLE_AMOUNT value
     * @param \StructType\AmountType $pAYABLE_AMOUNT
     * @return \StructType\HEADER
     */
    public function setPAYABLE_AMOUNT(\StructType\AmountType $pAYABLE_AMOUNT = null)
    {
        $this->PAYABLE_AMOUNT = $pAYABLE_AMOUNT;
        return $this;
    }
    /**
     * Get FROM value
     * @return string|null
     */
    public function getFROM()
    {
        return $this->FROM;
    }
    /**
     * Set FROM value
     * @param string $fROM
     * @return \StructType\HEADER
     */
    public function setFROM($fROM = null)
    {
        // validation for constraint: string
        if (!is_null($fROM) && !is_string($fROM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fROM, true), gettype($fROM)), __LINE__);
        }
        $this->FROM = $fROM;
        return $this;
    }
    /**
     * Get TO value
     * @return string|null
     */
    public function getTO()
    {
        return $this->TO;
    }
    /**
     * Set TO value
     * @param string $tO
     * @return \StructType\HEADER
     */
    public function setTO($tO = null)
    {
        // validation for constraint: string
        if (!is_null($tO) && !is_string($tO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tO, true), gettype($tO)), __LINE__);
        }
        $this->TO = $tO;
        return $this;
    }
    /**
     * Get PROFILEID value
     * @return string|null
     */
    public function getPROFILEID()
    {
        return $this->PROFILEID;
    }
    /**
     * Set PROFILEID value
     * @param string $pROFILEID
     * @return \StructType\HEADER
     */
    public function setPROFILEID($pROFILEID = null)
    {
        // validation for constraint: string
        if (!is_null($pROFILEID) && !is_string($pROFILEID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pROFILEID, true), gettype($pROFILEID)), __LINE__);
        }
        $this->PROFILEID = $pROFILEID;
        return $this;
    }
    /**
     * Get INVOICE_TYPE_CODE value
     * @return string|null
     */
    public function getINVOICE_TYPE_CODE()
    {
        return $this->INVOICE_TYPE_CODE;
    }
    /**
     * Set INVOICE_TYPE_CODE value
     * @param string $iNVOICE_TYPE_CODE
     * @return \StructType\HEADER
     */
    public function setINVOICE_TYPE_CODE($iNVOICE_TYPE_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_TYPE_CODE) && !is_string($iNVOICE_TYPE_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iNVOICE_TYPE_CODE, true), gettype($iNVOICE_TYPE_CODE)), __LINE__);
        }
        $this->INVOICE_TYPE_CODE = $iNVOICE_TYPE_CODE;
        return $this;
    }
    /**
     * Get STATUS value
     * @return string|null
     */
    public function getSTATUS()
    {
        return $this->STATUS;
    }
    /**
     * Set STATUS value
     * @param string $sTATUS
     * @return \StructType\HEADER
     */
    public function setSTATUS($sTATUS = null)
    {
        // validation for constraint: string
        if (!is_null($sTATUS) && !is_string($sTATUS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sTATUS, true), gettype($sTATUS)), __LINE__);
        }
        $this->STATUS = $sTATUS;
        return $this;
    }
    /**
     * Get STATUS_DESCRIPTION value
     * @return string|null
     */
    public function getSTATUS_DESCRIPTION()
    {
        return $this->STATUS_DESCRIPTION;
    }
    /**
     * Set STATUS_DESCRIPTION value
     * @param string $sTATUS_DESCRIPTION
     * @return \StructType\HEADER
     */
    public function setSTATUS_DESCRIPTION($sTATUS_DESCRIPTION = null)
    {
        // validation for constraint: string
        if (!is_null($sTATUS_DESCRIPTION) && !is_string($sTATUS_DESCRIPTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sTATUS_DESCRIPTION, true), gettype($sTATUS_DESCRIPTION)), __LINE__);
        }
        $this->STATUS_DESCRIPTION = $sTATUS_DESCRIPTION;
        return $this;
    }
    /**
     * Get GIB_STATUS_CODE value
     * @return int|null
     */
    public function getGIB_STATUS_CODE()
    {
        return $this->GIB_STATUS_CODE;
    }
    /**
     * Set GIB_STATUS_CODE value
     * @param int $gIB_STATUS_CODE
     * @return \StructType\HEADER
     */
    public function setGIB_STATUS_CODE($gIB_STATUS_CODE = null)
    {
        // validation for constraint: int
        if (!is_null($gIB_STATUS_CODE) && !(is_int($gIB_STATUS_CODE) || ctype_digit($gIB_STATUS_CODE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gIB_STATUS_CODE, true), gettype($gIB_STATUS_CODE)), __LINE__);
        }
        $this->GIB_STATUS_CODE = $gIB_STATUS_CODE;
        return $this;
    }
    /**
     * Get GIB_STATUS_DESCRIPTION value
     * @return string|null
     */
    public function getGIB_STATUS_DESCRIPTION()
    {
        return $this->GIB_STATUS_DESCRIPTION;
    }
    /**
     * Set GIB_STATUS_DESCRIPTION value
     * @param string $gIB_STATUS_DESCRIPTION
     * @return \StructType\HEADER
     */
    public function setGIB_STATUS_DESCRIPTION($gIB_STATUS_DESCRIPTION = null)
    {
        // validation for constraint: string
        if (!is_null($gIB_STATUS_DESCRIPTION) && !is_string($gIB_STATUS_DESCRIPTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gIB_STATUS_DESCRIPTION, true), gettype($gIB_STATUS_DESCRIPTION)), __LINE__);
        }
        $this->GIB_STATUS_DESCRIPTION = $gIB_STATUS_DESCRIPTION;
        return $this;
    }
    /**
     * Get DIRECTION value
     * @return string|null
     */
    public function getDIRECTION()
    {
        return $this->DIRECTION;
    }
    /**
     * Set DIRECTION value
     * @param string $dIRECTION
     * @return \StructType\HEADER
     */
    public function setDIRECTION($dIRECTION = null)
    {
        // validation for constraint: string
        if (!is_null($dIRECTION) && !is_string($dIRECTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dIRECTION, true), gettype($dIRECTION)), __LINE__);
        }
        $this->DIRECTION = $dIRECTION;
        return $this;
    }
    /**
     * Get RESPONSE_CODE value
     * @return string|null
     */
    public function getRESPONSE_CODE()
    {
        return $this->RESPONSE_CODE;
    }
    /**
     * Set RESPONSE_CODE value
     * @param string $rESPONSE_CODE
     * @return \StructType\HEADER
     */
    public function setRESPONSE_CODE($rESPONSE_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($rESPONSE_CODE) && !is_string($rESPONSE_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESPONSE_CODE, true), gettype($rESPONSE_CODE)), __LINE__);
        }
        $this->RESPONSE_CODE = $rESPONSE_CODE;
        return $this;
    }
    /**
     * Get RESPONSE_DESCRIPTION value
     * @return string|null
     */
    public function getRESPONSE_DESCRIPTION()
    {
        return $this->RESPONSE_DESCRIPTION;
    }
    /**
     * Set RESPONSE_DESCRIPTION value
     * @param string $rESPONSE_DESCRIPTION
     * @return \StructType\HEADER
     */
    public function setRESPONSE_DESCRIPTION($rESPONSE_DESCRIPTION = null)
    {
        // validation for constraint: string
        if (!is_null($rESPONSE_DESCRIPTION) && !is_string($rESPONSE_DESCRIPTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESPONSE_DESCRIPTION, true), gettype($rESPONSE_DESCRIPTION)), __LINE__);
        }
        $this->RESPONSE_DESCRIPTION = $rESPONSE_DESCRIPTION;
        return $this;
    }
    /**
     * Get FILENAME value
     * @return string|null
     */
    public function getFILENAME()
    {
        return $this->FILENAME;
    }
    /**
     * Set FILENAME value
     * @param string $fILENAME
     * @return \StructType\HEADER
     */
    public function setFILENAME($fILENAME = null)
    {
        // validation for constraint: string
        if (!is_null($fILENAME) && !is_string($fILENAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fILENAME, true), gettype($fILENAME)), __LINE__);
        }
        $this->FILENAME = $fILENAME;
        return $this;
    }
    /**
     * Get HASH value
     * @return string|null
     */
    public function getHASH()
    {
        return $this->HASH;
    }
    /**
     * Set HASH value
     * @param string $hASH
     * @return \StructType\HEADER
     */
    public function setHASH($hASH = null)
    {
        // validation for constraint: string
        if (!is_null($hASH) && !is_string($hASH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hASH, true), gettype($hASH)), __LINE__);
        }
        $this->HASH = $hASH;
        return $this;
    }
    /**
     * Get CDATE value
     * @return string|null
     */
    public function getCDATE()
    {
        return $this->CDATE;
    }
    /**
     * Set CDATE value
     * @param string $cDATE
     * @return \StructType\HEADER
     */
    public function setCDATE($cDATE = null)
    {
        // validation for constraint: string
        if (!is_null($cDATE) && !is_string($cDATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cDATE, true), gettype($cDATE)), __LINE__);
        }
        $this->CDATE = $cDATE;
        return $this;
    }
    /**
     * Get ENVELOPE_IDENTIFIER value
     * @return string|null
     */
    public function getENVELOPE_IDENTIFIER()
    {
        return $this->ENVELOPE_IDENTIFIER;
    }
    /**
     * Set ENVELOPE_IDENTIFIER value
     * @param string $eNVELOPE_IDENTIFIER
     * @return \StructType\HEADER
     */
    public function setENVELOPE_IDENTIFIER($eNVELOPE_IDENTIFIER = null)
    {
        // validation for constraint: string
        if (!is_null($eNVELOPE_IDENTIFIER) && !is_string($eNVELOPE_IDENTIFIER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eNVELOPE_IDENTIFIER, true), gettype($eNVELOPE_IDENTIFIER)), __LINE__);
        }
        $this->ENVELOPE_IDENTIFIER = $eNVELOPE_IDENTIFIER;
        return $this;
    }
    /**
     * Get GTB_REFNO value
     * @return string|null
     */
    public function getGTB_REFNO()
    {
        return $this->GTB_REFNO;
    }
    /**
     * Set GTB_REFNO value
     * @param string $gTB_REFNO
     * @return \StructType\HEADER
     */
    public function setGTB_REFNO($gTB_REFNO = null)
    {
        // validation for constraint: string
        if (!is_null($gTB_REFNO) && !is_string($gTB_REFNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gTB_REFNO, true), gettype($gTB_REFNO)), __LINE__);
        }
        $this->GTB_REFNO = $gTB_REFNO;
        return $this;
    }
    /**
     * Get GTB_GCB_TESCILNO value
     * @return string|null
     */
    public function getGTB_GCB_TESCILNO()
    {
        return $this->GTB_GCB_TESCILNO;
    }
    /**
     * Set GTB_GCB_TESCILNO value
     * @param string $gTB_GCB_TESCILNO
     * @return \StructType\HEADER
     */
    public function setGTB_GCB_TESCILNO($gTB_GCB_TESCILNO = null)
    {
        // validation for constraint: string
        if (!is_null($gTB_GCB_TESCILNO) && !is_string($gTB_GCB_TESCILNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gTB_GCB_TESCILNO, true), gettype($gTB_GCB_TESCILNO)), __LINE__);
        }
        $this->GTB_GCB_TESCILNO = $gTB_GCB_TESCILNO;
        return $this;
    }
    /**
     * Get GTB_FIILI_IHRACAT_TARIHI value
     * @return string|null
     */
    public function getGTB_FIILI_IHRACAT_TARIHI()
    {
        return $this->GTB_FIILI_IHRACAT_TARIHI;
    }
    /**
     * Set GTB_FIILI_IHRACAT_TARIHI value
     * @param string $gTB_FIILI_IHRACAT_TARIHI
     * @return \StructType\HEADER
     */
    public function setGTB_FIILI_IHRACAT_TARIHI($gTB_FIILI_IHRACAT_TARIHI = null)
    {
        // validation for constraint: string
        if (!is_null($gTB_FIILI_IHRACAT_TARIHI) && !is_string($gTB_FIILI_IHRACAT_TARIHI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gTB_FIILI_IHRACAT_TARIHI, true), gettype($gTB_FIILI_IHRACAT_TARIHI)), __LINE__);
        }
        $this->GTB_FIILI_IHRACAT_TARIHI = $gTB_FIILI_IHRACAT_TARIHI;
        return $this;
    }
    /**
     * Get STATUS_CODE value
     * @return string|null
     */
    public function getSTATUS_CODE()
    {
        return $this->STATUS_CODE;
    }
    /**
     * Set STATUS_CODE value
     * @param string $sTATUS_CODE
     * @return \StructType\HEADER
     */
    public function setSTATUS_CODE($sTATUS_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($sTATUS_CODE) && !is_string($sTATUS_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sTATUS_CODE, true), gettype($sTATUS_CODE)), __LINE__);
        }
        $this->STATUS_CODE = $sTATUS_CODE;
        return $this;
    }
    /**
     * Get DATE value
     * @return string|null
     */
    public function getDATE()
    {
        return $this->DATE;
    }
    /**
     * Set DATE value
     * @param string $dATE
     * @return \StructType\HEADER
     */
    public function setDATE($dATE = null)
    {
        // validation for constraint: string
        if (!is_null($dATE) && !is_string($dATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dATE, true), gettype($dATE)), __LINE__);
        }
        $this->DATE = $dATE;
        return $this;
    }
    /**
     * Get TYPE value
     * @return string|null
     */
    public function getTYPE()
    {
        return $this->TYPE;
    }
    /**
     * Set TYPE value
     * @param string $tYPE
     * @return \StructType\HEADER
     */
    public function setTYPE($tYPE = null)
    {
        // validation for constraint: string
        if (!is_null($tYPE) && !is_string($tYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tYPE, true), gettype($tYPE)), __LINE__);
        }
        $this->TYPE = $tYPE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HEADER
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
