<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUserListResponse StructType
 * Meta information extracted from the WSDL
 * - type: GetUserListResponse
 * @subpackage Structs
 */
class GetUserListResponse extends AbstractStructBase
{
    /**
     * The USER
     * Meta information extracted from the WSDL
     * - choice: USER
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GIBUSER[]
     */
    public $USER;
    /**
     * Constructor method for GetUserListResponse
     * @uses GetUserListResponse::setUSER()
     * @param \StructType\GIBUSER[] $uSER
     */
    public function __construct(array $uSER = array())
    {
        $this
            ->setUSER($uSER);
    }
    /**
     * Get USER value
     * @return \StructType\GIBUSER[]|null
     */
    public function getUSER()
    {
        return isset($this->USER) ? $this->USER : null;
    }
    /**
     * This method is responsible for validating the values passed to the setUSER method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUSER method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUSERForArrayConstraintsFromSetUSER(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getUserListResponseUSERItem) {
            // validation for constraint: itemType
            if (!$getUserListResponseUSERItem instanceof \StructType\GIBUSER) {
                $invalidValues[] = is_object($getUserListResponseUSERItem) ? get_class($getUserListResponseUSERItem) : sprintf('%s(%s)', gettype($getUserListResponseUSERItem), var_export($getUserListResponseUSERItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The USER property can only contain items of type \StructType\GIBUSER, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setUSER method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUSER method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUSERForChoiceConstraintsFromSetUSER($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property USER can\'t be set as the property %s is already set. Only one property must be set among these properties: USER, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set USER value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\GIBUSER[] $uSER
     * @return \StructType\GetUserListResponse
     */
    public function setUSER(array $uSER = array())
    {
        // validation for constraint: array
        if ('' !== ($uSERArrayErrorMessage = self::validateUSERForArrayConstraintsFromSetUSER($uSER))) {
            throw new \InvalidArgumentException($uSERArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(USER)
        if ('' !== ($uSERChoiceErrorMessage = self::validateUSERForChoiceConstraintsFromSetUSER($uSER))) {
            throw new \InvalidArgumentException($uSERChoiceErrorMessage, __LINE__);
        }
        if (is_null($uSER) || (is_array($uSER) && empty($uSER))) {
            unset($this->USER);
        } else {
            $this->USER = $uSER;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToUSER method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToUSER method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToUSER($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property USER can\'t be set as the property %s is already set. Only one property must be set among these properties: USER, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to USER value
     * @throws \InvalidArgumentException
     * @param \StructType\GIBUSER $item
     * @return \StructType\GetUserListResponse
     */
    public function addToUSER(\StructType\GIBUSER $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GIBUSER) {
            throw new \InvalidArgumentException(sprintf('The USER property can only contain items of type \StructType\GIBUSER, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(USER)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToUSER($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->USER[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetUserListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
