<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoadInvoiceRequest StructType
 * Meta information extracted from the WSDL
 * - type: LoadInvoiceRequest
 * @subpackage Structs
 */
class LoadInvoiceRequest extends REQUEST
{
    /**
     * The INVOICE
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\INVOICE[]
     */
    public $INVOICE;
    /**
     * The VALIDATION_FLAG
     * Meta information extracted from the WSDL
     * - default: Y
     * - minOccurs: 0
     * @var string
     */
    public $VALIDATION_FLAG;
    /**
     * Constructor method for LoadInvoiceRequest
     * @uses LoadInvoiceRequest::setINVOICE()
     * @uses LoadInvoiceRequest::setVALIDATION_FLAG()
     * @param \StructType\INVOICE[] $iNVOICE
     * @param string $vALIDATION_FLAG
     */
    public function __construct(array $iNVOICE = array(), $vALIDATION_FLAG = 'Y')
    {
        $this
            ->setINVOICE($iNVOICE)
            ->setVALIDATION_FLAG($vALIDATION_FLAG);
    }
    /**
     * Get INVOICE value
     * @return \StructType\INVOICE[]
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * This method is responsible for validating the values passed to the setINVOICE method
     * This method is willingly generated in order to preserve the one-line inline validation within the setINVOICE method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateINVOICEForArrayConstraintsFromSetINVOICE(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $loadInvoiceRequestINVOICEItem) {
            // validation for constraint: itemType
            if (!$loadInvoiceRequestINVOICEItem instanceof \StructType\INVOICE) {
                $invalidValues[] = is_object($loadInvoiceRequestINVOICEItem) ? get_class($loadInvoiceRequestINVOICEItem) : sprintf('%s(%s)', gettype($loadInvoiceRequestINVOICEItem), var_export($loadInvoiceRequestINVOICEItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The INVOICE property can only contain items of type \StructType\INVOICE, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE[] $iNVOICE
     * @return \StructType\LoadInvoiceRequest
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        // validation for constraint: array
        if ('' !== ($iNVOICEArrayErrorMessage = self::validateINVOICEForArrayConstraintsFromSetINVOICE($iNVOICE))) {
            throw new \InvalidArgumentException($iNVOICEArrayErrorMessage, __LINE__);
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE $item
     * @return \StructType\LoadInvoiceRequest
     */
    public function addToINVOICE(\StructType\INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of type \StructType\INVOICE, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Get VALIDATION_FLAG value
     * @return string|null
     */
    public function getVALIDATION_FLAG()
    {
        return $this->VALIDATION_FLAG;
    }
    /**
     * Set VALIDATION_FLAG value
     * @uses \EnumType\FLAG_VALUE::valueIsValid()
     * @uses \EnumType\FLAG_VALUE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vALIDATION_FLAG
     * @return \StructType\LoadInvoiceRequest
     */
    public function setVALIDATION_FLAG($vALIDATION_FLAG = 'Y')
    {
        // validation for constraint: enumeration
        if (!\EnumType\FLAG_VALUE::valueIsValid($vALIDATION_FLAG)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FLAG_VALUE', is_array($vALIDATION_FLAG) ? implode(', ', $vALIDATION_FLAG) : var_export($vALIDATION_FLAG, true), implode(', ', \EnumType\FLAG_VALUE::getValidValues())), __LINE__);
        }
        $this->VALIDATION_FLAG = $vALIDATION_FLAG;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoadInvoiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
