<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LOV_VALUEType StructType
 * Meta information extracted from the WSDL
 * - documentation: Helper Entity; Holds LOV Value Type
 * @subpackage Structs
 */
class LOV_VALUEType extends AbstractStructBase
{
    /**
     * The LOV_ID
     * Meta information extracted from the WSDL
     * - documentation: Indicates list of value ID
     * @var int
     */
    public $LOV_ID;
    /**
     * The LOV_CODE
     * Meta information extracted from the WSDL
     * - documentation: LOV Internal CODE
     * - base: xsd:token
     * - default: 'N'
     * - maxLength: 64
     * - minOccurs: 0
     * @var string
     */
    public $LOV_CODE;
    /**
     * Constructor method for LOV_VALUEType
     * @uses LOV_VALUEType::setLOV_ID()
     * @uses LOV_VALUEType::setLOV_CODE()
     * @param int $lOV_ID
     * @param string $lOV_CODE
     */
    public function __construct($lOV_ID = null, $lOV_CODE = '\'N\'')
    {
        $this
            ->setLOV_ID($lOV_ID)
            ->setLOV_CODE($lOV_CODE);
    }
    /**
     * Get LOV_ID value
     * @return int|null
     */
    public function getLOV_ID()
    {
        return $this->LOV_ID;
    }
    /**
     * Set LOV_ID value
     * @param int $lOV_ID
     * @return \StructType\LOV_VALUEType
     */
    public function setLOV_ID($lOV_ID = null)
    {
        // validation for constraint: int
        if (!is_null($lOV_ID) && !(is_int($lOV_ID) || ctype_digit($lOV_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lOV_ID, true), gettype($lOV_ID)), __LINE__);
        }
        $this->LOV_ID = $lOV_ID;
        return $this;
    }
    /**
     * Get LOV_CODE value
     * @return string|null
     */
    public function getLOV_CODE()
    {
        return $this->LOV_CODE;
    }
    /**
     * Set LOV_CODE value
     * @param string $lOV_CODE
     * @return \StructType\LOV_VALUEType
     */
    public function setLOV_CODE($lOV_CODE = '\'N\'')
    {
        // validation for constraint: string
        if (!is_null($lOV_CODE) && !is_string($lOV_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lOV_CODE, true), gettype($lOV_CODE)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($lOV_CODE) && mb_strlen($lOV_CODE) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($lOV_CODE)), __LINE__);
        }
        $this->LOV_CODE = $lOV_CODE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LOV_VALUEType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
