<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ELEMENT StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to search for the envelopes having package content with the given type and uuid with this element
 * @subpackage Structs
 */
class ELEMENT extends AbstractStructBase
{
    /**
     * The TYPE
     * Meta information extracted from the WSDL
     * - documentation: One of the values of (INVOICE,APPLICATIONRESPONSE)
     * @var string
     */
    public $TYPE;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - documentation: UUID of the target element
     * @var string
     */
    public $UUID;
    /**
     * Constructor method for ELEMENT
     * @uses ELEMENT::setTYPE()
     * @uses ELEMENT::setUUID()
     * @param string $tYPE
     * @param string $uUID
     */
    public function __construct($tYPE = null, $uUID = null)
    {
        $this
            ->setTYPE($tYPE)
            ->setUUID($uUID);
    }
    /**
     * Get TYPE value
     * @return string|null
     */
    public function getTYPE()
    {
        return $this->TYPE;
    }
    /**
     * Set TYPE value
     * @param string $tYPE
     * @return \StructType\ELEMENT
     */
    public function setTYPE($tYPE = null)
    {
        // validation for constraint: string
        if (!is_null($tYPE) && !is_string($tYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tYPE, true), gettype($tYPE)), __LINE__);
        }
        $this->TYPE = $tYPE;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\ELEMENT
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ELEMENT
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
