<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Prepare ServiceType
 * @subpackage Services
 */
class Prepare extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PrepareInvoiceResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PrepareInvoiceResponseRequest $request
     * @return \StructType\PrepareInvoiceResponseResponse|bool
     */
    public function PrepareInvoiceResponse(\StructType\PrepareInvoiceResponseRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareInvoiceResponse($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PrepareInvoiceResponseResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
