<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceRequest $request
     * @return \StructType\GetInvoiceResponse|bool
     */
    public function GetInvoice(\StructType\GetInvoiceRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoice($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserListRequest $request
     * @return \StructType\GetUserListResponse|bool
     */
    public function GetUserList(\StructType\GetUserListRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserList($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserListBinary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserListBinaryRequest $request
     * @return \StructType\GetUserListBinaryResponse|bool
     */
    public function GetUserListBinary(\StructType\GetUserListBinaryRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserListBinary($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceStatusRequest $request
     * @return \StructType\GetInvoiceStatusResponse|bool
     */
    public function GetInvoiceStatus(\StructType\GetInvoiceStatusRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceStatus($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceStatusAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceStatusAllRequest $request
     * @return \StructType\GetInvoiceStatusAllResponse|bool
     */
    public function GetInvoiceStatusAll(\StructType\GetInvoiceStatusAllRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceStatusAll($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEnvelope
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEnvelopeRequest $request
     * @return \StructType\GetEnvelopeResponse|bool
     */
    public function GetEnvelope(\StructType\GetEnvelopeRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEnvelope($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEnvelopeStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEnvelopeStatusRequest $request
     * @return \StructType\GetEnvelopeStatusResponse|bool
     */
    public function GetEnvelopeStatus(\StructType\GetEnvelopeStatusRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEnvelopeStatus($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getApplicationResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAppRespRequestType $request
     * @return \StructType\GetAppRespResponseType|bool
     */
    public function getApplicationResponse(\StructType\GetAppRespRequestType $request)
    {
        try {
            $this->setResult($this->getSoapClient()->getApplicationResponse($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceWithType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceWithTypeRequest $request
     * @return \StructType\GetInvoiceWithTypeResponse|bool
     */
    public function GetInvoiceWithType(\StructType\GetInvoiceWithTypeRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceWithType($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceCountRequest $request
     * @return \StructType\GetInvoiceCountResponse|bool
     */
    public function GetInvoiceCount(\StructType\GetInvoiceCountRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceCount($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAppRespResponseType|\StructType\GetEnvelopeResponse|\StructType\GetEnvelopeStatusResponse|\StructType\GetInvoiceCountResponse|\StructType\GetInvoiceResponse|\StructType\GetInvoiceStatusAllResponse|\StructType\GetInvoiceStatusResponse|\StructType\GetInvoiceWithTypeResponse|\StructType\GetUserListBinaryResponse|\StructType\GetUserListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
