<?php

namespace EnumType;

/**
 * This class stands for SIGNTYPE EnumType
 * @subpackage Enumerations
 */
class SIGNTYPE
{
    /**
     * Constant for value 'HSM_CUSTOMER'
     * @return string 'HSM_CUSTOMER'
     */
    const VALUE_HSM_CUSTOMER = 'HSM_CUSTOMER';
    /**
     * Constant for value 'HSM_ENTEGRATOR'
     * @return string 'HSM_ENTEGRATOR'
     */
    const VALUE_HSM_ENTEGRATOR = 'HSM_ENTEGRATOR';
    /**
     * Constant for value 'HSM_CLIENT_SIGNED'
     * @return string 'HSM_CLIENT_SIGNED'
     */
    const VALUE_HSM_CLIENT_SIGNED = 'HSM_CLIENT_SIGNED';
    /**
     * Constant for value 'TOKEN_CUSTOMER'
     * @return string 'TOKEN_CUSTOMER'
     */
    const VALUE_TOKEN_CUSTOMER = 'TOKEN_CUSTOMER';
    /**
     * Constant for value 'TOKEN_ENTEGRATOR'
     * @return string 'TOKEN_ENTEGRATOR'
     */
    const VALUE_TOKEN_ENTEGRATOR = 'TOKEN_ENTEGRATOR';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HSM_CUSTOMER
     * @uses self::VALUE_HSM_ENTEGRATOR
     * @uses self::VALUE_HSM_CLIENT_SIGNED
     * @uses self::VALUE_TOKEN_CUSTOMER
     * @uses self::VALUE_TOKEN_ENTEGRATOR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HSM_CUSTOMER,
            self::VALUE_HSM_ENTEGRATOR,
            self::VALUE_HSM_CLIENT_SIGNED,
            self::VALUE_TOKEN_CUSTOMER,
            self::VALUE_TOKEN_ENTEGRATOR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
