<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://connector.doganedonusum.com/EFaturaOIB?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://connector.doganedonusum.com/EFaturaOIB?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
/**
 * Sample call for Login operation/method
 */
if ($login->Login(new \StructType\LoginRequest()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \ServiceType\Logout($options);
/**
 * Sample call for Logout operation/method
 */
if ($logout->Logout(new \StructType\LogoutRequest()) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Load ServiceType
 */
$load = new \ServiceType\Load($options);
/**
 * Sample call for LoadInvoice operation/method
 */
if ($load->LoadInvoice(new \StructType\LoadInvoiceRequest()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for SendInvoice operation/method
 */
if ($send->SendInvoice(new \StructType\SendInvoiceRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendInvoiceResponse operation/method
 */
if ($send->SendInvoiceResponse(new \StructType\SendInvoiceResponseRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendInvoiceResponseWithServerSign operation/method
 */
if ($send->SendInvoiceResponseWithServerSign(new \StructType\SendInvoiceResponseWithServerSignRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetInvoice operation/method
 */
if ($get->GetInvoice(new \StructType\GetInvoiceRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserList operation/method
 */
if ($get->GetUserList(new \StructType\GetUserListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserListBinary operation/method
 */
if ($get->GetUserListBinary(new \StructType\GetUserListBinaryRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceStatus operation/method
 */
if ($get->GetInvoiceStatus(new \StructType\GetInvoiceStatusRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceStatusAll operation/method
 */
if ($get->GetInvoiceStatusAll(new \StructType\GetInvoiceStatusAllRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEnvelope operation/method
 */
if ($get->GetEnvelope(new \StructType\GetEnvelopeRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEnvelopeStatus operation/method
 */
if ($get->GetEnvelopeStatus(new \StructType\GetEnvelopeStatusRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getApplicationResponse operation/method
 */
if ($get->getApplicationResponse(new \StructType\GetAppRespRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceWithType operation/method
 */
if ($get->GetInvoiceWithType(new \StructType\GetInvoiceWithTypeRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceCount operation/method
 */
if ($get->GetInvoiceCount(new \StructType\GetInvoiceCountRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Mark ServiceType
 */
$mark = new \ServiceType\Mark($options);
/**
 * Sample call for MarkInvoice operation/method
 */
if ($mark->MarkInvoice(new \StructType\MarkInvoiceRequest()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for MarkEnvelope operation/method
 */
if ($mark->MarkEnvelope(new \StructType\MarkEnvelopeRequest()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for CheckUser operation/method
 */
if ($check->CheckUser(new \StructType\CheckUserRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Prepare ServiceType
 */
$prepare = new \ServiceType\Prepare($options);
/**
 * Sample call for PrepareInvoiceResponse operation/method
 */
if ($prepare->PrepareInvoiceResponse(new \StructType\PrepareInvoiceResponseRequest()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for CancelDraftInvoice operation/method
 */
if ($cancel->CancelDraftInvoice(new \StructType\CancelDraftInvoiceRequest()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
